# import the needed modules
from __future__ import absolute_import
from __future__ import print_function

try:
    import reflex

    import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")

# import the needed modules
try:
    #  import sys
    import numpy

    try:
        from astropy.io import fits as pyfits
    except ImportError:
        import pyfits

    import espdr_discrete_slider
    import espdr_plot_common
    import espdr_parameters_common
    #  import wx
    #  import matplotlib
    import reflex
    # from xsh_plot_common import *
    from reflex import parseSofJson, RecipeParameter
    from reflex_interactive_app import PipelineInteractiveApp
    import reflex_plot_widgets
    from pipeline_product import PipelineProduct
    from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay

    #  matplotlib.use('WXAgg')
    import_sucess = 'true'
    import warnings

    warnings.simplefilter('ignore', UserWarning)


    # NOTE for developers:
    # -If you want to modify the current script to cope
    #  with different parameters, this is the function to modify:
    #  setInteractiveParameters()
    # -If you want to modify the current script to read different data from
    #  the input FITS, these are the functions (class DataPlotterManager) to modify:
    #  readFitsData()    to indicate what are the FITS input to plot
    #  setRecId()        to set rec id (used in parameter prefix)
    #  getArmId()        to get arm id FITS header info
    #
    # -If you want to modify the current script to modify the plots (using the same
    #  data),  this is the function to modify:
    #  plotProductsGraphics()          (from class DataPlotterManager)
    # -If you want to modify the text that appears in the "Help" button,
    #  this is the function to modify:
    #  setWindowHelp()
    # -If you want to modify the title of the window, modify this function:
    #  setWindowTitle()

    # This class deals with the specific details of data reading and final plotting.
    class DataPlotterManager:

        # This function will read all the columns, images and whatever is needed
        # from the products. The variables , self.plot_x, self.plot_y, etc...
        # are used later in function plotProductsGraphics().
        # Add/delete these variables as you need (only that plotProductsGraphics()
        # has to use the same names).
        # You can also create some additional variables (like statistics) after
        # reading the files.
        # If you use a control variable (self.xxx_found), you can modify
        # later on the layout of the plotting window based on the presence of
        # given input files.
        # sof contains all the set of frames
        def readFitsData(self, fitsFiles):
            # Control variable to check if the interesting files where at the input
            # print fitsFiles
            self.fibre_id = 'fib A'
            self.nima = 0
            self.binx = 1
            self.biny = 1
            self.decode_bp = 2147483647
            self.plot = 'table'
            self.fibre_id = 'fib A'
            self.order_id = 10
            self.ext_ima = 1
            self.image_id = 'S2D_STD_A'
            self.product_id = 'ABS_EFF_A'
            self.labels_fib = ['fib A', 'fib B']
            self.labels_tab = list()
            self.labels_ima = list()
            self.labels_err = ['yes', 'no']
            self.error_id = 'no'

            self.eff_ab_found = False
            self.eff_ab_raw_found = False
            self.instrume = 'ESPRESSO'
            self.ima_sy = 1000
            # Read all the products
            frames = dict()
            # print(frames)
            for frame in fitsFiles:
                if frame == '':
                    continue

                header = pyfits.open(frame.name)
                # Make sure to have only products from the same recipe
                # that used this (common) script
                # print "self rec_id=", self.rec_id
                if 'ESO PRO REC1 ID' in header[0].header:
                    rec_id = header[0].header['ESO PRO REC1 ID']
                    self.instrume = header[0].header['INSTRUME']
                    if rec_id == self.rec_id:
                        category = frame.category
                        frames[category] = frame
                        # print("frame name:", frame.name)

            # For any arm search a list of input frames
            # print frames
            key = "ABS_EFF_A"
            if key in frames:
                hdulist = frames[key]
                self.abs_eff_a_found = True
                hdulist = frames[key]
                self.abs_eff_a = PipelineProduct(hdulist)
                self.labels_tab.append(key)
                # print("found", key)

                key = 'ESO OBS TARG NAME'
                self.obs_targ_name = self.abs_eff_a.readKeyword(key)
                self.abs_eff_a.readTableColumn(fits_extension=1, colname="wavelength")
                self.wave = self.abs_eff_a.column
                self.wmin = self.wave.min()
                self.wmax = self.wave.max()
                # print("wmin:",self.wmin,"wmax:",self.wmax)

                key = 'ESO INS MODE'
                self.ins_mode = self.abs_eff_a.readKeyword(key)
                # print(self.ins_mode)
                if self.ins_mode == 'SINGLEHR':
                    self.ord_max = 170
                elif self.ins_mode == 'HARPS':
                    self.ord_max = 71
                elif self.ins_mode == 'EGGS':
                    self.ord_max = 71
                elif self.ins_mode == 'HA':
                    self.ord_max = 70
                elif self.ins_mode == 'HE':
                    self.ord_max = 70
                else:
                    self.ord_max = 86

                self.eff_ab_found = True
                self.eff_a = list()
                self.order_nb_a = list()
                port = 0
                for ord in range(1, self.ord_max):
                    key = 'ESO QC ORDER%#.1d SNR' % (ord)
                    self.order_nb_a.append(ord)
                    self.eff_a.append(self.abs_eff_a.readKeyword(key))

                key = 'ESO QC MEAN ABS EFF'
                # print(key)
                self.mean_abs_eff_a = self.abs_eff_a.readKeyword(key)
                key = 'ESO QC CALFLUX CHECK'
                self.qc_calflux_check = self.abs_eff_a.readKeyword(key)

            key = "ABS_EFF_RAW_A"
            if key in frames:
                hdulist = frames[key]
                self.abs_eff_raw_a_found = True
                self.labels_tab.append(key)
                hdulist = frames[key]
                self.abs_eff_raw_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "AVG_FLUX_STD_A"
            if key in frames:
                hdulist = frames[key]
                self.avg_flux_std_a_found = True
                self.labels_tab.append(key)
                hdulist = frames[key]
                self.avg_flux_std_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "S1D_STD_A"
            if key in frames:
                hdulist = frames[key]
                self.s1d_std_a_found = True
                self.labels_tab.append(key)
                hdulist = frames[key]
                self.s1d_std_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "S1D_ENERGY_STD_A"
            if key in frames:
                hdulist = frames[key]
                self.s1d_energy_std_a_found = True
                self.labels_tab.append(key)
                hdulist = frames[key]
                self.s1d_energy_std_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "S2D_STD_A"
            if key in frames:
                hdulist = frames[key]
                self.s2d_std_a_found = True
                self.labels_ima.append(key)
                hdulist = frames[key]
                self.s2d_std_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "S2D_BLAZE_STD_A"
            if key in frames:
                hdulist = frames[key]
                self.s2d_blaze_std_a_found = True
                self.labels_ima.append(key)
                hdulist = frames[key]
                self.s2d_blaze_std_a = PipelineProduct(hdulist)
                # print("found", key)

        # Set rec id (to have proper recipe parameters prefix)
        def setRecId(self, rec_id):
            # Recipe ID variable to properly define params
            self.rec_id = rec_id

        # Get arm setting
        def getArmId(self, sof):
            # Recipe ID variable to properly define params
            self.rec_id = "espdr_cal_flux"
            nf = 0
            self.instrume = 'Undefined'
            frames = dict()
            files = sof.files
            for f in files:
                frame = f.name
                if frame == '':
                    continue
                else:
                    nf += 1
                    hdulist = pyfits.open(frame)
                    rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
                    self.instrume = hdulist[0].header['INSTRUME']
            if nf != 0:
                self.rec_id = rec_id_list[0:]

            # print("self.rec_id", self.rec_id)
            if self.rec_id == "espdr_cal_flux":
                self.rec_subtitle = "Efficiency Computation. "

        # This function creates all the subplots. It is responsible for the plotting
        # layouts.
        # There can different layouts, depending on the availability of data
        # Note that subplot(I,J,K) means the Kth plot in a IxJ grid
        # Note also that the last one is actually a box with text, no graphs.
        def addSubplots(self, figure):
            nrows = self.nima
            if self.eff_ab_found == True:

                self.subplot_image = figure.add_subplot(4, 1, 1)
                self.subplot_spectrum = figure.add_subplot(4, 1, 2)
                self.subplot_scatter = figure.add_subplot(4, 1, 3)
                # self.image_selector = figure.add_axes([-0.03, 0.90, 0.2, 0.1],aspect='equal')
                self.image_selector = figure.add_axes([0.00, 0.01, 0.40, 0.17])

                self.product_selector = figure.add_axes([0.60, 0.01, 0.35, 0.17])
                self.order_selector = figure.add_axes([0.11, 0.015, 0.25, 0.02])
                # self.error_selector = figure.add_axes([0.45, 0.05, 0.13, 0.13],aspect='equal')
            else:
                self.subtext_nodata = figure.add_subplot(1, 1, 1)

        def plotWidgets(self):
            widgets = list()

            labels_ima = self.labels_ima
            self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.image_selector,
                                                                               self.setImaSelectCallBack, labels_ima, 0,
                                                                               title="Control upper panels")
            widgets.append(self.radiobutton_pro)

            labels_tab = self.labels_tab
            self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.product_selector,
                                                                               self.setProductSelectCallBack,
                                                                               labels_tab, 0,
                                                                               title="Control bottom panel")
            widgets.append(self.radiobutton_pro)

            min = 0
            val = self.order_id

            max = self.ima_sy
            title_slider = "Select order id by clicking with mouse left button"
            self.slider = espdr_discrete_slider.InteractiveSlider2(self.order_selector, self.setOrderSelectCallBack,
                                                                   min, max, val, 1, "order no")

            widgets.append(self.slider)

            # labels_err = self.labels_err
            # self.radiobutton_tab = reflex_plot_widgets.InteractiveRadioButtons(self.error_selector, self.setErrorSelectCallBack, labels_err, 1, title="plot error?")
            # widgets.append(self.radiobutton_tab)

            return widgets

        def setOrderSelectCallBack(self, order_id):

            self.order_id = int(order_id)
            self.subplot_spectrum.cla()
            self.plotSpectrum()

        def setImaSelectCallBack(self, ima_id):

            self.image_id = ima_id
            self.subplot_image.cla()
            self.subplot_spectrum.cla()
            self.plotImage()
            self.plotSpectrum()

        def setProductSelectCallBack(self, product_id):
            self.product_id = product_id
            # print("product_id:", self.product_id)
            p_len = len(self.product_id)
            if self.fibre_id == 'fib A' and self.product_id[-1] == 'B':
                self.product_id = self.product_id[0:p_len - 1] + 'A'
                self.labels_tab = ['ABS_EFF_A']

            elif self.fibre_id == 'fib B' and self.product_id[-1] == 'A':
                self.product_id = self.product_id[0:p_len - 1] + 'B'
                self.labels_tab = ['ABS_EFF_B']

            self.subplot_scatter.cla()
            self.plotQC()

        def setFibreSelectCallBack(self, fibre_id):
            self.fibre_id = fibre_id
            p_len = len(self.product_id)
            if self.fibre_id == 'fib A' and self.product_id[-1] == 'B':
                self.product_id = self.product_id[0:p_len - 1] + 'A'
            elif self.fibre_id == 'fib B' and self.product_id[-1] == 'A':
                self.product_id = self.product_id[0:p_len - 1] + 'B'

            self.subplot_image.cla()
            self.subplot_spectrum.cla()
            self.plotImage(fibre_id)
            self.plotSpectrum(fibre_id)

        def setErrorSelectCallBack(self, error_id):
            self.error_id = error_id
            # print("error id",self.error_id)
            self.subplot_scatter.cla()
            self.plotQC()

        def preparePlotImage(self):
            # 2D frame PRE format (predict/orderpos/2dmap/wavecal/flexcomp)
            # print("ima_id:",self.image_id)
            if self.image_id == 'S2D_STD_A':
                self.obj = self.s2d_std_a
                self.spc = self.s2d_std_a
                self.tooltip_frameON = """\
           Overscan corrected fibre arc lamp image. 
           """
            elif self.image_id == 'S2D_BLAZE_STD_A':
                self.obj = self.s2d_blaze_std_a
                self.spc = self.s2d_blaze_std_a
                self.tooltip_frameON = """\
           Overscan corrected blaze image. 
           """
            sy = self.obj.all_hdu[self.ext_ima].header['NAXIS2']
            self.ima_sy = sy

        def preparePlotQC(self):
            table = self.abs_eff_a
            x = 'wavelength'
            y = 'efficiency_interpolated'
            xLab = 'wavelength [$\AA$]'
            yLab = 'efficiency'
            title = 'efficiency'
            tooltip = 'plot of raw efficiency vs wavelength'
            # print("image id",self.image_id)
            if self.product_id == 'SNR':
                self.plot = 'scatter'
                xLab = 'Order number'
                yLab = 'SNR'
                x = self.order_nb_a
                y = self.eff_a
                total = self.mean_abs_eff_a
                title = 'SNR vs Order number. Total:%#.1d ' % (total)
                tooltip = 'plot of the SNR vs Order number'
                # print(len(x))
                # print(len(y))
            elif self.product_id == 'ABS_EFF_A':
                self.plot = 'table'
                x = 'wavelength'
                y = 'efficiency_interpolated'
                xLab = 'wavelength [$\AA$]'
                yLab = 'interpolated efficiency'
                title = 'efficiency'
                tooltip = 'plot of interpolated efficiency vs wavelength'
                table = self.abs_eff_a
            elif self.product_id == 'ABS_EFF_RAW_A':
                self.plot = 'table'
                x = 'wavelength'
                y = 'efficiency'
                xLab = 'wavelength [$\AA$]'
                yLab = 'efficiency'
                title = 'efficiency'
                tooltip = 'plot of raw efficiency vs wavelength'
                table = self.abs_eff_raw_a
            elif self.product_id == 'AVG_FLUX_STD_A':
                self.plot = 'table'
                x = 'wavelength'
                y = 'std_flux'

                xLab = 'wavelength [$\AA$]'
                yLab = 'flux [erg/s/cm$^2$/$\AA$]'
                title = 'Average Flux STD star'
                tooltip = 'plot of Average Flux STD star vs wavelength'
                table = self.avg_flux_std_a
            elif self.product_id == 'S1D_STD_A':
                self.plot = 'spectrum'
                x = 'wavelength'
                y = 'flux'
                xLab = 'wavelength [$\AA$]'
                yLab = 'flux [ADU]'
                title = 'merged STD star spectrum'
                tooltip = 'plot of extracted merged STD star fv spectrum vs wavelength'
                table = self.s1d_std_a
            elif self.product_id == 'S1D_ENERGY_STD_A':
                self.plot = 'spectrum'
                x = 'wavelength'
                y = 'flux'
                xLab = 'wavelength [$\AA$]'
                yLab = 'flux [erg/s/cm$^2$/$\AA$]'
                title = 'merged energy STD star spectrum'
                tooltip = 'plot of merged energy spectrum STD star vs wavelength'
                table = self.s1d_energy_std_a

            e = 'error'
            q = 'quality'
            self.title = title
            self.tooltip = tooltip
            self.table = table
            self.x = x
            self.y = y
            self.e = e
            self.q = q
            self.xLab = xLab
            self.yLab = yLab

        def prepTitleAndTooltipImage(self):
            title_pref = 'Linear-extracted and Merged Spectrum.'

            tooltip_spectrum = """\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """

            title_spectrum = title_pref

            # Image
            spec_frameON = ''
            # print "Recipe ID:",self.rec_id
            if self.rec_id == "espdr_cal_flux":
                if self.fibre_id == 'fib A':
                    self.spec_frame = 'Fibre A '
                else:
                    self.spec_frame = 'Fibre B '

            self.title_frame = self.spec_frame + ' [' + self.obs_targ_name + ']'
            self.dpm.verify_qc_check(self.subplot_image, self.qc_calflux_check, 1.15)

        def prepTitleAndTooltipSpectrum(self):

            self.title_spectrum = """Extracted Spectrum."""
            self.tooltip_spectrum = """
        Plot of the extracted spectrum.
        Select on the slider at the boottom left of the canvas to choose the order to display.
         """

        def plotImage(self):
            self.preparePlotImage()
            self.dpm.plotImageOnly(self.obj, self.ext_ima, self.binx, self.biny, 'X [pix]', 'Order number',
                                   self.subplot_image, self.title_frame, self.tooltip_frameON)

        def plotSpectrum(self):
            self.prepTitleAndTooltipSpectrum()

            s1da_title = "Spectrum Fibre A"
            s1da_tooltip = "Green: rebinned data; blue: equalized data.\n" \
                           "Click twice to change the wavelength range.\n" \
                           "Double-click to use the full wavelength range."
            s1da_y_label = r"Flux density [erg $\mathdefault{cm^2}$ " \
                           r"$\mathdefault{s^{-1}}$ $\mathdefault{nm^{-1}}$]"
            s1db_title = "Spectrum Fibre B"
            s1db_tooltip = "Grey: non-rebinned data; green: rebinned data; blue: " \
                           "equalized data."
            s1db_y_label = r"SNR / pixel size [$\mathdefault{nm^{-1}}$]"
            all_x_label = "Wavelength [nm]"
            self.title_spectrum

            self.dpm.plotImageSlice2(self.spc, self.spc, self.order_id, self.subplot_spectrum, self.title_spectrum,
                                     self.tooltip_spectrum, 'X [pix]', 'ADU')

        def plotQC(self):

            self.preparePlotQC()
            if self.plot == 'table':
                self.dpm.plotTable(self.table, self.x, self.y, self.xLab, self.yLab, self.subplot_scatter, self.title,
                                   self.tooltip, self.wave)
            elif self.plot == 'spectrum':
                self.dpm.plotTableErrQual(self.table, self.x, self.y, self.e, self.q, self.decode_bp, self.error_id,
                                          self.xLab, self.yLab, self.subplot_scatter, self.title, self.tooltip,
                                          wave=None)
            else:

                self.dpm.scatterPlotScatter2(self.subplot_scatter, self.x, self.y, self.xLab, self.yLab, self.title,
                                             self.tooltip)

        def caseNodata(self):
            # Data not found info
            self.subtext_nodata.set_axis_off()
            self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
            self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c',
                                     fontsize=18, ha='left', va='center', alpha=1.0)
            self.subtext_nodata.tooltip = """\
                                    Merged spectrum not found in the products"""
            # print "found no spectrum data"

        # This is the function that makes the plots.
        # Add new plots or delete them using the given scheme.
        # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
        # It is mandatory to add a tooltip variable to each subplot.
        # One might be tempted to merge addSubplots() and plotProductsGraphics().
        # There is a reason not to do it: addSubplots() is called only once at
        # startup, while plotProductsGraphics() is called always there is a resize.
        def plotProductsGraphics(self):
            if (self.eff_ab_found == True):
                self.dpm = espdr_plot_common.DataPlotterManager()
                self.prepTitleAndTooltipImage()
                self.plotImage()
                self.plotSpectrum()
                self.plotQC()
            else:
                self.caseNodata()

        # This function specifies which are the parameters that should be presented
        # in the window to be edited.
        # Note that the parameter has to be also in the in_sop port (otherwise it
        # won't appear in the window)
        # The descriptions are used to show a tooltip. They should match one to one
        # with the parameter list
        # Note also that parameters have to be prefixed by the 'recipe name:'

        def setInteractiveParameters(self):
            paramList = list()
            rec_id = self.rec_id
            self.par = espdr_parameters_common.Parameters()
            # self.par.setGeneralCalibParameters(paramList,rec_id)
            if rec_id == "espdr_cal_flux":
                self.par.setFluxParameters(paramList, "espdr_cal_flux", "all")

            else:
                print("recipe", rec_id, "not supported")

            return paramList

        def setWindowHelp(self):
            help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
            return help_text

        def setWindowTitle(self):
            title = self.instrume + ' Interactive Workflow: ' + self.rec_subtitle
            return title

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")
    raise

# This is the 'main' function
if __name__ == '__main__':

    # import reflex modules
    from reflex import *
    from reflex_interactive_app import *
    from pipeline_display import *
    from pipeline_product import *

    # Create interactive application
    interactive_app = PipelineInteractiveApp(enable_init_sop=True)

    # PECULIAR XSH needs this in order to be able later to get from an input FITS
    # the ins-mode, arm (and recipe) IDs, used in titles and param setting
    # get inputs from the command line
    interactive_app.parse_args()
    inputs = interactive_app.inputs
    # (inputs, args) = interactive_app.parse_args()

    # Check if import failed or not
    if import_sucess == 'false':
        interactive_app.setEnableGUI(false)

    # interactive_app.setEnableGUI(false)
    # Open the interactive window if enabled
    if interactive_app.isGUIEnabled():
        # Get the specific functions for this window
        dataPlotManager = DataPlotterManager()
        # print inputs.in_sof
        # dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
        # With the following call XSH get the: ins-mode, arm (and recipe) IDs
        dataPlotManager.getArmId(inputs.in_sof)
        # Set recipe ID in order to build proper param list, display layout
        dataPlotManager.setRecId("espdr_cal_flux")

        interactive_app.setPlotManager(dataPlotManager)
        interactive_app.showGUI()
    else:
        interactive_app.passProductsThrough()

    # Print outputs. This is parsed by the Reflex python actor to get the results
    # Do not remove
    interactive_app.print_outputs()
    sys.exit()
