from adari_core.data_libs.master_raw_cuts import MasterRawCutsReport
from adari_core.utils.esodet import strip_prescan_overscan_espresso
import os

from .espresso_utils import EspressoReportMixin

center_size = 200


class EspressoMasterBiasReport(EspressoReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("espresso_master_bias")
        self.hist_bins_max = 50

    def remove_raw_scan(self, im_hdu, **kwargs):
        return strip_prescan_overscan_espresso(im_hdu, **kwargs)

    def parse_sof(self):
        # Need to generate two report sets:
        # MASTER_BIAS
        # MASTER_BIAS_RES
        first_raw = None
        master_bias = None
        master_bias_res = None
        for filename, catg in self.inputs:
            if catg == "MASTER_BIAS" and master_bias is None:
                master_bias = filename
            elif catg == "MASTER_BIAS_RES" and master_bias_res is None:
                master_bias_res = filename
            elif catg == "BIAS" and first_raw is None:
                first_raw = filename

        # Build and return the file name list
        file_lists = []
        if first_raw is not None:
            if master_bias is not None:
                file_lists.append({"raw_im": first_raw, "master_im": master_bias})
            if master_bias_res is not None:
                file_lists.append(
                    {
                        # 'raw_im': first_raw,
                        "master_im": master_bias_res
                    }
                )
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        exts = ["CCD290red", "CCD290blue"]

        for ext in exts:
            new_panels = super().generate_panels(
                master_im_ext=ext,
                raw_im_ext=ext,
                raw_title="First raw",
                master_title="Master bias",
            )
            for i, (panel, panel_descr) in enumerate(new_panels.items()):
                panel_descr["report_description"] = (
                    f"ESPRESSO bias panel - "
                    f"{os.path.basename(panel_descr['master_im'])}, "
                    f"{panel_descr['master_im_ext']}"
                )
            panels = {**panels, **new_panels}

        return panels


rep = EspressoMasterBiasReport()
