from adari_core.data_libs.master_raw_cuts import MasterRawCutsReport
import os

from .espresso_utils import EspressoReportMixin

center_size = 200


class EspressoMasterDarkReport(EspressoReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("espresso_master_dark")

    def parse_sof(self):
        # Need to generate two report sets:
        # MASTER_DARK
        master_dark = None

        for filename, catg in self.inputs:
            if catg == "MASTER_DARK" and master_dark is None:
                master_dark = filename

        # Build and return the file name list
        file_lists = []

        if master_dark is not None:
            file_lists.append({"master_im": master_dark})

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        exts = ["CCD290red", "CCD290blue"]

        for ext in exts:
            new_panels = super().generate_panels(
                master_im_ext=ext, master_title="Master dark"
            )
            for panel_descr in new_panels.values():
                panel_descr["report_description"] = (
                    f"ESPRESSO dark panel - "
                    f"{os.path.basename(panel_descr['master_im'])}, "
                    f"{panel_descr['master_im_ext']}"
                )
            panels = {**panels, **new_panels}

        return panels


rep = EspressoMasterDarkReport()
