from adari_core.plots.points import LinePlot
from adari_core.plots.text import TextPlot
from adari_core.data_libs.master_std_star_echelle import MasterSpecphotStdReport

import os

from .espresso_utils import EspressoReportMixin


class EspressoSpecphotStdReport(EspressoReportMixin, MasterSpecphotStdReport):
    def __init__(self):
        super().__init__("espresso_specphot_std")

    def parse_sof(self):
        abs_eff_catgs = ["ABS_EFF_A"]
        s1d_std_catgs = ["S1D_STD_A"]
        raw_catgs = ["FLUX"]

        abs_eff_a = None
        s1d_std_a = None
        raw = None
        for filename, catg in self.inputs:
            if catg in abs_eff_catgs:
                abs_eff_a = filename
            if catg in s1d_std_catgs:
                s1d_std_a = filename
            if catg in raw_catgs:
                raw = filename

        file_lists = []
        if abs_eff_a is not None and s1d_std_a is not None and raw is not None:
            file_lists.append(
                {
                    "eff": abs_eff_a,
                    "std": s1d_std_a,
                    "raw": raw,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        vspace = 0.5

        panels = super().generate_panels(
            eff_label="efficiency_interpolated",
            raw_im_ext=[("CCD290blue", "CCD290red")],
            n_raw_ext=2,
            raw_cut_centre=False,
        )
        for i, (panel, panel_descr) in enumerate(panels.items()):
            file_lists = self.hdus[i]

            abs_eff_a = file_lists["eff"]
            s1d_std_a = file_lists["std"]

            # Text Plot
            t1 = TextPlot(columns=1, v_space=vspace)
            fname = os.path.basename(str(abs_eff_a.filename()))
            col1 = (
                str(abs_eff_a["PRIMARY"].header.get("INSTRUME")),
                "EXTNAME: " + str(abs_eff_a[1].header.get("EXTNAME", "N/A")),
                "PRO CATG: "
                + str(abs_eff_a["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(
                    abs_eff_a["PRIMARY"].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")
                ),
            )
            t1.add_data(col1)
            panel.assign_plot(t1, 0, 0, xext=2)

            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = (
                "INS.MODE: "
                + str(abs_eff_a["PRIMARY"].header.get("HIERARCH ESO INS MODE")),
                "DET.BINX: "
                + str(abs_eff_a["PRIMARY"].header.get("HIERARCH ESO DET BINX")),
                "DET.BINY: "
                + str(abs_eff_a["PRIMARY"].header.get("HIERARCH ESO DET BINY")),
                "TELESCOP: " + str(abs_eff_a["PRIMARY"].header.get("TELESCOP")),
                "OBS.TARG.NAME: "
                + str(abs_eff_a["PRIMARY"].header.get("HIERARCH ESO OBS TARG NAME")),
            )
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

            # ESPRESSO specific panel
            # Extracted flux ERROR vs wavelength
            eflux_v_wavl = LinePlot(title="Extracted flux error vs. wavelength")
            eflux_v_wavl.add_data(
                [s1d_std_a[1].data["wavelength"], s1d_std_a[1].data["error"]],
                label="Extracted flux error",
            )
            eflux_v_wavl.x_label = "Wavelength (Angstrom)"
            eflux_v_wavl.y_label = "Extracted flux error (electrons)"
            panel.assign_plot(eflux_v_wavl, 0, 3, xext=2)

        return panels


rep = EspressoSpecphotStdReport()
