/* 
 * This file is part of the FORS Data Reduction Pipeline
 * Copyright (C) 2002-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef FORS_BARYCORR_H
#define FORS_BARYCORR_H

#include <cpl.h>

CPL_BEGIN_DECLS

cpl_error_code
fors_barycorr_adjust_header(
    cpl_propertylist * header,
    const char * keyword,
    double barycorr);

int fors_calculate_barycorr(
    const cpl_frameset *frameset,
    const char *science_tag,
    const cpl_frame *eop_frame,
    double wavelength,
    double *barycorr);

int fors_apply_barycorr_image(
    cpl_propertylist *header,
    const double barycorr,
    const int apply_barycorr);

CPL_END_DECLS

#endif
