/*
 * This file is part of the FORS Library
 * Copyright (C) 2002-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */


#ifndef FORS_IMG_IDP_H
#define FORS_IMG_IDP_H

#include <cpl.h>
#include "fors_image.h"
#include "fors_star.h"
#include "fors_dfs_idp.h"

struct fors_img_idp_quality {

  const double psf_fwhm;
  const double psf_fwhm_pix;
	const double elliptic;
	const double sigma_sky;
	const double sky_mag;
	const double pre_overscan_level;
	const cpl_table * sources;

	fors_img_idp_quality(
          const double psf_fwhm,
          const double psf_fwhm_pix,
	        const double elliptic,
	        const double sigma_sky,
	        const double sky_mag,
	        const double pre_overscan_level,
	        const cpl_table * sources):
                psf_fwhm(psf_fwhm),
                psf_fwhm_pix(psf_fwhm_pix),
                elliptic(elliptic),
                sigma_sky(sigma_sky),
                sky_mag(sky_mag),
                pre_overscan_level(pre_overscan_level),
                sources(sources)
	        {}
};



struct fors_img_idp_tags{
	const char * idp_image_name;
	const char * recipe_name;

	fors_img_idp_tags(const char * idp_image_name,
	        const char * recipe_name) :
	            idp_image_name(idp_image_name),
	            recipe_name(recipe_name) {}
};

bool fill_from_static_table(const cpl_frame * static_table,
    const char * filt_name,
    const double exptime, const double gain, const double amass,
    fors_idp_zp_data * out_data, double * amag_vega, double * wavecen);

bool calc_ab_mag_sat(const cpl_table * arg_sources,
        const double sky_med_level, const double overscan,
        const double photo_zp, const double ab_vega, double * res);

double calc_ab_mag_lim(const double zp, const double ab_mag_minus_vega,
    const double sigma_sky_pix,
    const double fwhm_pix, const double aperture_correction);

bool fors_img_idp_get_image_psf_fwhm(const fors_star_list *sources,
		const fors_setting * settings,
        const cpl_propertylist * sci_header,
        double * fwhm_idp, double * fwhm_pix_idp);


void fors_img_idp_save(cpl_frameset * frames, const fors_image * sci,
    const cpl_image * bpm,
		cpl_propertylist * qc, cpl_propertylist * wcs_headers,
    const cpl_parameterlist * parameters,
		const cpl_frame * raw_science_frame, const cpl_frame * master_bias,
		const cpl_image * confidence_map, const double threshold_weigth,
		fors_img_idp_tags fnames, fors_img_idp_quality qty,
    double zp, double dsp, int nzp, char filter_band);

#endif
