/*
 * This file is part of the FORS Data Reduction Pipeline
 * Copyright (C) 2002-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * fors_response.h
 *
 *  Created on: 2014 4 2
 *      Author: cgarcia
 */

#ifndef FORS_RESPONSE_UTILS_H_
#define FORS_RESPONSE_UTILS_H_

#include "cpl.h"
#include "hdrl.h"
#include "spectrum.h"
#include "fors_detected_slits.h"

CPL_BEGIN_DECLS

void fors_extract_standard
(cpl_image *spectra, cpl_image *spectra_err,
 cpl_image * mapped_flat_sed,
 cpl_propertylist *flat_sed_header, cpl_table *objects,
 double& flat_sed_norm_factor,
 const fors::detected_slits& det_slits,
 cpl_image** spectrum, cpl_image** spectrum_sedcorr,
 cpl_image** spectrum_err, cpl_image** spectrum_sedcorr_err,
 cpl_size& brightest_idx);

std::pair<mosca::spectrum, mosca::spectrum> fors_scale_standard
(cpl_image *spectrum, cpl_image *spectrum_sedcorr,
 double startwave, double dispersion, double gain,
 double exptime);

cpl_table * fors_compute_response
(mosca::spectrum std_obs_spectrum,
 mosca::spectrum std_obs_spectrum_sedcorr,
cpl_table *ext_table, double airmass, cpl_table *flux_table,
 const std::vector<double>& ignored_waves,
 const std::vector<std::pair<double, double> >& ignored_wave_ranges,
 int nknots, int degree, cpl_table *& response_obs_binning);

void fors_science_correct_flat_sed
(cpl_image *spectra,  cpl_table *objects,
 cpl_image * mapped_flat_sed,
 cpl_propertylist * flat_sed_header,
 cpl_propertylist * specphot_header,
 const fors::detected_slits& det_slits);

void fors_science_correct_flat_sed_mapped
(cpl_image *mapped_image,  cpl_table *objects,
 cpl_image * mapped_flat_sed,
 cpl_propertylist * flat_sed_header,
 cpl_propertylist * specphot_header,
 const fors::detected_slits& det_slits);

void fors_load_ref_table
(const cpl_frame* frm_ref, 
 double dRA, 
 double dDEC, 
 double EPSILON, 
 cpl_table** pptable,
 const char** star_name);

void fors_load_fp_table
(const cpl_frame* frm_ref, 
 const char* grism_filter,
 const char* star_name,
 cpl_array** fit_points);

hdrl_spectrum1D * correct_spectrum_for_doppler_shift
(const hdrl_spectrum1D * s,
const hdrl_data_t offset);

hdrl_spectrum1D * gaussian_convolve
(hdrl_spectrum1D * s,
 cpl_size kernel_size,
 double sigma);

cpl_table* create_response_table(
    const std::vector<double>& wave_tab,
    const std::vector<double>& flux_tab,
    const std::vector<double>& flux_obs,
    const std::vector<double>& efficiency_raw,
    const std::vector<double>& efficiency_fit,
    const std::vector<double>& response_raw);

void update_response_table(
    cpl_table* response_table,
    const std::vector<double>& response_fit);

void update_response_table_ffsed(
    cpl_table* response_table,
    const std::vector<double>& flux_obs,
    const std::vector<double>& response_raw,
    const std::vector<double>& response_fit);

cpl_table * create_resp_eff_table(
    const std::vector<double>& wave_tab,
    const char* resp_col,
    const std::vector<double>& resp_tab,
    const char* eff_col,
    const std::vector<double>& eff_tab);

hdrl_spectrum1D * get_median_on_fit_points(
    const hdrl_spectrum1D * s_input,
		const cpl_array * fit_points,
    const hdrl_data_t wrange);

CPL_END_DECLS

#endif /* FORS_RESPONSE_UTILS_H_ */
