/* $Id: $
 *
 * This file is part of the FORS Library
 * Copyright (C) 2002-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef FORS_ZEROPOINT_UTILS_H
#define FORS_ZEROPOINT_UTILS_H

#include <cpl.h>
#include "fors_star.h"

CPL_BEGIN_DECLS

double
get_zeropoint(fors_star_list *stars, 
              double cutoffE,
              double cutoffk,
              double dext_coeff,
              double dcolor_term,
              double avg_airmass,
              double *dzeropoint,
              int *n);

void
calculate_zp_from_gaia(char filter_band,
                       double cutoffe,
                       double cutoffk,
                       cpl_table* phot,
                       cpl_table** phot_stds_to_save,
                       cpl_table** updated_stars_to_save,
                       cpl_propertylist* img_header,
                       const char* cacheloc,
                       double color_term,
                       double dcolor_term,
                       double& zp,
                       double& dzp,
                       int& nzp);

CPL_END_DECLS

#endif

