/* $Id: mosca_pfits.h,v 1.12 2011-10-24 13:08:17 cgarcia Exp $
 *
 * This file is part of the MOSCA Library
 * Copyright (C) 2002-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef MOSCA_PFITS_H
#define MOSCA_PFITS_H

#include <cpl.h>

CPL_BEGIN_DECLS

#define MOSCA_PFITS_DEFAULT 0
#define MOSCA_PFITS_FORS_NGC 1

static const char *const MOSCA_BINX[2] = {"ESO DET WIN1 BINX", "ESO DET BINX"};
static const char *const MOSCA_BINY[2] = {"ESO DET WIN1 BINY", "ESO DET BINY"};
static const char *const MOSCA_PIXSZX[2] = {"ESO DET CHIP1 PSZX",
                                            "ESO DET CHIP1 PSZX"};
static const char *const MOSCA_PIXSZY[2] = {"ESO DET CHIP1 PSZY",
                                            "ESO DET CHIP1 PSZY"};
static const char *const MOSCA_CHIP_ID[2] = {"ESO DET CHIP1 ID",
                                             "ESO DET CHIP1 ID"};

size_t mosca_pfits_version_get(const cpl_propertylist* self);

CPL_END_DECLS

#endif
