# AREA A1: the import statements
# import statements needed by esoreflex
import reflex
import sys
from argparse import ArgumentParser
import json
import os

import copy
import numpy as np
from astropy.io import fits
# END OF AREA A1
if __name__ == '__main__':

    # ***  PART P1: Input/output ports ***
    #Define inputs/outputs
    parser = reflex.ReflexIOParser()
    parser.add_option("-i", "--in_sof", dest="in_sof")
   # parser.add_output("-o", "--out_sof", dest="out_sof")
    parser.add_input("-p", "--in_sop", dest="in_sop")
    parser.add_output("-k", "--out_sop", dest="out_sop")
    inputs = parser.get_inputs()
    outputs = parser.get_outputs()
    in_sof = inputs.in_sof
    files = in_sof.files
    #define script input parameters
    params=inputs.in_sop
    values={}
    min_sn = -9999.
    for param in params:
        values[param.name]=param.value
    min_sn=values["fors_select_higher_sn.min_snr_to_correct"]    

    #Define the list of outputs
    output_files=list()
    output_datasetname=in_sof.datasetName
    
    #Get the name of the output directory
    pattern = '--products-dir'
    for arg in sys.argv:
        if arg.split("=")[0] == pattern:
            output_dir = arg.split("=")[1]

    # ***  END OF PART P1 ***
    # ***  PART P2: customized part***
    sci_suffix=["REDUCED_IDP_SCI_LSS","REDUCED_IDP_SCI_MOS","REDUCED_IDP_SCI_MXU","REDUCED_IDP_STD_MOS","REDUCED_IDP_STD_MOS_SEDCORR"]
    
    for file in files:
       if file.category in sci_suffix:       
          hdu=fits.open(file.name)
          sn_file = hdu[0].header['SNR']
          if sn_file >= min_sn:
              ret = "true"
          else:
              ret = file.name+"_false"

    outputs.out_sop=ret
    parser.write_outputs()
    sys.exit()
 
