# AREA A1: the import statements
# import statements needed by esoreflex
import reflex
import sys
from argparse import ArgumentParser
import json
import os

import copy
import numpy as np
from astropy.io import fits
# END OF AREA A1

# AREA A2: the algorithm(s).


# END OF AREA A2


# AREA A3: the interface.
# This is the main Phython script. It contains 2 general parts and a
# customized part, that is responsible of calling the desired
# reduction function.

if __name__ == '__main__':

    # ***  PART P1: Input/output ports ***

    #Define inputs/outputs
    parser = reflex.ReflexIOParser()
    parser.add_option("-i", "--in_sof", dest="in_sof")
    parser.add_output("-o", "--out_sof", dest="out_sof")
    #parser.add_input("-k", "--extra_input_port", dest="extra_input_port")
    #parser.add_output("-q", "--extra_output_port", dest="extra_output_port")
    inputs = parser.get_inputs()
    outputs = parser.get_outputs()
    in_sof = inputs.in_sof
    files = in_sof.files
    
    #Define the list of outputs
    output_files=list()
    output_datasetname=in_sof.datasetName
    
    #Get the name of the output directory
    pattern = '--products-dir'
    for arg in sys.argv:
        if arg.split("=")[0] == pattern:
            output_dir = arg.split("=")[1]

    # ***  END OF PART P1 ***
    
    # ***  PART P2: customized part***
    sci_suffix=["REDUCED_IDP_SCI_LSS","REDUCED_IDP_SCI_MOS","REDUCED_IDP_SCI_MXU","REDUCED_IDP_STD_MOS","REDUCED_IDP_STD_MOS_SEDCORR"]

    files_ok=[]
    for file in files:
        
        if file.category in sci_suffix:
            files_ok.append(file)
    if len(files_ok) != 0:
        
       found_one=0
       sn=-9999.
       for file in files_ok: 
          hdu=fits.open(file.name,mode='readonly')
          sn_i=hdu[0].header['SNR']
          wmax = hdu[0].header['WAVELMAX']
          hdu.close()
          if ((sn_i >= sn) & (wmax > 706)) :
             sn=sn_i
             higher_sn_file=file
             found_one=1
       if found_one == 0:
          output_files=[]  #[list]: empty file list
       else:
          output_files=[higher_sn_file]  #[list]: output files are the same as input files
       # *** END OF PART P2***
       #for file in output_files:
       #    print(file.name, file.category)

    # *** PART P3: broadcast products ***
       
    new_sof = reflex.SetOfFiles(output_datasetname,output_files)
    outputs.out_sof = new_sof
    # broadcast outputs:
    parser.write_outputs()
     
    sys.exit()
    # ***  END OF AREA A3***
