import os
import sys
import re
from astropy.io import fits
import reflex
import importlib
import numpy as np

try :
    am = importlib.import_module('auto_molecule')
    iu = importlib.import_module('inst_utils')
except ImportError:
    sys.path.insert(0, '%s/instruments' %(os.path.dirname(__file__)))
    am = importlib.import_module('auto_molecule')
    iu = importlib.import_module('inst_utils')
except Exception as e:
    raise(e)
from fors_recipe_defaults import *

# molecfit_wkf generic methods...
'''
# ------------------------------------------------------------------------------------------
# This is a pass-through version of the check_format method
# It is commented out as an example of an "optional" method.
def check_format( files, output_dir ):
    output_files=list()
    for file in files:
        output_files.append(reflex.FitsFile(file.name, file.category, None, file.purposes ))
    return output_files
'''
# ------------------------------------------------------------------------------------------
def get_object(header=None) :
    return header.get('OBJECT','UNKNOWN')
# ------------------------------------------------------------------------------------------
def dataset_chooser_keywords() :
    return 'INSTRUME,OBJECT,INS.PATH,INS.MODE,PRO.CATG'
# ------------------------------------------------------------------------------------------
def set_inst_setup(header=None) :
    """
    Return the instrument setup.
    Generally a string built from various (primary) header keywords
    that identifies the instrument setup of the current science file.
    Different values of inst_setup will indicate when check_idp must set more than just
    file-format variables, usually indicates a change in WL-setup, e.g. VIS --> NIR for XSHOOTER
    """
    return 'UNKNOWN'
# ------------------------------------------------------------------------------------------
def check_format(files, output_dir):
    """
    Create a molecfit compatible input file from an incompatible file:
    e.g. extract a 1-d spectrum from a 2-d spectrum (for example by extracting the fibre with
    the highest S/N (GIRAFFE))
    """
    return files
# ------------------------------------------------------------------------------------------
wlg = 1.0e-04  # AA --> micron :: WLG_TO_MICRON
def set_parameters(header=None, hdu=None, previous_inst_setup='None', files=None) :
    """
    Set any parameters needed for all inst_settings for this instrument
    """

    """
    Concerning WAVELENGHTH_FRAME:
    WAVELENGTH_FRAME = VAC|AIR|VAC_RV
        VAC = vacuum+topocentric
        AIR = air+topocentric
        VAC_RV = vacuum+barycentric
    Molecfit handles internally these three cases.

    Any other combination should be transformed first to VAC in check_format()

    molecfit works in the TOPOCENTRIC frame (i.e. the earth reference frame).
    Data that has been corrected to barycentric or heliocentric frames should
    thus be first "transformed" back to topocentric for procesing, and then
    transformed back to the preferred frame after molecfit correction (e.g. in
    recombine_idps()), with the exception of vacuum+barycorr data which it knows
    how to handle [WAVELENGTH_FRAME=VAC_RV].

    While molecfit also "works" in VAC frame, it knows how to internally handle
    AIR frame data.

    inst_utils provides the following utility functions:
        bary_to_topo(wl [<any>], barycorr [km/s])
        topo_to_bary(wl [<any>], barycorr [km/s])
        air_to_vac(wl [micron], wlg) wl either in micron, or give wlg (wl_to_micron conversion factor)
        vac_to_air(wl [micron], wlg) wl either in micron, or give wlg (wl_to_micron conversion factor)
        heli_to_topo( wl [<any>], gcorr [km/s], hcorr [km/s] )
        topo_to_heli( wl [<any>], gcorr [km/s], hcorr [km/s] )
        heli_air_to_topo_vac( wl [<any>], gcorr [km/s], hcorr [km/s], wlg )
        topo_to_heli(vac_to_air( wl [<any>], gcorr [km/s], hcorr [km/s], wlg )
    """
    return {}
# ------------------------------------------------------------------------------------------
def check_idp(hdu, previous_inst_setup='None', files=None, ParameterInitialization=False, recipe=None, ) :
    """
    Set any parameters needed for the specific input file format (generally either FITS-Image
    or ESO-IDP stlye binary table).
    Also set wavelength ranges and molecules if instrument setup changes.
    """
    # Data format dependent setting of variables...
    if hdu[0].header.get('HIERARCH ESO PRO CATG','NULL') in [
            'REDUCED_IDP_SCI_LSS',                              # fors
            'REDUCED_IDP_STD_MOS',                              # fors
            'REDUCED_IDP_STD_MOS_SEDCORR',                      # fors
            'REDUCED_IDP_SCI_MOS',                              # fors
            'REDUCED_IDP_SCI_MXU',                              # fors
        ] :
        # IDP=binary-table-format format...
        # Obtainable from the ESO Science Archive facility
        # or by reducing with "--generate-SDP-format=true" with ESO PL
        # (Set WKF variable "" = true)
        clam="WAVE"
        cflux="FLUX"
        dd=hdu[1].data[cflux]
        wl_range=np.array([np.min(hdu[1].data[clam][0]),np.max(hdu[1].data[clam][0])])
        wl_resolution=np.max(hdu[1].data[clam][0][1:]-hdu[1].data[clam][0][0:-1])
    else:
        # these are the values to use for FLAMES spectra in generic PL format (no IDP)
        ## This section not fully implemented yet, so far we assume use of IDP versions
        raise('Non-IDP-format=non-binary-table-format input files not (yet) supported.')

    median_cont = float(np.median(dd[np.where(~np.isnan(dd))]))

    filenames={}
    if files is not None :
        for file in files:
            filenames[file.category]=file.name
    WL_inc_exc_PIX_exc=None
    inst_setup_changed = set_inst_setup(hdu[0].header) != previous_inst_setup
    try:
        # use the recipe defaults from fors_recipe_defaults as defaults:
        ll=np.array(WAVE_INCLUDE.split(',')[::2], dtype=float)
        ul=np.array(WAVE_INCLUDE.split(',')[1::2], dtype=float)
        wave_include=[]
        for i in range(np.min([len(ll),len(ul)])) :
            if ll[i] > wl_range[0]*wlg and ul[i] < wl_range[1]*wlg :
                wave_include+=[str(ll[i]),str(ul[i])]
        WL_inc_exc_PIX_exc={
            'LIST_MOLEC':   LIST_MOLEC,
            'FIT_MOLEC':    FIT_MOLEC,
            'REL_COL':      REL_COL,
            'WAVE_INCLUDE': ','.join(wave_include),
        }
    except :
        pass
    if (
        ( 'MOLECULES' in filenames.keys() and 'WAVE_INCLUDE' in filenames.keys() )
        or 
        WL_inc_exc_PIX_exc is None
    ) :
        WL_inc_exc_PIX_exc={}
        if ParameterInitialization :
            if set_inst_setup(hdu[0].header) != previous_inst_setup :
                ## ---------------------------------------------------------------------
                # Automatically set molecules and ranges...
                wl_span=wl_range[1]-wl_range[0]

                WL_ranges_to_include=am.auto_molecules_set_WL_ranges_to_include(
                    files,
                    wl_range,
                    wl_span,
                    wl_resolution,
                    wl_scale=1./wlg,
                    buff=wl_span*0.05,
                )
                WL_inc_exc_PIX_exc={
                    'LIST_MOLEC': WL_ranges_to_include['list_mol'],
                    'FIT_MOLEC': WL_ranges_to_include['fit_mol'],
                    'REL_COL': WL_ranges_to_include['rel_col'],
                    'WAVE_INCLUDE': WL_ranges_to_include['wave_include'],
                    'WAVE_EXCLUDE': WL_ranges_to_include['wave_exclude'],
                    'PIXEL_EXCLUDE': WL_ranges_to_include['pixel_exclude'],
                }
                ## ---------------------------------------------------------------------

    return dict(
        list(({
            # Only set the following if the canvas value is NULL
            'ignore_if_not_NULL': {} if inst_setup_changed else WL_inc_exc_PIX_exc,
        }).items())
        +
        list((WL_inc_exc_PIX_exc if inst_setup_changed else {}).items())
    )
# ------------------------------------------------------------------------------------------
def recombine_idps( files=None, orig_files=None ) :
    """
    Apply molecfit_correct results back to original molecfit-incompatible file.
    e.g. apply the correction calcuated for the highest S/N fibre 1-d spectrum back onto each
    fibre of the original input 2-d GIRAFFE spectrum 
    """
    return files
# ------------------------------------------------------------------------------------------
# ------------------------------------------------------------------------------------------
# ------------------------------------------------------------------------------------------
# -----   INST specific methods   ----------------------------------------------------------
# ------------------------------------------------------------------------------------------
# ------------------------------------------------------------------------------------------
def inst_specific_method() :
    pass
