# AREA A1: the import statements
# import statements needed by esoreflex
from astropy.io import fits
from astropy.io.fits import hdu
import reflex
import sys
from argparse import ArgumentParser
import json
import os
import importlib
import json
import copy
import re

# Import statements needed by the 
# algorithm to execute
from astropy.io import fits as fits
import numpy as np

try :
    iu = importlib.import_module('inst_utils')
except ImportError:
    sys.path.insert(0, '%s/instruments' %(os.path.dirname(__file__)))
    iu = importlib.import_module('inst_utils')
except Exception as e:
    raise(e)

# END OF AREA A1
# AREA A2: the algorithm(s).
# END OF AREA A2
# AREA A3: the interface.
# This is the main Python script. It contains 2 general parts and a
# customized part, that is responsible of calling the desired
# reduction function.
# ------------------------------------------------------------------------------------------
def do_stuff( files=None, orig_files=None ):
    hdu = fits.open(files[0].name,method='readonly')
    instrument=hdu[0].header['INSTRUME']

    try:
        # First try for a user version -- this allows users to "easily" set up support
        # for new instruments placing their python scripts somewhere a 'my_molecfit' directory
        # in a sys.path directory, e.g.:
        # on macOS:
        #   $HOME/Library/Python/3.6/lib/python/site-packages/my_molecfit
        # or on standard Linuxs
        #   $HOME/.local/lib/python3.6/site-packages/my_molecfit
        sys.path.insert(0, "%s/KeplerData/workflows/MyWorkflows/my_molecfit" %(os.environ.get('HOME')))
        inst = importlib.import_module('%s' %(instrument.lower()))
    except ImportError :
        try:
            # Then try the version that should be there in an installation...
            # When installed, the <inst>.py scripts are copied into the same directory
            # as this script...
            inst = importlib.import_module('%s' %(instrument.lower()))
        except ImportError :
            # then try the version that should be in instruments/ because in the
            # source the <inst>.py scripts are still in the instruments/ directory
            try:
                sys.path.insert(0, '%s/instruments' %(os.path.dirname(__file__)))
                inst = importlib.import_module('%s' %(instrument.lower()))
            except ImportError as e :
                raise e
    except Exception as e :
        raise e
    try:
        return inst.recombine_idps( files=files, orig_files=orig_files )
    except AttributeError :
        return files
    except ImportError as e :
        raise e
# ------------------------------------------------------------------------------------------
if __name__ == '__main__':

    # ***  PART P1: Input/output ports ***

    #Define inputs/outputs
    parser = reflex.ReflexIOParser()
    parser.add_option("-i", "--in_sof", dest="in_sof")
    parser.add_option("-o", "--orig_sof", dest="orig_sof")
    #parser.add_option("--current_inst_setup", dest="current_inst_setup")
    #parser.add_option("--previous_inst_setup", dest="previous_inst_setup")

    parser.add_output("-q", "--out_sof", dest="out_sof")
    #parser.add_output("--inst_setup", dest="inst_setup")

    inputs = parser.get_inputs()
    outputs = parser.get_outputs()
    in_sof = inputs.in_sof
    files = in_sof.files
    orig_sof = inputs.orig_sof
    orig_files = orig_sof.files

    #Define the list of outputs
    output_files=list()
    output_datasetname=in_sof.datasetName

    #Get the name of the output directory
    pattern = '^--products-dir='
    for arg in sys.argv:
        m=re.match(pattern, arg)
        if m is not None :
            output_dir = re.sub(pattern, '', arg)

    # ***  END OF PART P1 ***

    # ***  PART P2: customized part***
    ## For convenience, append BEST_FIT_PARAMETERS table to the products...
    BFP_hdulist=None
    BFP_header=None
    append_hdus={}
    for file in orig_files or {} :
        if file.category in [
            "BEST_FIT_PARAMETERS",
            ] :
            BFP_hdulist=fits.open(file.name)
            append_hdus["BEST_FIT_PARAMETERS"]={"hdu": BFP_hdulist[1],}
            # Find the keys for the recipe we need to propagate for...
            append_hdus["BEST_FIT_PARAMETERS"]["header"]=fits.Header()
            match_str=None
            for k in BFP_hdulist[0].header :
                if (
                    re.match('ESO DRS MF PARAM',k)
                ) :
                    append_hdus["BEST_FIT_PARAMETERS"]["header"].set('HIERARCH %s' %k,BFP_hdulist[0].header[k],BFP_hdulist[0].header.comments[k])
        elif file.category in [
            #"TELLURIC_CORR",   # 1-D image with no WCS
            "TELLURIC_DATA",   # BinTable with columns: chip, lambda, flux, weight, mlambda, mtrans, mweight, cflux, qual
            ] :
            TC_hdulist=fits.open(file.name)
            #append_hdus["ATM_TRANSMISSION"]={
            append_hdus[file.category]={
                "hdu": TC_hdulist[1],
                #"ORIG_PROCATG": file.category,
            }
            # append_hdus["TELLURIC_CORR"]["header"]=fits.Header()
            # In principal we should add the WCS, but the TC doesn't have one,
            # should make a ticket for that...

    if files != [] :
        for file in do_stuff( files=files, orig_files=orig_files ):
            hdulist=None
            for cat in [
                "BEST_FIT_PARAMETERS",
                #"TELLURIC_CORR",
                "TELLURIC_DATA",
                "ATM_TRANSMISSION",
            ] :
                if cat in append_hdus.keys() :
                    hdulist=hdulist or fits.open(file.name)
                    if isinstance(append_hdus[cat]["hdu"],fits.BinTableHDU) :
                        hdulist.append(fits.BinTableHDU(
                            data=copy.deepcopy(append_hdus[cat]["hdu"].data),
                            header=append_hdus[cat]["hdu"].header,
                        ))
                    else :
                        hdulist.append(fits.ImageHDU(
                            data=copy.deepcopy(append_hdus[cat]["hdu"].data),
                            header=append_hdus[cat]["hdu"].header,
                        ))
                    hdulist[-1].header['EXTNAME']=cat
                    if "header" in append_hdus[cat].keys() :
                        hdulist[-1].header+=append_hdus[cat]["header"]
                    if "ORIG_PROCATG" in append_hdus[cat].keys() :
                        hdulist[cat].header["ESO ORIG PRO CATG"]=append_hdus[cat]["ORIG_PROCATG"]
                    print("Appended %s to %s" %(cat,file.name))
            if hdulist is not None :
                print("Writing '%s'..." %(file.name))
                iu.HDUList(hdulist).writeto(
                    file.name, overwrite=True, checksum=True, output_verify='silentfix',
                )
                print("Wrote '%s'..." %(file.name))
                hdulist.close()
                hdulist=None
            output_files.append(reflex.FitsFile(file.name, file.category, None, file.purposes))

    # *** END OF PART P2***

    # *** PART P3: broadcast products ***
  
    # After the script is completed, the list of products is
    # broadcasted to the output sof.
    new_sof = reflex.SetOfFiles(output_datasetname,output_files)
    outputs.out_sof = new_sof    

    # Broadcast outputs on the extra output port.
    # broadcast outputs:
    parser.write_outputs()
    sys.exit()
    # ***  END OF PART P3 ***
    # ***  END OF AREA A3***    
