from adari_core.data_libs.master_raw_cuts import MasterRawCutsReport
from adari_core.plots.text import TextPlot
from .fors_utils import ForsSetupInfo

import os
import logging

from . import ForsReportMixin

logger = logging.getLogger(__name__)


class ForsMasterBiasReport(ForsReportMixin, MasterRawCutsReport):
    files_needed = {
        "master_im": "MASTER_BIAS",
    }

    def __init__(self):
        super().__init__("fors_bias")

    def parse_sof(self):
        """
        Returns a list of files selected from a set of frames (sof).

        If more than one file fullfills the criteria, the first file
        in the array will be selected.
        """
        file_path, files_category = (
            [elem[0] for elem in self.inputs],
            [elem[1] for elem in self.inputs],
        )
        file_lists = {}
        for required_file in self.files_needed.keys():
            # Check that category matches the requirement
            if self.files_needed[required_file] in files_category:
                file_lists[required_file] = file_path[
                    files_category.index(self.files_needed[required_file])
                ]
            else:
                raise IOError(
                    "[WARNING] {} file not found".format(
                        self.files_needed[required_file]
                    )
                )
        return [file_lists]

    def generate_panels(self, **kwargs):
        self.metadata = ForsSetupInfo.bias(list(self.hdus[0].values())[0])

        new_panels = super().generate_panels(
            master_im_ext="PRIMARY",
            master_title="Master bias",
            collapse_dir_1="y",
            collapse_dir_2="x",
        )  # reverse the x,y ordering to place y on top in the plot
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            panel_descr["report_description"] = (
                f"FORS bias panel - "
                f"{os.path.basename(panel_descr['master_im'])}, "
                f"{os.path.basename(panel_descr['master_procatg'])}, "
                f"{panel_descr['master_im_ext']}"
            )

            master_im = self.hdus[i]["master_im"]

            # Text Plot
            px = 0
            py = 0
            vspace = 0.3
            fname = os.path.basename(str(master_im.filename()))
            t1 = TextPlot(columns=1, v_space=vspace)

            col1 = (
                str(master_im["PRIMARY"].header.get("INSTRUME")),
                "EXTNAME: " + str(master_im["PRIMARY"].header.get("EXTNAME", "N/A")),
                "PRO CATG: "
                + str(master_im["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(
                    master_im["PRIMARY"].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")
                ),
            )
            t1.add_data(col1)

            panel.assign_plot(t1, px, py, xext=2)

            px = px + 2
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = self.metadata
            t2.add_data(col2)
            panel.assign_plot(t2, px, py, xext=1)

            hist = panel.retrieve(3, 1)
            hist.bins = 15

        return new_panels


rep = ForsMasterBiasReport()
