from adari_core.data_libs.master_rawdisp import MasterRawdispReport
import os
import numpy as np
from .fors_utils import ForsSetupInfo
from adari_core.plots.cut import CutPlot
from adari_core.plots.images import ImagePlot
from adari_core.utils.utils import fetch_kw_or_default
from . import ForsReportMixin


class ForsRawdispReport(ForsReportMixin, MasterRawdispReport):
    def __init__(self):
        super().__init__("fors_rawdisp")
        #rest here
        self.raw_extensions = {
            "CHIP1": "CHIP1",
            "CHIP2": "CHIP2"
        }

        self.extensions = []
        self.tasks = {
            "BIAS": "bias",
            #
            "DARK": "dark",
            #
            "SCREEN_FLAT_IMG": "flat_img",
            #
            "SKY_FLAT_IMG": "flat_img",
            #
            "STANDARD_IMG": "flat_img",
            #
            "STANDARD_LSS": "flat_spec",
            "STANDARD_MOS": "flat_spec",
            #
            "SCREEN_FLAT_MXU": "flat_spec",
            "SCREEN_FLAT_LSS": "flat_spec",
            "SCREEN_FLAT_MOS": "flat_spec",
            "SCREEN_FLAT_LSS_HC": "calibration_hc_lss",
            "LAMP_MXU": "flat_spec",
            "LAMP_MOS": "flat_spec",
            "LAMP_LSS": "flat_spec",
            "LAMP_LSS_HC": "calibration_hc_lss",
            "FLUX_FLAT_LSS": "flat_flux",
            "FLUX_ARC_LSS": "lamp_monitor_raw",
            #
            "SCREEN_FLAT_PMOS": "flat_spec_pmos",
            "LAMP_PMOS": "flat_spec_pmos",
            "STANDARD_PMOS": "flat_spec_pmos",
            "DETMON_LAMP_ON": "detector_monitor",
            "DETMON_LAMP_OFF": "detector_monitor",
            "FLAT_IPOL": "flat_ipol",
            "STANDARD_IPOL": "standard_ipol"
        }
        self.tasks_hc = {
            "SCREEN_FLAT_LSS": "calibration_hc_lss",
            "LAMP_LSS": "calibration_hc_lss",
        }

        self.select_raw_files = {}

        self.task_scaling = {}

        self.setup_info = ForsSetupInfo

    def parse_sof(self):
        # we building multiple report sets, so we append multiple reports to file_lists
        # get a list of tags
        tags = list(self.tasks.keys())
        added = {}
        file_lists = []
        # Workaround to distingush between HC and normal calibration tasks.
        # Since the reports do not receive the EDPS task name this is the only way to
        # distinguish between a normal LSS calibration, which has at least 6 files
        # as per the workflow rules and health check calibration which has only
        # one SCREEN_FLAT_LSS
        if len(self.inputs) < 6 and 'SCREEN_FLAT_LSS' in ([x[1] for x in self.inputs]) :
            self.tasks = self.tasks_hc
        for filename, catg in self.inputs:
            if catg in tags:
                if filename is not None and catg not in added:
                    file_lists.append({"filename": filename})
                    added[catg] = self.tasks[catg]
                    self.sof_tag.append(catg)        
        return file_lists

    def get_extensions(self):
        """Find the data extensions required for each FORS files.

        Description
        -----------
        After the SOF has been parsed, this method iterates over the different
        HDUS files to find which extension(s) contains the data.
        """
        new_hdus_list = []
        new_sof_tag = []
        for i, filedict in enumerate(self.hdus):
            hdul = filedict["filename"]
            all_hdu_names = [hdu.name for hdu in hdul]
            for chip_name in self.raw_extensions.keys():
                if chip_name in all_hdu_names:
                    new_hdus_list.append(filedict)
                    new_sof_tag.append(self.sof_tag[i])
                    self.extensions.append(chip_name)

        self.hdus = new_hdus_list
        self.sof_tag = new_sof_tag

    def generate_panels(self, **kwargs):
        panels = {}
        self.get_extensions()
        new_panels = super().generate_panels(ext=self.extensions, **kwargs)
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            # Alter the cut pos, or remove CutPlot(s) completely,
            # depending on task name
            try:
                task_name = panel_descr["task_name"]
            except KeyError as e:
                raise RuntimeError(
                    "A report has been created by "
                    "MasterRawdispReport that did "
                    "not come back with a task name "
                    "attached!"
                )
            panel_descr["report_name"] = "fors_rawdisp_{}_{}_{}_{}".format(
                task_name,
                self.raw_extensions[self.extensions[i]],
                self.sof_tag[i].lower(),
                os.path.basename(panel_descr["filename"]),
            )
            panel_descr["report_description"] = (
                f"FORS rawdisp panel - "
                f"{panel_descr['task_name']}, "
                f"{panel_descr['tag']}, "
                f"{os.path.basename(panel_descr['filename'])}, "
                f"{panel_descr['ext']}"
            )
        panels = {**panels, **new_panels}

        return panels


rep = ForsRawdispReport()
