from adari_core.utils.utils import fetch_kw_or_default, fetch_one_kw_of_range
import re

def metadata_detector(hdul):
    metadata = [
        "DET.READ.CLOCK: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO DET READ CLOCK", default="N/A"
            )
        ),                
        "DET.CHIP1.ID: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO DET CHIP1 ID", default="N/A"
            )
        ),
        "DET.WIN1.BINX: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO DET WIN1 BINX", default="N/A"
            )
        ),
        "DET.WIN1.BINY: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO DET WIN1 BINY", default="N/A"
            )
        ),
    ]
    return metadata

def metadata_img(hdul):
    img_metadata = [
        "INS.COLL.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS COLL NAME", default="N/A"
            )
        ),
        "INS.FILT1.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS FILT1 NAME", default="N/A"
            )
        ),
    ]
    return metadata_detector(hdul) + img_metadata

def metadata_ipol(hdul):
    ipol_metadata = [
        "INS.COLL.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS COLL NAME", default="N/A"
            )
        ),
    ]
    return metadata_detector(hdul) + ipol_metadata

def metadata_spec(hdul):
    metadata = [
        "INS.COLL.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS COLL NAME", default="N/A"
            )
        ),
        "INS.FILT1.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS FILT1 NAME", default="N/A"
            )
        ),
        "INS.GRIS1.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS GRIS1 NAME", default="N/A"
            )
        ),
        "INS.SLIT.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS SLIT NAME", default="N/A"
            )
        ),
    ]
    return metadata

def metadata_pmos(hdul):
    metadata = [
        "DET.READ.CLOCK: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO DET READ CLOCK", default="N/A"
            )
        ),
        "INS.COLL.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS COLL NAME", default="N/A"
            )
        ),
        "INS.WOLL.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS WOLL NAME", default="N/A"
            )
        ),
        "INS.FILT1.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS FILT1 NAME", default="N/A"
            )
        ),
        "INS.GRIS1.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS GRIS1 NAME", default="N/A"
            )
        ),
        "INS.OPTI4.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS OPTI4 NAME", default="N/A"
            )
        ),
        "INS.MOS.CHECKSUM: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS MOS CHECKSUM", default="N/A"
            )
        ),
    ]
    return metadata

class ForsSetupInfo:

    def bias(hdul):
        return metadata_detector(hdul)

    def dark(hdul):
        return metadata_detector(hdul)

    def detmon(hdul):
        return metadata_detector(hdul)

    def flat_img(hdul):
        return metadata_img(hdul)

    def flat_spec(hdul):
        return metadata_spec(hdul)

    def flat_spec_pmos(hdul):
        return metadata_pmos(hdul)

    def flat(hdul):
        metadata = [
            "DET.READ.CLOCK: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET READ CLOCK", default="N/A"
                )
            ),
            "INS.COLL.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS COLL NAME", default="N/A"
                )
            ),
            "INS.FILT1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS FILT1 NAME", default="N/A"
                )
            ),
            "DET.CHIP1.ID: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET CHIP1 ID", default="N/A"
                )
            ),
        ]
        return metadata

    def flat_2(hdul):
        header_list = list(hdul["PRIMARY"].header.keys())
        pattern = r'^ESO INS LAMP\d+ NAME$'
        res2 = [key for key in header_list if re.match(pattern, key)]
        metadata_2 = [
            "INS.GRIS1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS GRIS1 NAME", default="N/A"
                )
            ),
            "INS.SLIT.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS SLIT NAME", default="N/A"
                )
            ),
            "DET.WIN1.BINX: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET WIN1 BINX", default="N/A"
                )
            ),
            "DET.WIN1.BINY: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET WIN1 BINY", default="N/A"
                )
            ),
        ]
        if len(res2) == 1:
            n = [x for x in res2[0]][12]
            lamp_m = "INS.LAMP"+n+".NAME: " + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], res2[0], default="N/A"
                )
            ),
            metadata_2.append(lamp_m[0])
        return metadata_2

    def flat_flux(hdul):
        metadata = [
            "DET.READ.CLOCK: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET READ CLOCK", default="N/A"
                )
            ),
            "INS.COLL.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS COLL NAME", default="N/A"
                )
            ),
            "INS.FILT1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS FILT1 NAME", default="N/A"
                )
            ),
            "INS.GRIS1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS GRIS1 NAME", default="N/A"
                )
            ),
            "DET.CHIP1.ID: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET CHIP1 ID", default="N/A"
                )
            ),
                        "DET.WIN1.BINX: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET WIN1 BINX", default="N/A"
                )
            ),
            "DET.WIN1.BINY: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET WIN1 BINY", default="N/A"
                )
            ),

        ]
        return metadata

    def flat_flux_2(hdul):
        metadata = [
            "INS.GRIS1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS GRIS1 NAME", default="N/A"
                )
            ),
            "DET.CHIP1.ID: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET CHIP1 ID", default="N/A"
                )
            ),
            "INS.LAMP{0[0]}.NAME: {0[1]}".format(
                fetch_one_kw_of_range(
                    hdul["PRIMARY"],
                    "HIERARCH ESO INS LAMPx NAME",
                )
            ),
        ]
        return metadata

    def calibration_hc_lss(hdul):
        return metadata_detector(hdul) + metadata_spec(hdul)

    def lamp_monitor_raw(hdul):
        lamp_metadata = [
            "INS.COLL.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS COLL NAME", default="N/A"
                )
            ),
            "INS.FILT1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS FILT1 NAME", default="N/A"
                )
            ),
            "INS.GRIS1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS GRIS1 NAME", default="N/A"
                )
            ),
        ]
        return metadata_detector(hdul) + lamp_metadata

    def wave_cal_lss(hdul):
        wave_cal_lss_metadata = [
            "INS.COLL.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS COLL NAME", default="N/A"
                )
            ),
            "INS.FILT1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS FILT1 NAME", default="N/A"
                )
            ),
            "INS.GRIS1.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS GRIS1 NAME", default="N/A"
                )
            ),
            "INS.SLIT.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS SLIT NAME", default="N/A"
                )
            ),
        ]
        return metadata_detector(hdul) + wave_cal_lss_metadata
    
    def wave_cal_mos(hdul):
        return metadata_spec(hdul)

    def wave_cal_pmos(hdul):
        return metadata_pmos(hdul)
    
    def std_img(hdul):
        return metadata_img(hdul)
        
    def detector_monitor(hdul):
        return metadata_detector(hdul)

    def flat_ipol(hdul):
        return metadata_ipol(hdul)

    def standard_ipol(hdul):
        return metadata_ipol(hdul)

    def spec_std_star(hdul):
        m1 = ForsSetupInfo.flat_flux(hdul)
        m2 = [
            "SEQ.SPEC.TARG: " + str(hdul["PRIMARY"].header.get("HIERARCH ESO SEQ SPEC TARG", "N/A")),
            "OBS.TARG.NAME: " + str(hdul["PRIMARY"].header.get("HIERARCH ESO OBS TARG NAME", "N/A")),
        ]
        metadata = m1 + m2
        return metadata

    def spec_std_star_pmos(hdul):
        m1 = ForsSetupInfo.flat_spec_pmos(hdul)[:-1]
        m2 = metadata_detector(hdul)[1:]
        m3 = [
            "OBS.TARG.NAME: " + str(hdul["PRIMARY"].header.get("HIERARCH ESO OBS TARG NAME", "N/A")),
        ]
        metadata = m1 + m2 + m3
        return metadata
