from edps import classification_rule

from . import fors_keywords as kwd
from . import fors_rules as rules

# ---  CLASSIFICATION RULES ------------------------------------------------------------------------
is_fors = {kwd.instrume: ["FORS1", "FORS2"]}
is_calib = {**is_fors, kwd.dpr_catg: "CALIB"}
is_imaging_calib = {**is_calib, kwd.ins_mode: "IMG"}
is_lss_calib = {**is_calib, kwd.ins_mode: "LSS"}
is_mos_calib = {**is_calib, kwd.ins_mode: "MOS"}
is_pmos_calib = {**is_calib, kwd.ins_mode: "PMOS"}
is_mxu_calib = {**is_calib, kwd.dpr_tech: "PMOS"}
is_acquisition = {**is_fors, kwd.dpr_catg: "ACQUISITION"}
is_acquisition_hit = {**is_acquisition, kwd.ins_mode: "HIT"}
is_acquisition_lss = {**is_acquisition, kwd.ins_mode: "LSS"}
is_acquisition_mos = {**is_acquisition, kwd.ins_mode: "MOS"}
is_acquisition_mxu = {**is_acquisition, kwd.ins_mode: "MXU"}

# COMMON CALIBRATIONS
# Common raw calibrations
bias_class = classification_rule("BIAS", rules.is_bias)
dark_class = classification_rule("DARK", rules.is_dark)
detmon_on_class = classification_rule(
    "DETMON_LAMP_ON", {**is_fors, kwd.dpr_type: "FLAT,LAMP,DETCHECK"}
)
detmon_off_class = classification_rule(
    "DETMON_LAMP_OFF", {**is_fors, kwd.dpr_type: "BIAS,DETCHECK"}
)

# Common master calibrations or for instrument health checking
MASTERBIAS = classification_rule(
    "MASTER_BIAS", {**is_fors, kwd.pro_catg: "MASTER_BIAS"}
)
MASTERDARK = classification_rule(
    "MASTER_DARK", {**is_fors, kwd.pro_catg: "MASTER_DARK"}
)

# IMAGING CALIBRATIONS
# Imaging raw calibrations
cls_skyflat_img = classification_rule(
    "SKY_FLAT_IMG", {**is_imaging_calib, kwd.dpr_type: "FLAT,SKY"}
)
cls_std_img = classification_rule("STANDARD_IMG", rules.is_standard_img)
cls_std_img_wrong_coordinates = classification_rule(
    "STANDARD_IMG_wrong_coordinates", rules.is_standard_img_wrong_coordinates
)
cls_std_img_unsupported = classification_rule(
    "STANDARD_IMG", rules.is_standard_img_unsupported_filters
)
cls_science_img = classification_rule("SCIENCE_IMG", rules.is_science_img)
cls_science_img_wrong_coordinates = classification_rule(
    "SCIENCE_IMG_wrong_coordinates", rules.is_science_img_wrong_coordinates
)
cls_screenflat_img = classification_rule("SCREEN_FLAT_IMG", rules.is_screenflat_img)

# Imaging master calibrations
pcls_masterScreenFlat_img = classification_rule("MASTER_SCREEN_FLAT_IMG")
pcls_masterSkyFlat_img = classification_rule("MASTER_SKY_FLAT_IMG")
cls_aligned_phot = classification_rule("ALIGNED_PHOT")
SOURCES_STD_IMG = classification_rule("SOURCES_STD_IMG")
PHOT_BACKGROUND_STD_IMG = classification_rule("PHOT_BACKGROUND_STD_IMG")
STANDARD_REDUCED_IMG = classification_rule("STANDARD_REDUCED_IMG")

# Static imaging calibrations
cls_photTable = classification_rule("PHOT_TABLE")
cls_staticPhotTable = classification_rule("STATIC_PHOT_COEFF_TABLE")
cls_Phot_Coeff_Table = classification_rule("PHOT_COEFF_TABLE")
cls_flxStdImg = classification_rule("FLX_STD_IMG")
cls_detIllumReg = classification_rule("DETECTOR_ILLUMINATED_REGION")

# SPECTROSCOPY CALIBRATIONS
# Spectroscopy raw calibrations
screen_flat_lss_class = classification_rule("SCREEN_FLAT_LSS", rules.is_screen_flat_lss)
screen_flux_check_class2 = classification_rule(
    "FLUX_FLAT_LSS", rules.is_screen_flat_lss_few
)
screen_flat_mos_class = classification_rule("SCREEN_FLAT_MOS", rules.is_screen_flat_mos)
screen_flat_mxu_class = classification_rule("SCREEN_FLAT_MXU", rules.is_screen_flat_mxu)
screen_flat_std_class = classification_rule(
    "SCREEN_FLAT_MOS", rules.is_screen_flat_std
)  # std must be tagged as mos!
lamp_lss_class = classification_rule("LAMP_LSS", rules.is_lamp_lss)
wave_lss_check_class = classification_rule(
    "FLUX_ARC_LSS",
    {**is_lss_calib, kwd.dpr_tech: "INS-THROUGH", kwd.dpr_type: "WAVE,LAMP"},
)
flat_lss_check_class = classification_rule(
    "FLUX_FLAT_LSS",
    {**is_lss_calib, kwd.dpr_tech: "INS-THROUGH", kwd.dpr_type: "FLAT,LAMP"},
)
lamp_mxu_class = classification_rule("LAMP_MXU", rules.is_lamp_mxu)
lamp_mos_class = classification_rule("LAMP_MOS", rules.is_lamp_mos)
lamp_std_class = classification_rule(
    "LAMP_MOS",
    {
        **is_mos_calib,
        kwd.tpl_id: [
            "FORS1_specphot_cal_daycalib",
            "FORS1_specphot_cal_wave_fast",
            "FORS2_specphot_cal_daycalib",
            "FORS2_specphot_cal_wave_fast",
        ],
        kwd.dpr_type: "WAVE,LAMP",
    },
)
flat_hc_lss_class = classification_rule("SCREEN_FLAT_LSS", rules.is_flat_hc_lss)
wave_hc_lss_class = classification_rule("LAMP_LSS", rules.is_wave_hc_lss)
flat_hc_std_class = classification_rule("SCREEN_FLAT_MOS", rules.is_flat_hc_std)
wave_hc_std_class = classification_rule("LAMP_MOS", rules.is_wave_hc_std)
std_lss_class = classification_rule("STANDARD_LSS", rules.is_std_lss)
std_lss_class_wrong_coordinates = classification_rule(
    "STANDARD_LSS_wrong_coordinates", rules.is_std_lss_wrong_coordinates
)
std_mos1_class = classification_rule("STANDARD_MOS", rules.is_std_mos1)
std_mos1_class_wrong_coordinates = classification_rule(
    "STANDARD_MOS_wrong_coordinates", rules.is_std_mos1_wrong_coordinates
)
std_mos2_class = classification_rule("STANDARD_MOS", rules.is_std_mos2)
std_mos2_class_wrong_coordinates = classification_rule(
    "STANDARD_MOS_wrong_coordinates", rules.is_std_mos2_wrong_coordinates
)
sci_lss_class = classification_rule("SCIENCE_LSS", rules.is_sci_lss)
sci_mxu_class = classification_rule("SCIENCE_MXU", rules.is_sci_mxu)
sci_mos_class = classification_rule("SCIENCE_MOS", rules.is_sci_mos)
sci_lss_class_wrong_coordinates = classification_rule(
    "SCIENCE_LSS_wrong_coordinates", rules.is_sci_lss_wrong_coordinates
)
sci_mxu_class_wrong_coordinates = classification_rule(
    "SCIENCE_MXU_wrong_coordinates", rules.is_sci_mxu_wrong_coordinates
)
sci_mos_class_wrong_coordinates = classification_rule(
    "SCIENCE_MOS_wrong_coordinates", rules.is_sci_mos_wrong_coordinates
)

# Spectroscopic master calibrations
master_specphot_table_class = classification_rule("MASTER_SPECPHOT_TABLE")
global_distortion_table_class = classification_rule("GLOBAL_DISTORTION_TABLE")
master_norm_flat_lss = classification_rule("MASTER_NORM_FLAT_LSS")
disp_coeff_lss = classification_rule("DISP_COEFF_LSS")
slit_location_lss = classification_rule("SLIT_LOCATION_LSS")
flat_sed_lss = classification_rule("FLAT_SED_LSS")
master_norm_flat_long_mos = classification_rule("MASTER_NORM_FLAT_LONG_MOS")
disp_coeff_long_mos = classification_rule("DISP_COEFF_LONG_MOS")
slit_location_long_mos = classification_rule("SLIT_LOCATION_LONG_MOS")
flat_sed_long_mos = classification_rule("FLAT_SED_LONG_MOS")
specphot_table = classification_rule("SPECPHOT_TABLE")
master_norm_flat_mos = classification_rule("MASTER_NORM_FLAT_MOS")
disp_coeff_mos = classification_rule("DISP_COEFF_MOS")
slit_location_mos = classification_rule("SLIT_LOCATION_MOS")
curv_coeff_mos = classification_rule("CURV_COEFF_MOS")
flat_sed_mos = classification_rule("FLAT_SED_MOS")
master_norm_flat_mxu = classification_rule("MASTER_NORM_FLAT_MXU")
disp_coeff_mxu = classification_rule("DISP_COEFF_MXU")
slit_location_mxu = classification_rule("SLIT_LOCATION_MXU")
curv_coeff_mxu = classification_rule("CURV_COEFF_MXU")
flat_sed_mxu = classification_rule("FLAT_SED_MXU")
REDUCED_STD = classification_rule(
    "REDUCED_STD",
    {
        **is_fors,
        kwd.pro_catg: [
            "REDUCED_STD_LSS",
            "REDUCED_STD_LSS_C2",
            "REDUCED_STD_MOS",
            "REDUCED_STD_MOS_C2",
        ],
    },
)
REDUCED_STD_PMOS = classification_rule(
    "REDUCED_STD",
    {**is_fors, kwd.pro_catg: ["REDUCED_STD_PMOS", "REDUCED_STD_PMOS_C2"]},
)

# Spectroscopic static calibrations
std_flux_table_class = classification_rule("STD_FLUX_TABLE")
extinct_table_class = classification_rule("EXTINCT_TABLE")
telluric_contamination_class = classification_rule("TELLURIC_CONTAMINATION")

# Static calibrations for telluric correction
molecules_class = classification_rule(
    "MOLECULES", {**is_fors, kwd.pro_catg: "MOLECULES"}
)
wave_include_class = classification_rule(
    "WAVE_INCLUDE", {**is_fors, kwd.pro_catg: "WAVE_INCLUDE"}
)
wave_exclude_class = classification_rule(
    "WAVE_EXCLUDE", {**is_fors, kwd.pro_catg: "WAVE_EXCLUDE"}
)
pix_exclude_class = classification_rule(
    "PIX_EXCLUDE", {**is_fors, kwd.pro_catg: "PIX_EXCLUDE"}
)
atm_profile_class = classification_rule(
    "ATM_PROFILE_STANDARD", {**is_fors, kwd.pro_catg: "ATM_PROFILE_STANDARD"}
)
kernel_class = classification_rule(
    "KERNEL_LIBRARY", {**is_fors, kwd.pro_catg: "KERNEL_LIBRARY"}
)
gdas_class = classification_rule("GDAS", {**is_fors, kwd.pro_catg: "GDAS"})

# POLARIMETRY CALIBRATIONS (PMOS)
screen_flat_pmos_class = classification_rule(
    "SCREEN_FLAT_PMOS", {**is_pmos_calib, kwd.dpr_type: "FLAT,LAMP"}
)
lamp_pmos_class = classification_rule(
    "LAMP_PMOS", {**is_pmos_calib, kwd.dpr_type: "WAVE,LAMP"}
)
standard_pmos1_class = classification_rule("STANDARD_PMOS", rules.is_std_pmos_chip1)
standard_pmos2_class = classification_rule("STANDARD_PMOS", rules.is_std_pmos_chip2)
science_pmos_class = classification_rule("SCIENCE_PMOS", rules.is_science_pmos)
standard_pmos1_class_wrong_coordinates = classification_rule(
    "STANDARD_PMOS_wrong_coordinates", rules.is_std_pmos_chip1_wrong_coordinates
)
standard_pmos2_class_wrong_coordinates = classification_rule(
    "STANDARD_PMOS_wrong_coordinates", rules.is_std_pmos_chip2_wrong_coordinates
)
science_pmos_class_wrong_coordinates = classification_rule(
    "SCIENCE_PMOS_wrong_coordinates", rules.is_science_pmos_wrong_coordinates
)

STD_PMOS_TABLE_class = classification_rule("STD_PMOS_TABLE")
MASTER_DISTORTION_TABLE_class = classification_rule("MASTER_DISTORTION_TABLE")
RETARDER_WAVEPLATE_class = classification_rule("RETARDER_WAVEPLATE_CHROMATISM")
SLIT_LOCATION_PMOS_class = classification_rule("SLIT_LOCATION_PMOS")
CURV_COEFF_PMOS_class = classification_rule("CURV_COEFF_PMOS")
MASTER_NORM_FLAT_PMOS_class = classification_rule("MASTER_NORM_FLAT_PMOS")
DISP_COEFF_PMOS_class = classification_rule("DISP_COEFF_PMOS")

# IPOL CALIBRATIONS
object_ipol_class = classification_rule("OBJECT_IPOL", rules.is_object_ipol)
object_ipol_class_wrong_coordinates = classification_rule(
    "OBJECT_IPOL_wrong_coordinates", rules.is_object_ipol_wrong_coordinates
)
sky_ipol_class = classification_rule("SKY_IPOL", rules.is_sky_ipol)
sky_ipol_class_wrong_coordinates = classification_rule(
    "SKY_IPOL_wrong_coordinates", rules.is_sky_ipol_wrong_coordinates
)
standard_ipol_class = classification_rule("STANDARD_IPOL", rules.is_standard_ipol)
standard_ipol_class_wrong_coordinates = classification_rule(
    "STANDARD_IPOL_wrong_coordinates", rules.is_standard_ipol_wrong_coordinates
)
flat_ipol_class = classification_rule("FLAT_IPOL", rules.is_flat_ipol)
STANDARD_REDUCED_IPOL = classification_rule(
    "STANDARD_REDUCED_IPOL", {**is_fors, kwd.pro_catg: "STANDARD_REDUCED_IPOL"}
)

# HIT calibrations
flat_hit_class = classification_rule("FLAT_HIT", rules.is_flat_hit)
flat_hit_ms_class = classification_rule("FLAT_HIT_MS", rules.is_flat_hit_ms)
flat_hit_s_class = classification_rule(
    "FLAT_HIT_S",
    {
        **is_mxu_calib,
        kwd.ins_gris1_name: ["XGRIS_600B", "XGRIS_300I"],
        kwd.dpr_type: "FLAT,LAMP",
    },
)
wave_hit_s_class = classification_rule(
    "WAVE_HIT_S",
    {
        **is_mxu_calib,
        kwd.ins_gris1_name: ["XGRIS_600B", "XGRIS_300I"],
        kwd.dpr_type: "WAVE,LAMP",
    },
)
wave_hit_ms_class = classification_rule(
    "WAVE_HIT_MS", {**is_calib, kwd.det_read_clock: "HIT-MS", kwd.dpr_type: "WAVE,LAMP"}
)
std_hit_class = classification_rule("STD_HIT", rules.is_std_hit)
std_hit_s_class = classification_rule("STD_HIT_S", rules.is_std_s_hit)
std_hit_ms_class = classification_rule("STD_HIT_MS", rules.is_std_ms_hit)
sci_hit_class = classification_rule("SCIENCE_HIT", rules.is_sci_hit)
sci_hit_s_class = classification_rule("SCIENCE_HIT_S", rules.is_sci_s_hit)
sci_hit_ms_class = classification_rule("SCIENCE_HIT_MS", rules.is_sci_ms_hit)
std_hit_class_wrong_coordinates = classification_rule(
    "STD_HIT_wrong_coordinates", rules.is_std_hit_wrong_coordinates
)
std_hit_s_class_wrong_coordinates = classification_rule(
    "STD_HIT_S_wrong_coordinates", rules.is_std_s_hit_wrong_coordinates
)
std_hit_ms_class_wrong_coordinates = classification_rule(
    "STD_HIT_MS_wrong_coordinates", rules.is_std_ms_hit_wrong_coordinates
)
sci_hit_class_wrong_coordinates = classification_rule(
    "SCIENCE_HIT_wrong_coordinates", rules.is_sci_hit_wrong_coordinates
)
sci_hit_s_class_wrong_coordinates = classification_rule(
    "SCIENCE_HIT_S_wrong_coordinates", rules.is_sci_s_hit_wrong_coordinates
)
sci_hit_ms_class_wrong_coordinates = classification_rule(
    "SCIENCE_HIT_MS_wrong_coordinates", rules.is_sci_ms_hit_wrong_coordinates
)

MASTER_NORM_FLAT_HIT_S = classification_rule("MASTER_NORM_FLAT_HIT_S")
MASTER_NORM_FLAT_HIT_MS = classification_rule("MASTER_NORM_FLAT_HIT_MS")
MASTER_SCREEN_FLAT_HIT = classification_rule("MASTER_SCREEN_FLAT_HIT")
DISP_COEFF_HIT_S = classification_rule("DISP_COEFF_HIT_S")
DISP_COEFF_HIT_MS = classification_rule("DISP_COEFF_HIT_MS")
STANDARD_REDUCED_HIT_MASSOC = classification_rule("STANDARD_REDUCED_HIT_MASSOC")
STANDARD_REDUCED_HIT_MS_MASSOC = classification_rule("STANDARD_REDUCED_HIT_MS_MASSOC")
MAPPED_ALL_STD_HIT_MS_MASSOC = classification_rule("MAPPED_ALL_STD_HIT_MS_MASSOC")
STANDARD_REDUCED_HIT_S_MASSOC = classification_rule("STANDARD_REDUCED_HIT_S_MASSOC")
MAPPED_ALL_STD_HIT_S_MASSOC = classification_rule("MAPPED_ALL_STD_HIT_S_MASSOC")

# STATIC CALIBRATIONS
grism_table_class = classification_rule("GRISM_TABLE")
master_linecat_class = classification_rule("MASTER_LINECAT")
master_skylinecat_class = classification_rule("MASTER_SKYLINECAT")
eop_parameters_class = classification_rule("EOP_PARAM")
std_flux_catalogue = classification_rule("STD_FLUX_CATALOG")
fit_point_catalog = classification_rule("FIT_POINT_CATALOG")

# ACQUISITION
acquisition_ipol_class = classification_rule(
    "ACQUISITION", {**is_acquisition, kwd.ins_mode: "IPOL"}
)
acquisition_hit_i_class = classification_rule(
    "ACQUISIT_HIT",
    {**is_acquisition_hit, kwd.tpl_id: "FORS2_hiti_acq", kwd.dpr_type: "SKY"},
)
acquisition_hit_ms_slit_class = classification_rule(
    "ACQUISIT_HIT_MS",
    {
        **is_acquisition_hit,
        kwd.tpl_id: "FORS2_hiti_obs_slit_fast",
        kwd.dpr_type: "SLIT",
    },
)
acquisition_hit_ms_sky_class = classification_rule(
    "ACQUISIT_HIT_MS",
    {**is_acquisition_hit, kwd.tpl_id: "FORS2_hitms_acq", kwd.dpr_type: "SKY"},
)
acquisition_hit_ms_fast_class = classification_rule(
    "ACQUISIT_HIT_MS",
    {
        **is_acquisition_hit,
        kwd.tpl_id: "FORS2_hitms_obs_slit_fast",
        kwd.dpr_type: "SLIT",
    },
)
acquisition_hit_s_slit_class = classification_rule(
    "ACQUISIT_HIT_S",
    {
        **is_acquisition_hit,
        kwd.tpl_id: "FORS2_hits_obs_slit_fast",
        kwd.dpr_type: "SLIT",
    },
)
acquisition_hit_s_sky_class = classification_rule(
    "ACQUISIT_HIT_S",
    {**is_acquisition_hit, kwd.tpl_id: "FORS2_hits_acq", kwd.dpr_type: "SKY"},
)
acquisition_lss_sky_class = classification_rule(
    "ACQUISIT_LSS_SKY", {**is_acquisition_lss, kwd.dpr_type: "SKY"}
)
acquisition_mos_sky_class = classification_rule(
    "ACQUISIT_MOS_SKY", {**is_acquisition_mos, kwd.dpr_type: "SKY"}
)
acquisition_mxu_sky_class = classification_rule(
    "ACQUISIT_MXU_SKY", {**is_acquisition_mxu, kwd.dpr_type: "SKY"}
)
acquisition_lss_slit_class = classification_rule(
    "ACQUISIT_LSS_SLIT", {**is_acquisition_lss, kwd.dpr_type: "SLIT"}
)
acquisition_mos_slit_class = classification_rule(
    "ACQUISIT_MOS_SLIT", {**is_acquisition_mos, kwd.dpr_type: "SLIT"}
)
acquisition_mxu_slit_class = classification_rule(
    "ACQUISIT_MXU_SLIT", {**is_acquisition_mxu, kwd.dpr_type: "SLIT"}
)
acquisition_pmos_sky_class = classification_rule(
    "ACQUISIT_PMOS_SKY",
    {**is_acquisition, kwd.tpl_id: "FORS2_pmos_acq_fast", kwd.dpr_type: "SKY"},
)
acquisition_pmos_slit_class = classification_rule(
    "ACQUISIT_PMOS_SLIT",
    {**is_acquisition, kwd.tpl_id: "FORS2_pmos_obs_slit_fast", kwd.dpr_type: "SLIT"},
)
