from edps import QC1_CALIB, ReportInput
from edps import task

from .fors_datasources import *
from .fors_spectra_calibrations import spectra_calibrations

# This meta-target processes all scientific data in all supported modes, but it skips the telluric correction
science_notc = "science_notc"
# --- PROCESSING TASKS COMMON TO SOME INSTRUMENT WORKFLOWS ----------------------------------------
# --- Task for processing bias frames
bias = (task('bias')
        .with_recipe('fors_bias')
        .with_report('fors_rawdisp', ReportInput.RECIPE_INPUTS)
        .with_report("fors_bias", ReportInput.RECIPE_INPUTS_OUTPUTS)
        .with_main_input(raw_bias)
        .with_meta_targets([QC1_CALIB])
        .build())

# This sub-workflow creates the processing tasks for the various instrument
# modes (flat field, and wavelength calibration recipes).
calibration_lss, calibration_mos, calibration_mxu, calibration_std, calibration_pmos, calibration_hc_lss, calibration_hc_std = spectra_calibrations(
    bias)

# --- Task to process sky flats -------------------------------------------------------------------
skyflat_img = (task('sky_flat')
               .with_recipe('fors_img_sky_flat')
               .with_report('fors_rawdisp', ReportInput.RECIPE_INPUTS)
               .with_report('fors_flat_img', ReportInput.RECIPE_INPUTS_OUTPUTS)
               .with_main_input(raw_skyflat_img)
               .with_associated_input(bias, [MASTERBIAS])
               .with_meta_targets([QC1_CALIB])
               .build())

# -- Task for instrument status monitoring
screenflat_img = (task('screen_flat')
                  .with_recipe('fors_img_screen_flat')
                  .with_report('fors_rawdisp', ReportInput.RECIPE_INPUTS)
                  .with_report('fors_flat_img', ReportInput.RECIPE_INPUTS_OUTPUTS)
                  .with_main_input(raw_screenflat_img)
                  .with_associated_input(bias, [MASTERBIAS])
                  .with_meta_targets([QC1_CALIB])
                  .build())
