from edps import data_source, match_rules
from edps.generator.time_range import *

from . import fors_keywords as kwd
from .fors_classification import *

# Convention for Data sources Association rule levels:
# Each data source can have several match function which correspond to different
# quality levels for the selected data. The level is specified as a number that
# follows this convention:
#   level < 0: more restrictive than the calibration plan
#   level = 0 follows the calibration plan
#   level = 1 quality sufficient for QC1 certification
#   level = 2 probably still acceptable quality
#   level = 3 significant risk of bad quality results

# - Common grouping rules
group_detector = [kwd.det_read_clock, kwd.det_chip1_id, kwd.det_binx, kwd.det_biny]
group_img = group_detector + [kwd.ins_filt1_name]
group_flat = group_img + [kwd.ins_gris1_name, kwd.ins_coll_name]
group_grism = [kwd.ins_gris1_id, kwd.det_chip1_x, kwd.det_chip1_y, kwd.ins_coll_name, kwd.instrume]
group_opti = [kwd.ins_opti5_name, kwd.ins_opti6_name, kwd.ins_opti7_name, kwd.ins_opti9_name, kwd.ins_opti10_name]
group_pmos = group_img + [kwd.ins_woll_name, kwd.ins_gris1_name, kwd.ins_opti4_name, kwd.ins_mos_checksum]
group_ipol = group_flat + [kwd.ins_woll_name, kwd.ins_opti4_name]
lamp_setup_keywords = group_flat + [kwd.ins_slit_name, kwd.ins_mos_checksum, kwd.ins_mask_id, kwd.seq_spec_targ]
hit_kwd = group_img + [kwd.ins_coll_name, kwd.ins_mask_name]
lamps = [kwd.ins_lamp1_name, kwd.ins_lamp2_name, kwd.ins_lamp3_name, kwd.ins_lamp4_name, kwd.ins_lamp5_name,
         kwd.ins_lamp6_name]
setup_lamp_check = group_flat + lamps

TEN_DAYS = RelativeTimeRange(-10, 10)

# ----  DATA SOURCES ------------------------------------------------------------------------------

# - COMMON DATASOURCES
# Raw types
raw_bias = (data_source()
            .with_classification_rule(bias_class)
            # .with_min_group_size(20)
            .with_setup_keywords(group_detector)
            .with_grouping_keywords(group_detector + [kwd.tpl_start])
            .with_match_function(rules.is_assoc_bias_calibration_plan, time_range=FIVE_DAYS, level=0)
            .with_match_keywords(rules.match_bias, time_range=FIVE_DAYS, level=0.9)
            .with_match_keywords(rules.match_bias, time_range=TEN_DAYS, level=1)
            .with_match_keywords(rules.match_bias, time_range=UNLIMITED, level=3)
            .build())

raw_dark = (data_source()
            .with_classification_rule(dark_class)
            .with_setup_keywords(group_detector)
            .with_grouping_keywords(group_detector + [kwd.tpl_start])
            .build())

raw_detmon_on = (data_source()
                 .with_classification_rule(detmon_on_class)
                 .with_setup_keywords(group_detector)
                 .with_grouping_keywords(group_detector + [kwd.tpl_start])
                 .build())

raw_detmon_off = (data_source()
                  .with_classification_rule(detmon_off_class)
                  .with_setup_keywords(group_detector)
                  .with_match_keywords(group_detector + [kwd.tpl_start], level=0)
                  .build())

# Static calibrations
master_linecat = (data_source()
                  .with_classification_rule(master_linecat_class)
                  .with_match_keywords([kwd.ins_gris1_id, kwd.ins_gris1_name, kwd.ins_opti7_name, kwd.instrume])
                  .build())

grism_table = (data_source()
               .with_classification_rule(grism_table_class)
               .with_match_keywords([kwd.ins_gris1_id, kwd.ins_gris1_name, kwd.ins_opti7_name, kwd.instrume],
                                    time_range=IN_THE_PAST, level=0)
               .with_match_keywords([kwd.ins_gris1_id, kwd.ins_gris1_name, kwd.ins_opti7_name, kwd.instrume],
                                    time_range=UNLIMITED, level=0)
               .build())

reduced_std = (data_source("REDUCED_STD")
               .with_classification_rule(REDUCED_STD)
               .with_match_keywords(
    group_detector + group_opti + [kwd.ins_mode, kwd.ins_woll_name, kwd.ins_gris1_name, kwd.ins_opti4_name],
    time_range=ONE_WEEK, level=0).build())

reduced_std_pmos = (data_source("REDUCED_STD_PMOS")
                    .with_classification_rule(REDUCED_STD_PMOS)
                    .with_match_keywords(
    group_detector + group_opti + [kwd.ins_mode, kwd.ins_woll_name, kwd.ins_gris1_name, kwd.ins_opti4_name],
    time_range=ONE_MONTH, level=0).build())

# - IMAGING DATASOURCES
# Raw types

raw_skyflat_img = (data_source()
                   .with_classification_rule(cls_skyflat_img)
                   .with_setup_keywords(group_flat)
                   .with_grouping_keywords(group_flat + [kwd.tpl_start])
                   .with_min_group_size(4)
                   .with_match_function(rules.is_assoc_skyflat_calibration_plan, time_range=TWO_WEEKS, level=0.)
                   .with_match_keywords(rules.match_img_flat, time_range=TWO_WEEKS, level=0.9)
                   .with_match_keywords(rules.match_img_flat, time_range=UNLIMITED, level=3)
                   .build())

raw_std_img = (data_source()
               .with_classification_rule(cls_std_img)
               .with_setup_keywords(group_flat)
               .with_grouping_keywords([kwd.arcfile])
               .with_match_keywords([kwd.instrume, kwd.det_chip1_id], time_range=RelativeTimeRange(-0.6, 0.6), level=0)
               .build())

raw_std_img_unsupported_filters = (data_source("STANDARD_IMG_not_supported")
                                   .with_classification_rule(cls_std_img_unsupported)
                                   .with_setup_keywords(group_flat)
                                   .with_grouping_keywords([kwd.arcfile])
                                   .build())

raw_screenflat_img = (data_source()
                      .with_classification_rule(cls_screenflat_img)
                      .with_setup_keywords(group_flat)
                      .with_grouping_keywords(group_flat + [kwd.tpl_start])
                      .with_match_keywords([])
                      .build())

raw_science_img = (data_source()
                   .with_classification_rule(cls_science_img)
                   .with_setup_keywords(group_flat)
                   .with_grouping_keywords([kwd.arcfile])
                   .build())

# static calibrations
raw_photTable = (data_source()
                 .with_classification_rule(cls_photTable)
                 .with_match_keywords([kwd.instrume, kwd.det_chip1_id], time_range=IN_THE_PAST, level=0)
                 .with_match_keywords([kwd.instrume, kwd.det_chip1_id], time_range=UNLIMITED, level=1)
                 .build())

raw_PhotCoeffTable = (data_source()
                      .with_classification_rule(cls_Phot_Coeff_Table)
                      .with_match_keywords([kwd.instrume, kwd.det_chip1_id, kwd.night, kwd.ins_filt1_name],
                                           time_range=ONE_DAY, level=0)
                      .build())

raw_staticPhotTable = (data_source()
                       .with_classification_rule(cls_staticPhotTable)
                       .with_match_function(rules.match_static_phot_table, time_range=IN_THE_PAST)
                       .build())

raw_flxStdImg = (data_source()
                 .with_classification_rule(cls_flxStdImg)
                 .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                 .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=3)
                 .build())

raw_detIllumRegion = (data_source()
                      .with_classification_rule(cls_detIllumReg)
                      .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                      .build())

# - SPECTROSCOPIC DATASOURCES
# Raw types
raw_screen_flat_lss = (data_source()
                       .with_classification_rule(screen_flat_lss_class)
                       .with_grouping_keywords([kwd.tpl_start, kwd.det_chip1_id])
                       .with_setup_keywords(group_flat + [kwd.ins_slit_name])
                       .with_match_function(rules.is_assoc_screen_flat_lss, time_range=THREE_DAYS, level=0)
                       .with_match_function(rules.is_assoc_screen_flat_lss, time_range=TWO_WEEKS, level=2)
                       .with_match_function(rules.is_assoc_screen_flat_lss, time_range=UNLIMITED, level=3)
                       .build())

raw_screen_flat_mos = (data_source()
                       .with_classification_rule(screen_flat_mos_class)
                       .with_grouping_keywords([kwd.tpl_start, kwd.det_chip1_id])
                       .with_setup_keywords(group_flat + [kwd.ins_mos_checksum])
                       .with_match_function(rules.is_assoc_screen_flat_mos, time_range=THREE_DAYS, level=0)
                       .with_match_function(rules.is_assoc_screen_flat_mos, time_range=TWO_WEEKS, level=2)
                       .with_match_function(rules.is_assoc_screen_flat_mos, time_range=UNLIMITED, level=3)
                       .build())

raw_screen_flat_mxu = (data_source()
                       .with_classification_rule(screen_flat_mxu_class)
                       .with_grouping_keywords([kwd.tpl_start, kwd.det_chip1_id])
                       .with_setup_keywords(group_flat + [kwd.ins_mask_id])
                       .with_match_function(rules.is_assoc_screen_flat_mxu, time_range=THREE_DAYS, level=0)
                       .with_match_function(rules.is_assoc_screen_flat_mxu, time_range=TWO_WEEKS, level=2)
                       .with_match_function(rules.is_assoc_screen_flat_mxu, time_range=UNLIMITED, level=3)
                       .with_match_function(rules.is_assoc_screen_flat_mxu, time_range=UNLIMITED, level=3)
                       .build())

raw_screen_flat_std = (data_source()
                       .with_classification_rule(screen_flat_std_class)
                       .with_grouping_keywords([kwd.tpl_start, kwd.det_chip1_id])
                       .with_setup_keywords(group_flat + [kwd.seq_spec_targ])
                       .with_match_function(rules.is_assoc_screen_flat_std, time_range=THREE_DAYS, level=0)
                       .with_match_function(rules.is_assoc_screen_flat_std, time_range=UNLIMITED, level=3)
                       .build())

raw_wave = (data_source("WAVE_LAMP")
            .with_classification_rule(lamp_lss_class)
            .with_classification_rule(lamp_mos_class)
            .with_classification_rule(lamp_mxu_class)
            .with_classification_rule(lamp_std_class)
            .with_setup_keywords(lamp_setup_keywords)
            .with_grouping_keywords([kwd.arcfile])
            .with_match_function(rules.is_assoc_lamp, time_range=THREE_DAYS, level=0)
            .with_match_function(rules.is_assoc_lamp, time_range=ONE_WEEK, level=1)
            .with_match_function(rules.is_assoc_lamp, time_range=UNLIMITED, level=3)
            .build())

raw_flat_hc_lss = (data_source("FLAT_HC_LSS")
                   .with_classification_rule(flat_hc_lss_class)
                   .with_setup_keywords(group_flat + [kwd.ins_slit_name])
                   .with_grouping_keywords(group_flat + [kwd.tpl_start])
                   .build())

raw_wave_hc_lss = (data_source("WAVE_HC_LSS")
                   .with_classification_rule(wave_hc_lss_class)
                   .with_setup_keywords(group_flat)
                   .with_grouping_keywords(group_flat + [kwd.tpl_start])
                   .with_match_keywords([kwd.det_chip1_id, kwd.tpl_start], time_range=ONE_DAY, level=0)
                   .build())

raw_flat_hc_std = (data_source("FLAT_HC_STD")
                   .with_classification_rule(flat_hc_std_class)
                   .with_setup_keywords(group_flat + [kwd.seq_spec_targ])
                   .with_grouping_keywords(group_flat + [kwd.seq_spec_targ, kwd.tpl_start])
                   .build())

raw_wave_hc_std = (data_source("WAVE_HC_STD")
                   .with_classification_rule(wave_hc_std_class)
                   .with_setup_keywords(group_flat + [kwd.seq_spec_targ])
                   .with_grouping_keywords(group_flat + [kwd.seq_spec_targ, kwd.tpl_start])
                   .with_match_keywords([kwd.det_chip1_id, kwd.tpl_start], time_range=ONE_DAY, level=0)
                   .build())

raw_lamp_check = (data_source("ARC_CHECK")
                  .with_classification_rule(wave_lss_check_class)
                  .with_classification_rule(flat_lss_check_class)
                  .with_setup_keywords(setup_lamp_check)
                  .with_grouping_keywords([kwd.arcfile])
                  .build())

raw_lamp_check_few = (data_source()
                      .with_classification_rule(screen_flux_check_class2)
                      .with_setup_keywords(setup_lamp_check)
                      .with_grouping_keywords([kwd.arcfile])
                      .build())

raw_std_mos = (data_source()
               .with_classification_rule(std_mos1_class)
               .with_grouping_keywords([kwd.arcfile])
               .with_setup_keywords(group_flat + [kwd.seq_spec_targ])
               .build())
# Standard mos are associated with different rules to LSS and MOS/MXU data
match_std_mos_to_lss = (match_rules()
                        .with_match_function(rules.is_assoc_std_mos_to_lss, time_range=ONE_WEEK, level=0)
                        .with_match_function(rules.is_assoc_std_mos_to_lss, time_range=UNLIMITED, level=3))

match_std_mos_to_mosmxu = (match_rules()
                           .with_match_function(rules.is_assoc_std_mos_to_mosmxu, time_range=ONE_WEEK, level=0)
                           .with_match_function(rules.is_assoc_std_mos_to_mosmxu, time_range=UNLIMITED, level=3))

raw_std_lss = (data_source()
               .with_classification_rule(std_lss_class)
               .with_setup_keywords(group_flat + [kwd.ins_slit_name])
               .with_grouping_keywords([kwd.arcfile])
               .build())

raw_sci = (data_source("SCIENCE")
           .with_classification_rule(sci_lss_class)
           .with_classification_rule(sci_mos_class)
           .with_classification_rule(sci_mxu_class)
           .with_setup_keywords(
    group_flat + [kwd.ins_slit_name, kwd.ins_mos_checksum, kwd.seq_spec_targ, kwd.ins_mask_id])
           .with_grouping_keywords([kwd.arcfile])
           .build())

acquisition_sky_spec = (data_source("ACQUISITION_SKY")
                        .with_classification_rule(acquisition_lss_sky_class)
                        .with_classification_rule(acquisition_mos_sky_class)
                        .with_classification_rule(acquisition_mxu_sky_class)
                        .with_setup_keywords(
    group_flat + [kwd.ins_slit_name, kwd.ins_mos_checksum, kwd.seq_spec_targ, kwd.ins_mask_id])
                        .with_grouping_keywords([kwd.ins_mode, kwd.obs_id])
                        .with_match_keywords([kwd.instrume, kwd.ins_mode, kwd.obs_id, kwd.det_chip1_id])
                        .build())

acquisition_slit_spec = (data_source("ACQUISITION_SLIT")
                         .with_classification_rule(acquisition_lss_slit_class)
                         .with_classification_rule(acquisition_mos_slit_class)
                         .with_classification_rule(acquisition_mxu_slit_class)
                         .with_setup_keywords(
    group_flat + [kwd.ins_slit_name, kwd.ins_mos_checksum, kwd.seq_spec_targ, kwd.ins_mask_id])
                         .with_grouping_keywords([kwd.ins_mode, kwd.obs_id])
                         .with_match_keywords([kwd.instrume, kwd.ins_mode, kwd.obs_id, kwd.det_chip1_id])
                         .build())

# Static calibrations
std_flux_table = (data_source()
                  .with_classification_rule(std_flux_table_class)
                  .with_grouping_keywords([kwd.arcfile])
                  .with_match_keywords([kwd.obs_targ_name, kwd.instrume], time_range=UNLIMITED, level=0)
                  .build())

extinct_table = (data_source()
                 .with_classification_rule(extinct_table_class)
                 .with_grouping_keywords([kwd.arcfile])
                 .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                 .build())

telluric_contamination = (data_source()
                          .with_classification_rule(telluric_contamination_class)
                          .with_grouping_keywords([kwd.arcfile])
                          .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                          .build())

master_specphot_table = (data_source()
                         .with_classification_rule(master_specphot_table_class)
                         .with_grouping_keywords([kwd.arcfile])
                         .with_match_keywords(rules.match_phot_table, time_range=IN_THE_PAST, level=0)
                         .build())

global_distortion_table = (data_source()
                           .with_classification_rule(global_distortion_table_class)
                           .with_match_keywords(group_grism + [kwd.det_binx, kwd.det_biny], time_range=IN_THE_PAST,
                                                level=0)
                           .build())

master_skylinecat = (data_source()
                     .with_classification_rule(master_skylinecat_class)
                     .with_match_keywords([kwd.ins_gris1_id, kwd.ins_coll_name, kwd.instrume], time_range=IN_THE_PAST,
                                          level=0)
                     .build())

eop_parameters = (data_source()
                  .with_classification_rule(eop_parameters_class)
                  .with_match_keywords([kwd.instrume])
                  .build())

# Static calibrations for telluric correction
molecules = (data_source()
             .with_classification_rule(molecules_class)
             .with_match_function(rules.is_assoc).build())

atm_profile_standard = (data_source()
                        .with_classification_rule(atm_profile_class)
                        .with_match_function(rules.is_assoc).build())

wave_include = (data_source()
                .with_classification_rule(wave_include_class)
                .with_match_function(rules.is_assoc).build())

wave_exclude = (data_source()
                .with_classification_rule(wave_exclude_class)
                .with_match_function(rules.is_assoc).build())

pix_exclude = (data_source()
               .with_classification_rule(pix_exclude_class)
               .with_match_function(rules.is_assoc).build())

kernel_library = (data_source()
                  .with_classification_rule(kernel_class)
                  .with_match_function(rules.is_assoc).build())

gdas = (data_source()
        .with_classification_rule(gdas_class)
        .with_match_function(rules.is_assoc).build())

# - POLARIMETRY DATASOURCES
# - PMOS
# Raw types
raw_screen_flat_pmos = (data_source()
                        .with_classification_rule(screen_flat_pmos_class)
                        .with_grouping_keywords(group_pmos + [kwd.tpl_start])
                        .with_setup_keywords(group_pmos)
                        .with_match_function(rules.is_assoc_screen_flat_pmos, time_range=THREE_DAYS, level=0)
                        .with_match_function(rules.is_assoc_screen_flat_pmos, time_range=UNLIMITED, level=3)
                        .build())

raw_wave_pmos = (data_source()
                 .with_classification_rule(lamp_pmos_class)
                 .with_setup_keywords(group_pmos)
                 .with_grouping_keywords(group_pmos + [kwd.tpl_start])
                 .with_match_function(rules.is_assoc_lamp_pmos, time_range=THREE_DAYS, level=0)
                 .with_match_function(rules.is_assoc_lamp_pmos, time_range=UNLIMITED, level=3)
                 .build())

match_keywords = group_detector + group_opti + [kwd.ins_mode, kwd.ins_woll_name, kwd.ins_gris1_name, kwd.ins_opti4_name]
raw_standard_pmos = (data_source()
                     .with_classification_rule(standard_pmos1_class)
                     .with_setup_keywords(group_pmos)
                     .with_grouping_keywords(group_pmos + [kwd.tpl_start])
                     .with_match_keywords(match_keywords, time_range=ONE_MONTH, level=0)
                     .build())

raw_science_pmos = (data_source()
                    .with_classification_rule(science_pmos_class)
                    .with_setup_keywords(group_pmos)
                    .with_grouping_keywords(group_pmos + [kwd.tpl_start])
                    .build())

# - IPOL
raw_flat_ipol = (data_source()
                 .with_classification_rule(flat_ipol_class)
                 .with_setup_keywords(group_ipol)
                 .with_grouping_keywords(group_ipol + [kwd.tpl_start])
                 .with_match_keywords(group_ipol, time_range=TWO_WEEKS)
                 .build())

raw_science_ipol = (data_source()
                    .with_classification_rule(object_ipol_class)
                    .with_setup_keywords(group_ipol)
                    .with_grouping_keywords(group_ipol + [kwd.tpl_start])
                    .build())

raw_standard_ipol = (data_source()
                     .with_classification_rule(standard_ipol_class)
                     .with_setup_keywords(group_ipol)
                     .with_grouping_keywords(group_ipol + [kwd.tpl_start])
                     .with_match_keywords(group_ipol, time_range=ONE_DAY, level=-1)
                     .with_match_keywords(group_ipol, time_range=ONE_MONTH, level=0)
                     .build())

raw_acquisition_ipol = (data_source()
                        .with_classification_rule(acquisition_ipol_class)
                        .with_setup_keywords(group_ipol)
                        .with_grouping_keywords(group_ipol + [kwd.tpl_start])
                        .with_match_keywords([kwd.obs_id, kwd.det_chip1_id])
                        .build())

# - HIT mode

raw_flat_hit = (data_source()
                .with_classification_rule(flat_hit_class)
                .with_setup_keywords(hit_kwd)
                .with_grouping_keywords(hit_kwd + [kwd.tpl_start])
                .with_match_keywords(group_opti + hit_kwd, time_range=ONE_DAY, level=0)
                .with_match_keywords(group_opti + hit_kwd, time_range=UNLIMITED, level=3)
                .build())

raw_flat_hit_ms = (data_source()
                   .with_classification_rule(flat_hit_ms_class)
                   .with_setup_keywords(hit_kwd)
                   .with_grouping_keywords(hit_kwd + [kwd.tpl_start])
                   .with_match_keywords(group_opti + hit_kwd, time_range=ONE_DAY, level=0)
                   .with_match_keywords(group_opti + hit_kwd, time_range=UNLIMITED, level=3)
                   .build())

raw_flat_hit_s = (data_source()
                  .with_classification_rule(flat_hit_s_class)
                  .with_setup_keywords(hit_kwd)
                  .with_grouping_keywords(hit_kwd + [kwd.tpl_start])
                  .with_match_keywords(group_opti + hit_kwd, time_range=ONE_DAY, level=0)
                  .with_match_keywords(group_opti + hit_kwd, time_range=UNLIMITED, level=3)
                  .build())

raw_wave_hit_ms = (data_source()
                   .with_classification_rule(wave_hit_ms_class)
                   .with_setup_keywords(hit_kwd)
                   .with_grouping_keywords([kwd.arcfile])
                   .with_match_keywords(group_opti + hit_kwd, time_range=ONE_DAY, level=0)
                   .with_match_keywords(group_opti + hit_kwd, time_range=UNLIMITED, level=3)
                   .build())

raw_wave_hit_s = (data_source()
                  .with_classification_rule(wave_hit_s_class)
                  .with_setup_keywords(hit_kwd)
                  .with_grouping_keywords([kwd.arcfile])
                  .with_match_keywords(group_opti + hit_kwd, time_range=ONE_DAY, level=0)
                  .with_match_keywords(group_opti + hit_kwd, time_range=UNLIMITED, level=3)
                  .build())

raw_std_hit = (data_source()
               .with_classification_rule(std_hit_class)
               .with_setup_keywords(hit_kwd)
               .with_grouping_keywords([kwd.arcfile])
               .with_match_keywords(group_opti + hit_kwd, time_range=ONE_DAY, level=0)
               .with_match_keywords(group_opti + hit_kwd, time_range=UNLIMITED, level=3)
               .build())

raw_std_hit_s = (data_source()
                 .with_classification_rule(std_hit_s_class)
                 .with_setup_keywords(hit_kwd)
                 .with_grouping_keywords([kwd.arcfile])
                 .with_match_keywords(group_opti + hit_kwd, time_range=ONE_DAY, level=0)
                 .with_match_keywords(group_opti + hit_kwd, time_range=UNLIMITED, level=3)
                 .build())

raw_std_hit_ms = (data_source()
                  .with_classification_rule(std_hit_ms_class)
                  .with_setup_keywords(hit_kwd)
                  .with_grouping_keywords([kwd.arcfile])
                  .with_match_keywords(group_opti + hit_kwd, time_range=ONE_DAY, level=0)
                  .with_match_keywords(group_opti + hit_kwd, time_range=UNLIMITED, level=3)
                  .build())

raw_sci_hit = (data_source()
               .with_classification_rule(sci_hit_class)
               .with_setup_keywords(hit_kwd)
               .with_grouping_keywords([kwd.arcfile])
               .build())

raw_sci_hit_s = (data_source()
                 .with_classification_rule(sci_hit_s_class)
                 .with_setup_keywords(hit_kwd)
                 .with_grouping_keywords([kwd.arcfile])
                 .build())

raw_sci_hit_ms = (data_source()
                  .with_classification_rule(sci_hit_ms_class)
                  .with_setup_keywords(hit_kwd)
                  .with_grouping_keywords([kwd.arcfile])
                  .build())

raw_acquisition_hit = (data_source("ACQUISITION_HIT")
                       .with_classification_rule(acquisition_hit_i_class)
                       .with_classification_rule(acquisition_hit_s_sky_class)
                       .with_classification_rule(acquisition_hit_ms_sky_class)
                       .with_classification_rule(acquisition_hit_s_slit_class)
                       .with_classification_rule(acquisition_hit_ms_fast_class)
                       .with_classification_rule(acquisition_hit_ms_slit_class)
                       .with_setup_keywords(hit_kwd)
                       .with_grouping_keywords([kwd.arcfile])
                       .with_match_keywords([kwd.obs_id])
                       .build())

# - Static calibrations
distortion_table = (data_source()
                    .with_classification_rule(MASTER_DISTORTION_TABLE_class)
                    .with_match_keywords([kwd.ins_gris1_id, kwd.det_chip1_id, kwd.instrume], time_range=UNLIMITED,
                                         level=0)
                    .build())

retarder_waveplate = (data_source()
                      .with_classification_rule(RETARDER_WAVEPLATE_class)
                      .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                      .build())

std_pmos_table = (data_source()
                  .with_classification_rule(STD_PMOS_TABLE_class)
                  .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                  .build())

master_skylinecat_pmos = (data_source()
                          .with_classification_rule(master_skylinecat_class)
                          .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                          .build())
