from edps import subworkflow, task

from .fors_datasources import *


@subworkflow("flat_hit", "")
def fors_flat_hit(bias, bias_for_hit):
    flat_hit = (task('flat_hit')
                .with_main_input(raw_flat_hit)
                .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
                .build())

    flat_hit_ms = (task('flat_hit_ms')
                   .with_main_input(raw_flat_hit_ms)
                   .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
                   .build())

    flat_hit_s = (task('flat_hit_s')
                  .with_main_input(raw_flat_hit_s)
                  .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
                  .build())

    return flat_hit, flat_hit_ms, flat_hit_s


@subworkflow("wave_hit", "")
def fors_wave_hit(bias, bias_for_hit):
    wave_hit_ms = (task('wave_hit_ms')
                   .with_main_input(raw_wave_hit_ms)
                   .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
                   .build())

    wave_hit_s = (task('wave_hit_s')
                  .with_main_input(raw_wave_hit_s)
                  .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
                  .build())

    return wave_hit_ms, wave_hit_s
