from edps import task

from .fors_common import bias
from .fors_common import screenflat_img
from .fors_datasources import *
from .fors_hit import fors_flat_hit, fors_wave_hit

__title__ = "FORS HIght Time (HIT) resolution workflow"

# --- Note: Reduction of HIT mode data is not supported by the FORS2 pipeline.
match_bias_hit = [kwd.det_binx, kwd.det_biny, kwd.det_read_speed, kwd.det_out1_gain, kwd.det_chip1_id]
bias_for_hit = (match_rules()
                .with_match_keywords(match_bias_hit, time_range=FIVE_DAYS, level=0)
                .with_match_keywords(match_bias_hit, time_range=RelativeTimeRange(-10, 10), level=1)
                .with_match_keywords(match_bias_hit, time_range=UNLIMITED, level=3))

flat_hit, flat_hit_ms, flat_hit_s = fors_flat_hit(bias, bias_for_hit)
wave_hit_ms, wave_hit_s = fors_wave_hit(bias, bias_for_hit)

std_hit = (task("standard_hit")
           .with_main_input(raw_std_hit)
           .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
           .with_associated_input(screenflat_img, [pcls_masterScreenFlat_img])
           .build())

std_hit_s = (task("standard_hit_s")
             .with_main_input(raw_std_hit_s)
             .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
             .with_associated_input(flat_hit_s, [MASTER_NORM_FLAT_HIT_S])
             .with_associated_input(wave_hit_s, [DISP_COEFF_HIT_S])
             .with_associated_input(grism_table)
             .build())

std_hit_ms = (task("standard_hit_ms")
              .with_main_input(raw_std_hit_ms)
              .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
              .with_associated_input(flat_hit_ms, [MASTER_NORM_FLAT_HIT_MS])
              .with_associated_input(wave_hit_ms, [DISP_COEFF_HIT_MS])
              .with_associated_input(grism_table)
              .build())

sci_hit = (task("science_hit")
           .with_main_input(raw_std_hit)
           .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
           .with_associated_input(screenflat_img, [pcls_masterScreenFlat_img])
           .with_associated_input(flat_hit, [MASTER_SCREEN_FLAT_HIT])
           .with_associated_input(std_hit, [STANDARD_REDUCED_HIT_MASSOC])
           .with_associated_input(raw_acquisition_hit, min_ret=0)
           .build())

sci_hit_ms = (task("science_hit_ms")
              .with_main_input(raw_std_hit_ms)
              .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
              .with_associated_input(flat_hit_ms, [MASTER_NORM_FLAT_HIT_MS])
              .with_associated_input(std_hit_ms, [STANDARD_REDUCED_HIT_MS_MASSOC, MAPPED_ALL_STD_HIT_MS_MASSOC])
              .with_associated_input(wave_hit_ms, [DISP_COEFF_HIT_MS])
              .with_associated_input(raw_acquisition_hit, min_ret=0)
              .build())

sci_hit_s = (task("science_hit_s")
             .with_main_input(raw_std_hit_s)
             .with_associated_input(bias, [MASTERBIAS], match_rules=bias_for_hit)
             .with_associated_input(flat_hit_s, [MASTER_NORM_FLAT_HIT_MS])
             .with_associated_input(std_hit_s, [STANDARD_REDUCED_HIT_S_MASSOC, MAPPED_ALL_STD_HIT_S_MASSOC])
             .with_associated_input(wave_hit_s, [DISP_COEFF_HIT_S])
             .with_associated_input(raw_acquisition_hit, min_ret=0)
             .build())
