from edps import FilterMode, task
from edps import QC1_CALIB, SCIENCE, CALCHECKER, QC0, ReportInput, IDP

# Tasks that are common to all instrument modes are imported from fors_common
from .fors_common import bias, skyflat_img, science_notc
from .fors_datasources import *
from .fors_task_functions import *

__title__ = "FORS imaging workflow"

# --- PROCESSING TASKS ----------------------------------------------------------------------------

# --- Task for detector monitoring ----------------------------------------------------------------
detector_monitor = (task("detector_monitor")
                    .with_recipe("detmon_opt_lg")
                    .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
                    .with_report("fors_detmon", ReportInput.RECIPE_INPUTS_OUTPUTS)
                    .with_main_input(raw_detmon_on)
                    .with_associated_input(raw_detmon_off, max_ret=1000)
                    .with_job_processing(detmon_setting)
                    .with_meta_targets([QC1_CALIB, CALCHECKER])
                    .build())

# --- Task for processing dark frames --------------------------------------------------------------
dark = (task("dark")
        .with_recipe("fors_dark")
        .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
        .with_report("fors_dark", ReportInput.RECIPE_INPUTS_OUTPUTS)
        .with_main_input(raw_dark)
        .with_associated_input(bias, [MASTERBIAS])
        .with_meta_targets([QC1_CALIB])
        .build())

# --- Task to process standard stars  -------------------------------------------------------------
std_img = (task("photometric_standard")
           .with_recipe("fors_zeropoint")
           .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
           .with_report("fors_img_std_star", ReportInput.RECIPE_INPUTS_OUTPUTS)
           .with_main_input(raw_std_img)
           .with_associated_input(bias, [MASTERBIAS])
           .with_associated_input(skyflat_img, [pcls_masterSkyFlat_img])
           .with_associated_input(raw_photTable)
           .with_associated_input(raw_flxStdImg)
           .with_meta_targets([QC0, QC1_CALIB, CALCHECKER])
           .build())

# Task for standard stars taken with filters not supported by the static calibrations.
# Only quality control plot of raw data is produced.
std_img_noc = (task("no_supported_photometric_standard")
               .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
               .with_main_input(raw_std_img_unsupported_filters)
               .with_associated_input(bias, [MASTERBIAS])
               .with_associated_input(skyflat_img, [pcls_masterSkyFlat_img])
               .with_meta_targets([QC0, QC1_CALIB, CALCHECKER])
               .build())

# --- Task to process science exposures
science_basic = (task("basic_image_processing")
                 .with_recipe("fors_img_basic_science")
                 .with_main_input(raw_science_img)
                 .with_associated_input(bias, [MASTERBIAS])
                 .with_associated_input(skyflat_img, [pcls_masterSkyFlat_img])
                 .with_associated_input(raw_detIllumRegion)
                 # for calselector only
                 .with_associated_input(std_img, min_ret=0)
                 .with_input_filter(SOURCES_STD_IMG, cls_aligned_phot, STANDARD_REDUCED_IMG, PHOT_BACKGROUND_STD_IMG,
                                    mode=FilterMode.REJECT)
                 .with_meta_targets([QC0, CALCHECKER])
                 .build())

science_wcs = (task("astrometry_correction")
               .with_recipe("fors_img_wcs")
               .with_main_input(science_basic)
               .build())

science = (task("science_image")
           .with_recipe("fors_img_photom_science")
           .with_main_input(science_wcs)
           .with_associated_input(raw_detIllumRegion)
           .with_associated_input(raw_staticPhotTable)
           .with_associated_input(raw_photTable)
           .with_associated_input(raw_PhotCoeffTable, min_ret=0)
           .with_grouping_keywords(["$combine_science", kwd.ins_filt1_name])
           .with_min_group_size(2)
           .with_meta_targets([SCIENCE, science_notc, IDP])
           .build())

combine_science = (task("combine_images")
                   .with_recipe("fors_img_stack")
                   .with_main_input(science)
                   .with_associated_input(raw_staticPhotTable)
                   .with_associated_input(raw_photTable)
                   .with_meta_targets([SCIENCE, science_notc, IDP])
                   .build())
