from edps import task, CALCHECKER, ReportInput, QC1_CALIB

from .fors_common import bias
from .fors_datasources import *
from .fors_imaging_wkf import skyflat_img

__title__ = "FORS imaging polarimetric workflow"

# -- Note: Reduction of Image Polarimetry data is not supported by the FORS pipeline

flat_ipol = (task("flat_ipol")
             .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
             .with_main_input(raw_flat_ipol)
             .with_associated_input(bias, [MASTERBIAS])
             .build())

skyflat_for_ipol = (match_rules()
                    .with_match_keywords(group_flat + [kwd.ins_opti8_name, kwd.ins_opti9_name, kwd.ins_opti10_name],
                                         time_range=TWO_WEEKS, level=0)
                    .with_match_keywords(group_flat + [kwd.ins_opti8_name, kwd.ins_opti9_name, kwd.ins_opti10_name],
                                         time_range=UNLIMITED, level=3))

standard_ipol = (task("standard_ipol")
                 .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
                 .with_main_input(raw_standard_ipol)
                 .with_associated_input(bias, [MASTERBIAS])
                 .with_associated_input(skyflat_img, [pcls_masterSkyFlat_img], match_rules=skyflat_for_ipol)
                 .with_associated_input(raw_acquisition_ipol, min_ret=0, max_ret=10)
                 .with_meta_targets([QC1_CALIB])
                 .build())

science_ipol = (task("science_image_polarimetry")
                .with_main_input(raw_science_ipol)
                .with_associated_input(bias, [MASTERBIAS])
                .with_associated_input(skyflat_img, [pcls_masterSkyFlat_img], match_rules=skyflat_for_ipol)
                .with_associated_input(raw_acquisition_ipol, min_ret=0, max_ret=10)
                .with_associated_input(standard_ipol, [STANDARD_REDUCED_IPOL], min_ret=0, max_ret=10)
                .with_meta_targets([CALCHECKER])
                .build())
