# --- PROCESSING TASK ------------------------------------------------------------------------------
# Tasks that are common to all instrument modes are imported from fors_common
from edps import FilterMode, CALCHECKER, SCIENCE, QC1_CALIB, task, QC0, ReportInput

from .fors_common import bias, calibration_pmos, science_notc
from .fors_datasources import *

__title__ = "FORS spectro polarimetric workflow"

# --- Task to process standard star observations
standard_pmos = (task('standard_pmos')
                 .with_recipe('fors_pmos_science')
                 .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
                 .with_report("fors_spec_std_star", ReportInput.RECIPE_INPUTS_OUTPUTS)
                 .with_main_input(raw_standard_pmos)
                 .with_associated_input(bias, [MASTERBIAS])
                 .with_associated_input(calibration_pmos,
                                        [SLIT_LOCATION_PMOS_class, CURV_COEFF_PMOS_class, MASTER_NORM_FLAT_PMOS_class,
                                         DISP_COEFF_PMOS_class])
                 .with_associated_input(grism_table)
                 .with_associated_input(retarder_waveplate)
                 .with_associated_input(std_pmos_table)
                 .with_associated_input(distortion_table)
                 .with_associated_input(master_skylinecat_pmos, min_ret=0)
                 .with_meta_targets([QC1_CALIB, SCIENCE, CALCHECKER, science_notc])
                 .build())

# --- Task to process standard science
science = (task('science_spectro_polarimetry')
           .with_recipe('fors_pmos_science')
           .with_main_input(raw_science_pmos)
           .with_associated_input(bias, [MASTERBIAS])
           .with_associated_input(calibration_pmos,
                                  [SLIT_LOCATION_PMOS_class, CURV_COEFF_PMOS_class, MASTER_NORM_FLAT_PMOS_class,
                                   DISP_COEFF_PMOS_class])
           .with_associated_input(grism_table, min_ret=0)
           .with_associated_input(retarder_waveplate, min_ret=0)
           .with_associated_input(master_skylinecat_pmos, min_ret=0)
           .with_associated_input(std_pmos_table, min_ret=0)
           # for calselector only
           .with_associated_input(acquisition_sky_spec, min_ret=0, max_ret=3)
           .with_associated_input(acquisition_slit_spec, min_ret=0, max_ret=3)
           .with_associated_input(standard_pmos, [REDUCED_STD_PMOS], min_ret=0)
           .with_input_filter(REDUCED_STD_PMOS, acquisition_pmos_sky_class, acquisition_pmos_slit_class,
                              mode=FilterMode.REJECT)
           .with_meta_targets([QC0, SCIENCE, CALCHECKER, science_notc])
           .build())
