from edps import match, like

from . import fors_keywords as kwd

# List of matching keywords
match_detector = [kwd.det_binx, kwd.det_biny, kwd.det_read_clock, kwd.det_chip1_id]
match_img = [kwd.ins_coll_name, kwd.ins_opti5_name, kwd.ins_opti6_name, kwd.ins_opti7_name, kwd.ins_opti9_name,
             kwd.ins_opti10_name]
match_grism = [kwd.ins_gris1_id, kwd.ins_gris1_name]
xy107108pos = [kwd.ins_mos107_x, kwd.ins_mos108_x, kwd.ins_mos107_y, kwd.ins_mos108_y]
#
match_bias = match_detector
match_img_flat = match_detector + match_img
match_screen_flat = match_detector + match_img + match_grism
match_wavelength = match_detector + match_img + match_grism
match_phot_table = match_grism + [kwd.instrume, kwd.det_binx, kwd.det_biny, kwd.ins_coll_name, kwd.ins_opti7_name]
match_lamp_pmos = match_detector + match_img + match_grism + [kwd.ins_opti8_name, kwd.instrume]


# --- CLASSIFICATION RULES ------------------------------------------------------------------------

# Common classification rules
def is_fors(f):
    return f[kwd.instrume] in ("FORS1", "FORS2")


def is_calib(f):
    return f[kwd.dpr_catg] == "CALIB" and is_fors(f)


def is_calib_lss(f):
    return is_calib(f) and is_lss(f)


def is_calib_mos(f):
    return is_calib(f) and is_mos(f)


def is_calib_pmos(f):
    return is_calib(f) and is_pmos(f)


def is_calib_mxu(f):
    return is_calib(f) and is_mxu(f)


def is_science(f):
    return f[kwd.dpr_catg] == "SCIENCE" and is_fors(f)


def is_dark(f):
    return is_calib(f) and f[kwd.dpr_type] == "DARK" and f[kwd.tpl_nexp] > 1


def is_bias(f):
    return is_calib(f) and f[kwd.dpr_type] == "BIAS" and f[kwd.tpl_nexp] > 3


# classification rules for IMAGING

def is_img_calib(f):
    return f[kwd.ins_mode] == "IMG" and is_calib(f)


def has_correct_coordinates(f):
    return not has_wrong_coordinates(f)


def has_wrong_coordinates(f):
    return f[kwd.ctype1] == "PIXEL" and f[kwd.ctype2] == "PIXEL" and f[kwd.instrume] == "FORS1" and f[
        kwd.cdelt1] >= 1 and f[kwd.cdelt2] >= 1


def _is_standard_img(f):
    return is_img_calib(f) and f[kwd.dpr_type] == "STD"


def is_standard_img(f):
    return _is_standard_img(f) and f[kwd.ins_filt1_name] in (
        "R_SPECIAL", "v_HIGH", "b_HIGH", "I_BESS") and has_correct_coordinates(f)


def is_standard_img_wrong_coordinates(f):
    return _is_standard_img(f) and has_wrong_coordinates(f)


def is_standard_img_unsupported_filters(f):
    return _is_standard_img(f) and f[kwd.ins_filt1_name] not in (
        "R_SPECIAL", "v_HIGH", "b_HIGH", "I_BESS") and has_correct_coordinates(f)


def _is_science_img(f):
    return is_science(f) and "IMAGE" in f[kwd.dpr_tech]


def is_science_img(f):
    return _is_science_img(f) and has_correct_coordinates(f)


def is_science_img_wrong_coordinates(f):
    return _is_science_img(f) and has_wrong_coordinates(f)


# Classification rules for spectroscopy
def is_lss(f):
    return f[kwd.ins_mode] == "LSS"


def is_mxu(f):
    return f[kwd.ins_mode] == "MXU"


def is_mos(f):
    return f[kwd.ins_mode] == "MOS"


def is_screen_flat_lss(f):
    return (is_calib_lss(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.dpr_tech] != "INS-THROUGH" and
            f[kwd.tpl_nexp] > 2)


def is_screen_flat_lss_few(f):
    return (is_calib_lss(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.dpr_tech] != "INS-THROUGH" and
            f[kwd.tpl_nexp] <= 2)


def is_screen_flat_mos(f):
    return is_calib_mos(f) and f[kwd.dpr_type] == "FLAT,LAMP" and \
        f[kwd.tpl_id] not in ["FORS1_specphot_cal_daycalib", "FORS1_specphot_cal_scrflat_fast",
                              "FORS2_specphot_cal_daycalib", "FORS2_specphot_cal_scrflat_fast"]


def is_screen_flat_mxu(f):
    return is_calib_mxu(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.ins_gris1_name] not in ["XGRIS_600B",
                                                                                                "XGRIS_300I"]


def is_screen_flat_std(f):
    return is_calib_mos(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.tpl_nexp] > 2 and \
        f[kwd.tpl_id] in ["FORS1_specphot_cal_daycalib", "FORS1_specphot_cal_scrflat_fast",
                          "FORS2_specphot_cal_daycalib", "FORS2_specphot_cal_scrflat_fast"]


def is_lamp_lss(f):
    return is_calib_lss(f) and f[kwd.dpr_type] == "WAVE,LAMP" and f[kwd.dpr_tech] != "INS-THROUGH"


def is_lamp_mos(f):
    return is_calib_mos(f) and f[kwd.dpr_type] == "WAVE,LAMP" and \
        f[kwd.tpl_id] not in ["FORS1_specphot_cal_daycalib", "FORS1_specphot_cal_wave_fast",
                              "FORS2_specphot_cal_daycalib", "FORS2_specphot_cal_wave_fast"]


def is_lamp_mxu(f):
    return is_calib_mxu(f) and f[kwd.dpr_type] == "WAVE,LAMP" and f[kwd.ins_gris1_name] not in ["XGRIS_600B",
                                                                                                "XGRIS_300I"]


def is_flat_hc_lss(f):
    return is_calib_lss(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.dpr_tech] != "INS-THROUGH" and f[
        kwd.tpl_nexp] < 3


def is_wave_hc_lss(f):
    return is_calib_lss(f) and f[kwd.dpr_type] == "WAVE,LAMP" and f[kwd.dpr_tech] != "INS-THROUGH" and f[
        kwd.tpl_nexp] < 3


def is_flat_hc_std(f):
    return is_calib_mos(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.tpl_nexp] < 3 and f[kwd.tpl_id] in [
        "FORS2_specphot_cal_scrflat_fast", "FORS2_specphot_cal_daycalib"]


def is_wave_hc_std(f):
    return is_calib_mos(f) and f[kwd.dpr_type] == "WAVE,LAMP" and f[kwd.tpl_nexp] < 3 and f[kwd.tpl_id] in [
        "FORS2_specphot_cal_wave_fast", "FORS2_specphot_cal_daycalib"]


def _is_std_lss(f):
    return is_calib_lss(f) and f[kwd.dpr_type] == "STD"


def is_std_lss(f):
    return _is_std_lss(f) and has_correct_coordinates(f)


def is_std_lss_wrong_coordinates(f):
    return _is_std_lss(f) and has_wrong_coordinates(f)


def is_chip1(f):
    return f[kwd.det_chip1_id] in ["CCID20-14-5-3", "Norma III"]


def is_chip2(f):
    return f[kwd.det_chip1_id] in ["CCID20-14-5-6", "Marlene"]


def _is_std_mos(f):
    return is_calib_mos(f) and f[kwd.dpr_type] == "STD"


def is_std_mos1(f):
    return _is_std_mos(f) and is_chip1(f) and has_correct_coordinates(f)


def is_std_mos1_wrong_coordinates(f):
    return _is_std_mos(f) and is_chip1(f) and has_wrong_coordinates(f)


def is_std_mos2(f):
    return _is_std_mos(f) and is_chip2(f) and has_correct_coordinates(f)


def is_std_mos2_wrong_coordinates(f):
    return _is_std_mos(f) and is_chip2(f) and has_wrong_coordinates(f)


def _is_sci_lss(f):
    return is_science(f) and is_lss(f) and f[kwd.dpr_type] == "SKY"


def is_sci_lss(f):
    return _is_sci_lss(f) and has_correct_coordinates(f)


def is_sci_lss_wrong_coordinates(f):
    return _is_sci_lss(f) and has_wrong_coordinates(f)


def _is_sci_mxu(f):
    return is_science(f) and is_mxu(f) and f[kwd.dpr_type] == "SKY"


def is_sci_mxu(f):
    return _is_sci_mxu(f) and has_correct_coordinates(f)


def is_sci_mxu_wrong_coordinates(f):
    return _is_sci_mxu(f) and has_wrong_coordinates(f)


def _is_sci_mos(f):
    return is_science(f) and is_mos(f) and f[kwd.dpr_type] == "SKY"


def is_sci_mos(f):
    return _is_sci_mos(f) and has_correct_coordinates(f)


def is_sci_mos_wrong_coordinates(f):
    return _is_sci_mos(f) and has_wrong_coordinates(f)


# Master calibrations for telluric correction


def is_screenflat_img(f):
    return is_img_calib(f) and \
        f[kwd.dpr_type] == "FLAT,LAMP" and \
        f[kwd.ins_lamp1_name] == "FlatBlue+1" and \
        f[kwd.ins_lamp2_name] == "FlatBlue+2" and \
        f[kwd.tpl_nexp] > 1  # maybe add an explicit `int` conversion f["nexp"]?


# Classification rules for polarimetry
#
def is_pmos(f):
    return f[kwd.ins_mode] == "PMOS"


def is_ipol(f):
    return f[kwd.ins_mode] == "IPOL" and is_fors(f)


def _is_object_ipol(f):
    return is_ipol(f) and f[kwd.dpr_type] == "OBJECT"


def is_object_ipol(f):
    return _is_object_ipol(f) and has_correct_coordinates(f)


def is_object_ipol_wrong_coordinates(f):
    return _is_object_ipol(f) and has_wrong_coordinates(f)


def _is_sky_ipol(f):
    return is_ipol(f) and f[kwd.dpr_catg] in ["CALIB", "SCIENCE"] and f[kwd.dpr_type] == "SKY"


def is_sky_ipol(f):
    return _is_sky_ipol(f) and has_correct_coordinates(f)


def is_sky_ipol_wrong_coordinates(f):
    return _is_sky_ipol(f) and has_wrong_coordinates(f)


def _is_standard_ipol(f):
    return is_ipol(f) and f[kwd.dpr_type] == "STD"


def is_standard_ipol(f):
    return _is_standard_ipol(f) and has_correct_coordinates(f)


def is_standard_ipol_wrong_coordinates(f):
    return _is_standard_ipol(f) and has_wrong_coordinates(f)


def is_flat_ipol(f):
    return is_ipol(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.tpl_nexp] > 1


def _is_std_pmos_chip1(f):
    return is_calib_pmos(f) and f[kwd.dpr_type] == "STD" and is_chip1(f)


def is_std_pmos_chip1(f):
    return _is_std_pmos_chip1(f) and has_correct_coordinates(f)


def is_std_pmos_chip1_wrong_coordinates(f):
    return _is_std_pmos_chip1(f) and has_wrong_coordinates(f)


def _is_std_pmos_chip2(f):
    return is_calib_pmos(f) and f[kwd.dpr_type] == "STD" and is_chip2(f)


def is_std_pmos_chip2(f):
    return _is_std_pmos_chip2(f) and has_correct_coordinates(f)


def is_std_pmos_chip2_wrong_coordinates(f):
    return _is_std_pmos_chip2(f) and has_wrong_coordinates(f)


def _is_science_pmos(f):
    return is_science(f) and is_pmos(f)


def is_science_pmos(f):
    return _is_science_pmos(f) and has_correct_coordinates(f)


def is_science_pmos_wrong_coordinates(f):
    return _is_science_pmos(f) and has_wrong_coordinates(f)


# Classification rules for HIT mode


def is_flat_hit_ms(f):
    return is_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.det_read_clock] == "HIT-MS" and f[kwd.tpl_nexp] > 1


def is_flat_hit(f):
    return is_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.tpl_nexp] > 1 \
        and f[kwd.det_read_clock] in ["HIT-OS1-1sec", "HIT-OS2-4sec", "HIT-OS3-16sec", "HIT-OS4-64sec",
                                      "HIT-OS5-256sec", "HIT-OS6-1024sec"]


def _is_std_hit(f):
    return is_calib(f) and f[kwd.dpr_type] == "STD" and f[kwd.dpr_tech] != "SPECTRUM" and \
        f[kwd.det_read_clock] in ["HIT-OS1-1sec", "HIT-OS2-4sec", "HIT-OS3-16sec",
                                  "HIT-OS4-64sec", "HIT-OS5-256sec", "HIT-OS6-1024sec"]


def is_std_hit(f):
    return _is_std_hit(f) and has_correct_coordinates(f)


def is_std_hit_wrong_coordinates(f):
    return _is_std_hit(f) and has_wrong_coordinates(f)


def _is_std_s_hit(f):
    return is_calib(f) and f[kwd.dpr_type] == "STD" and f[kwd.dpr_tech] == "SPECTRUM" and \
        f[kwd.det_read_clock] in ["HIT-OS1-1sec", "HIT-OS2-4sec", "HIT-OS3-16sec",
                                  "HIT-OS4-64sec", "HIT-OS5-256sec", "HIT-OS6-1024sec"]


def is_std_s_hit(f):
    return _is_std_s_hit(f) and has_correct_coordinates(f)


def is_std_s_hit_wrong_coordinates(f):
    return _is_std_s_hit(f) and has_wrong_coordinates(f)


def _is_std_ms_hit(f):
    return is_science(f) and f[kwd.dpr_type] == "OBJECT" and f[kwd.det_read_clock] == "HIT-MS"


def is_std_ms_hit(f):
    return _is_std_ms_hit(f) and has_correct_coordinates(f)


def is_std_ms_hit_wrong_coordinates(f):
    return _is_std_ms_hit(f) and has_wrong_coordinates(f)


def _is_sci_hit(f):
    return is_science(f) and f[kwd.dpr_type] == "SKY" and f[kwd.dpr_tech] != "SPECTRUM" and \
        f[kwd.det_read_clock] in ["HIT-OS1-1sec", "HIT-OS2-4sec", "HIT-OS3-16sec",
                                  "HIT-OS4-64sec", "HIT-OS5-256sec", "HIT-OS6-1024sec"]


def is_sci_hit(f):
    return _is_sci_hit(f) and has_correct_coordinates(f)


def is_sci_hit_wrong_coordinates(f):
    return _is_sci_hit(f) and has_wrong_coordinates(f)


def _is_sci_s_hit(f):
    return is_science(f) and f[kwd.dpr_type] == "OBJECT" and f[kwd.dpr_tech] == "SPECTRUM" and \
        f[kwd.det_read_clock] in ["HIT-OS1-1sec", "HIT-OS2-4sec", "HIT-OS3-16sec",
                                  "HIT-OS4-64sec", "HIT-OS5-256sec", "HIT-OS6-1024sec"]


def is_sci_s_hit(f):
    return _is_sci_s_hit(f) and has_correct_coordinates(f)


def is_sci_s_hit_wrong_coordinates(f):
    return _is_sci_s_hit(f) and has_wrong_coordinates(f)


def _is_sci_ms_hit(f):
    return is_science(f) and f[kwd.dpr_type] == "SKY" and f[kwd.det_read_clock] == "HIT-MS"


def is_sci_ms_hit(f):
    return _is_sci_ms_hit(f) and has_correct_coordinates(f)


def is_sci_ms_hit_wrong_coordinates(f):
    return _is_sci_ms_hit(f) and has_wrong_coordinates(f)


# --- Association rules ----------------------------------------------------------------------------
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)

# -- Unconditional association
def is_assoc(ref, f):
    return True


# -- Association rules for spectroscopy  ---
def is_assoc_screen_flat_mos(ref, f):
    return match(ref, f, match_screen_flat) and abs(f[kwd.ins_mos_checksum] - ref[kwd.ins_mos_checksum]) <= 1


def is_assoc_screen_flat_std(ref, f):
    return match(ref, f, match_screen_flat) and abs(f[kwd.ins_mos_checksum] - ref[kwd.ins_mos_checksum]) <= 1


def is_assoc_screen_flat_mxu(ref, f):
    return match(ref, f, match_screen_flat + [kwd.ins_mask_id]) and f[kwd.ins_mask_name] != "M012Distorti"


def is_assoc_screen_flat_lss(ref, f):
    return match(ref, f, match_screen_flat + [kwd.ins_slit_name])


def is_assoc_lamp(ref, f):
    return (is_assoc_lamp_mos(ref, f) if ref[kwd.ins_mode] == "MOS" else
            (is_assoc_lamp_mxu(ref, f) or is_assoc_lamp_mxu_wide(ref, f)) if ref[kwd.ins_mode] == "MXU" else
            is_assoc_lamp_lss(ref, f) if ref[kwd.ins_mode] == "LSS" else False)


def is_assoc_lamp_mos(ref, f):
    return match(ref, f, match_wavelength + [kwd.ins_mode]) and abs(
        f[kwd.ins_mos_checksum] - ref[kwd.ins_mos_checksum]) <= 1 and \
        (f[kwd.mjd_obs] <= 54032.0 or ref[kwd.tpl_start] == f[kwd.tpl_start])


def is_assoc_lamp_mxu(ref, f):
    return match(ref, f, match_wavelength + [kwd.ins_mask_id, kwd.ins_mode]) and \
        (f[kwd.mjd_obs] <= 54032.0 or (f[kwd.mjd_obs] > 54032.0 and ref[kwd.tpl_start] == f[kwd.tpl_start])) and \
        f[kwd.ins_mos107_wid] < 2


def is_assoc_lamp_mxu_wide(ref, f):
    return match(ref, f, match_wavelength + xy107108pos + [kwd.ins_mode]) and f[kwd.ins_mos107_wid] < 2


def is_assoc_lamp_lss(ref, f):
    return match(ref, f, match_wavelength + [kwd.ins_slit_name, kwd.ins_mode]) and \
        (f[kwd.mjd_obs] <= 54032.0 or (f[kwd.mjd_obs] > 54032.0 and ref[kwd.tpl_start] == f[kwd.tpl_start]))


def is_assoc_std_mos_to_lss(ref, f):
    cond = match(ref, f, [kwd.ins_coll_name, kwd.ins_opti5_name, kwd.ins_opti6_name, kwd.ins_opti7_name,
                          kwd.ins_opti9_name, kwd.ins_opti10_name, kwd.ins_gris1_id, kwd.ins_gris1_name,
                          kwd.det_binx, kwd.det_biny, kwd.instrume]) \
           and ((ref[kwd.det_chip1_name] == f[kwd.det_chip1_name] and
                 (f[kwd.det_chip1_id] == "CCID20-14-5-3" or f[kwd.det_chip1_id] == "Norma III"))
                or like(f[kwd.det_chip1_id], 'TK2048EB4%') and ref[kwd.det_chip1_id] == f[kwd.det_chip1_id]) \
           and ((f[kwd.seq_spec_targ] == "LSS_0.3_arcsec" and ref[kwd.ins_slit_name] == "lSlit0_3arcsec") or
                (f[kwd.seq_spec_targ] == "LSS_0.4_arcsec" and ref[kwd.ins_slit_name] == "lSlit0_4arcsec") or
                (f[kwd.seq_spec_targ] == "LSS_0.5_arcsec" and ref[kwd.ins_slit_name] == "lSlit0_5arcsec") or
                (f[kwd.seq_spec_targ] == "LSS_0.7_arcsec" and ref[kwd.ins_slit_name] == "lSlit0_7arcsec") or
                (f[kwd.seq_spec_targ] == "LSS_1.0_arcsec" and ref[kwd.ins_slit_name] == "lSlit1_0arcsec") or
                (f[kwd.seq_spec_targ] == "LSS_1.3_arcsec" and ref[kwd.ins_slit_name] == "lSlit1_3arcsec") or
                (f[kwd.seq_spec_targ] == "LSS_1.6_arcsec" and ref[kwd.ins_slit_name] == "lSlit1_6arcsec") or
                (f[kwd.seq_spec_targ] == "LSS_2.0_arcsec" and ref[kwd.ins_slit_name] == "lSlit2_0arcsec") or
                (f[kwd.seq_spec_targ] == "LSS_2.5_arcsec" and ref[kwd.ins_slit_name] == "lSlit2_5arcsec") or
                f[kwd.seq_spec_targ] == "MOS_center")
    return cond


def is_assoc_std_mos_to_mosmxu(ref, f):
    c1 = match(ref, f, [kwd.ins_coll_name, kwd.ins_opti5_name, kwd.ins_opti6_name, kwd.ins_opti7_name,
                        kwd.ins_opti9_name, kwd.ins_opti10_name, kwd.ins_gris1_id, kwd.ins_gris1_name,
                        kwd.det_binx, kwd.det_biny, kwd.instrume, kwd.det_read_clock])

    c2 = (ref[kwd.det_chip1_id] == "CCID20-14-5-6" or ref[kwd.det_chip1_id] == "Marlene") and \
         ref[kwd.det_chip1_name] == f[kwd.det_chip1_name] and \
         (f[kwd.det_chip1_id] == "CCID20-14-5-3" or f[kwd.det_chip1_id] == "Norma III")

    c3 = (ref[kwd.det_chip1_id] == "CCID20-14-5-3" or ref[kwd.det_chip1_id] == "Norma III") and \
         match(ref, f, [kwd.det_chip1_id])

    return c1 and (c2 or c3)


# ---------------------------------------------------------------------------------------------------------------

# --- Association rules for Polarimetry  ---
def is_assoc_screen_flat_pmos(ref, f):
    return match(ref, f, match_screen_flat) and abs(f[kwd.ins_mos_checksum] - ref[kwd.ins_mos_checksum]) <= 1


def is_assoc_lamp_pmos(ref, f):
    return match(ref, f, match_lamp_pmos) and abs(f[kwd.ins_mos_checksum] - ref[kwd.ins_mos_checksum]) <= 1 and \
        ((f[kwd.mjd_obs] <= 54032.0) or ((f[kwd.mjd_obs] > 54032.0) and (f[kwd.tpl_start] == ref[kwd.tpl_start])))


# ---------------------------------------------------------------------------------------------------------------

# Temporary association rules to cope with the fact that min_group_size for biases and sky_flats foreseen by the
# calibration plan are not always fulfilled
# --- Association rules ----------------------------------------------------------------------------
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)
def is_assoc_bias_calibration_plan(ref, f):
    return match(ref, f, match_bias) and f[kwd.tpl_nexp] > 19


def is_assoc_skyflat_calibration_plan(ref, f):
    return match(ref, f, match_img_flat) and f[kwd.tpl_nexp] > 4


def match_static_phot_table(ref, f):
    same_instrument = ref[kwd.instrume] == f[kwd.instrume]
    same_chip1_name = ref[kwd.det_chip1_name] == f[kwd.det_chip1_name]
    same_chip1_id = ref[kwd.det_chip1_id] == f[kwd.det_chip1_id]
    if ref[kwd.instrume] == "FORS1":
        return same_instrument and (same_chip1_name or (ref[kwd.det_chip1_id] == "TK2048EB4-1 1604" and same_chip1_id))
    elif ref[kwd.instrume] == "FORS2":
        return same_instrument and same_chip1_name
    else:
        return False
