# Tasks that are in common are imported from the fors_common module
from edps import FilterMode, CALCHECKER, SCIENCE, task, QC1_CALIB, QC0, ReportInput

from .fors_common import bias, calibration_lss, calibration_std, calibration_mxu, calibration_mos, calibration_hc_std, \
    calibration_hc_lss, science_notc
from .fors_datasources import *
from .fors_task_functions import *

__title__ = "FORS spectroscopic workflow"

# --- PROCESSING TASKS -----------------------------------------------------------------------------
imported_tasks = [bias, calibration_lss, calibration_std, calibration_mxu, calibration_mos, calibration_hc_std,
                  calibration_hc_lss]

# --- Task for monitoring the flux of lamps
lamp_monitor = (task('lamp_monitor')
                .with_recipe('fors_sumflux')
                .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
                .with_report("fors_flat_spec_lss", ReportInput.RECIPE_INPUTS_OUTPUTS)
                .with_main_input(raw_lamp_check)
                .with_meta_targets([QC1_CALIB])
                .build())

# --- Tasks for processing the standard stars -----------------------------------------------------
# Processing standard stars for LSS observations
standard_lss = (task('standard_lss')
                .with_recipe('fors_science')
                .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
                .with_report("fors_spec_std_star", ReportInput.RECIPE_INPUTS_OUTPUTS)
                .with_main_input(raw_std_lss)
                .with_associated_input(bias, [MASTERBIAS])
                .with_associated_input(calibration_lss,
                                       [master_norm_flat_lss, disp_coeff_lss, slit_location_lss, flat_sed_lss])
                .with_associated_input(grism_table)
                .with_associated_input(std_flux_table)
                .with_associated_input(extinct_table)
                .with_associated_input(telluric_contamination)
                .with_meta_targets([QC1_CALIB, CALCHECKER])
                .build())

# Processing standard stars for MOS observations
standard_mos = (task('standard_mos')
                .with_recipe('fors_science')
                .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
                .with_report("fors_spec_std_star", ReportInput.RECIPE_INPUTS_OUTPUTS)
                .with_main_input(raw_std_mos)
                .with_associated_input(bias, [MASTERBIAS])
                .with_associated_input(calibration_std, [master_norm_flat_long_mos, disp_coeff_long_mos,
                                                         slit_location_long_mos, flat_sed_long_mos])
                .with_associated_input(grism_table)
                .with_associated_input(std_flux_table)
                .with_associated_input(extinct_table)
                .with_associated_input(telluric_contamination)
                .with_meta_targets([QC1_CALIB, CALCHECKER])
                .build())
# -------------------------------------------------------------------------------------------------

# --- Task for processing science observations  ---------------------------------------------------
science = (task('science_spectra')
           .with_recipe('fors_science')
           .with_main_input(raw_sci)
           .with_dynamic_parameter('ins_mode', which_observation_type)
           .with_dynamic_parameter('bin_clock', which_bin_clock)
           .with_associated_input(bias, [MASTERBIAS])
           .with_associated_input(calibration_mos,
                                  [master_norm_flat_mos, disp_coeff_mos, slit_location_mos,
                                   flat_sed_mos, curv_coeff_mos], condition=is_mos)
           .with_associated_input(calibration_lss,
                                  [master_norm_flat_lss, disp_coeff_lss, slit_location_lss, flat_sed_lss],
                                  condition=is_lss)
           .with_associated_input(calibration_mxu,
                                  [master_norm_flat_mxu, disp_coeff_mxu, slit_location_mxu, flat_sed_mxu,
                                   curv_coeff_mxu], condition=is_mxu)
           # standard_mos can be mandatory and can have different association rules depending on the type of input data
           .with_associated_input(standard_mos, [specphot_table], condition=is_lss_regular,
                                  match_rules=match_std_mos_to_lss)
           .with_associated_input(standard_mos, [specphot_table], condition=is_mos_regular,
                                  match_rules=match_std_mos_to_mosmxu)
           .with_associated_input(standard_mos, [specphot_table], condition=is_mxu_regular,
                                  match_rules=match_std_mos_to_mosmxu)
           .with_associated_input(standard_mos, [specphot_table], condition=is_lss_other,
                                  match_rules=match_std_mos_to_lss, min_ret=0)
           .with_associated_input(standard_mos, [specphot_table], condition=is_mos_other,
                                  match_rules=match_std_mos_to_mosmxu, min_ret=0)
           .with_associated_input(standard_mos, [specphot_table], condition=is_mxu_other,
                                  match_rules=match_std_mos_to_mosmxu, min_ret=0)
           .with_associated_input(master_specphot_table, min_ret=0)
           .with_associated_input(grism_table)
           .with_associated_input(extinct_table, min_ret=0)
           .with_associated_input(global_distortion_table, min_ret=0, condition=is_lss)
           .with_associated_input(master_skylinecat, min_ret=0)
           .with_associated_input(eop_parameters, min_ret=0)
           .with_associated_input(acquisition_sky_spec, min_ret=0, max_ret=3)
           .with_associated_input(acquisition_slit_spec, min_ret=0, max_ret=3)
           .with_associated_input(reduced_std, min_ret=0)
           .with_input_filter(REDUCED_STD, acquisition_mxu_sky_class, acquisition_mxu_slit_class,
                              acquisition_lss_sky_class, acquisition_lss_slit_class,
                              acquisition_mos_slit_class, acquisition_mos_sky_class, mode=FilterMode.REJECT)
           .with_meta_targets([SCIENCE, CALCHECKER, science_notc, QC0])
           .with_job_processing(set_skysub)
           .build())

# --- Task for telluric correction (only for Long Slit data).
telluric = (task('telluric_correction')
            .with_function(telluric_correction)
            .with_main_input(science)
            .with_associated_input(molecules, min_ret=0)
            .with_associated_input(atm_profile_standard, min_ret=0)
            .with_associated_input(pix_exclude, min_ret=0)
            .with_associated_input(wave_include, min_ret=0)
            .with_associated_input(wave_exclude, min_ret=0)
            .with_associated_input(kernel_library, min_ret=0)
            .with_associated_input(gdas, min_ret=0)
            .with_meta_targets([SCIENCE])
            .build())
