/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_ATM_COMBINED_GDAS_H
#define MF_ATM_COMBINED_GDAS_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

#include "mf_constants.h"
#include "mf_parameters.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

#define MF_MERGE_FRAC        0.2            /* Height fraction relative to highest valid GDAS layer used for interpolating between GDAS and standard profile */
#define MF_R                 8.314451       /* Gas constant in J/(mol K) */
#define MF_MOL_MASS_H2O      0.0182         /* mol mass of H2O in kg     */

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

/* Check the user ATM_PROFILE_STANDARD cpl_table structure */
MF_EXPORT cpl_error_code mf_atm_profile_standard_check(
    const cpl_table          *table);

/* Check the user ATM_PROFILE_COMBINED cpl_table structure */
MF_EXPORT cpl_error_code mf_atm_profile_combined_check(
    const cpl_table          *table);

/* Creates a combined atmospheric profile standard with GDAS interpolate data */
MF_INTERNAL cpl_table * mf_atm_combined_gdas(
    const mf_parameters      *params,
    const cpl_table          *gdas_user,
    const cpl_table          *atm_profile_standard_user,
    cpl_table                **gdas_profile1,
    cpl_table                **gdas_profile2,
    cpl_table                **gdas_interpolate,
    cpl_table                **atm_profile_standard,
    const char               **gdas_src);


CPL_END_DECLS


#endif /* MF_ATM_COMBINED_GDAS_H */
