/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_MOLECULES_H
#define MF_MOLECULES_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

#include "mf_constants.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

/*** Internal parameters ***/

#define MF_MOLECULES_NUMBER                           "NUMBER_AER_MOLECULES"
#define MF_MOLECULES_NUMBER_DESC                      ""
#define MF_MOLECULES_NUMBER_MIN                       1
#define MF_MOLECULES_NUMBER_MAX                       47
#define MF_MOLECULES_NUMBER_INIT                      1

#define MF_MOLECULES_FIT_ARRAY_FLAGS                  "LBL_MOLECULES_FIT_ARRAY_FLAGS"
#define MF_MOLECULES_FIT_ARRAY_FLAGS_DESC             "Flags to fit the column density of the molecules. Size array = "MF_MOLECULES_NUMBER_MAX
#define MF_MOLECULES_FIT_ARRAY_FLAGS_INIT             "00000000000000000000000000000000000000000000000"


/*** Molecules : Names/Positions ***/

#define MF_MOLECULES_H2O                              "H2O"
#define MF_MOLECULES_H2O_POS                          0

#define MF_MOLECULES_CO2                              "CO2"
#define MF_MOLECULES_CO2_POS                          1

#define MF_MOLECULES_O3                               "O3"
#define MF_MOLECULES_O3_POS                           2

#define MF_MOLECULES_N2O                              "N2O"
#define MF_MOLECULES_N2O_POS                          3

#define MF_MOLECULES_CO                               "CO"
#define MF_MOLECULES_CO_POS                           4

#define MF_MOLECULES_CH4                              "CH4"
#define MF_MOLECULES_CH4_POS                          5

#define MF_MOLECULES_O2                               "O2"
#define MF_MOLECULES_O2_POS                           6

#define MF_MOLECULES_NO                               "NO"
#define MF_MOLECULES_NO_POS                           7

#define MF_MOLECULES_SO2                              "SO2"
#define MF_MOLECULES_SO2_POS                          8

#define MF_MOLECULES_NO2                              "NO2"
#define MF_MOLECULES_NO2_POS                          9

#define MF_MOLECULES_NH3                              "NH3"
#define MF_MOLECULES_NH3_POS                          10

#define MF_MOLECULES_HNO3                             "HNO3"
#define MF_MOLECULES_HNO3_POS                         11

#define MF_MOLECULES_OH                               "OH"
#define MF_MOLECULES_OH_POS                           12

#define MF_MOLECULES_HF                               "HF"
#define MF_MOLECULES_HF_POS                           13

#define MF_MOLECULES_HCL                              "HCL"
#define MF_MOLECULES_HCL_POS                          14

#define MF_MOLECULES_HBR                              "HBR"
#define MF_MOLECULES_HBR_POS                          15

#define MF_MOLECULES_HI                               "HI"
#define MF_MOLECULES_HI_POS                           16

#define MF_MOLECULES_CLO                              "CLO"
#define MF_MOLECULES_CLO_POS                          17

#define MF_MOLECULES_OCS                              "OCS"
#define MF_MOLECULES_OCS_POS                          18

#define MF_MOLECULES_H2CO                             "H2CO"
#define MF_MOLECULES_H2CO_POS                         19

#define MF_MOLECULES_HOCL                             "HOCL"
#define MF_MOLECULES_HOCL_POS                         20

#define MF_MOLECULES_N2                               "N2"
#define MF_MOLECULES_N2_POS                           21

#define MF_MOLECULES_HCN                              "HCN"
#define MF_MOLECULES_HCN_POS                          22

#define MF_MOLECULES_CH3CL                            "CH3CL"
#define MF_MOLECULES_CH3CL_POS                        23

#define MF_MOLECULES_H2O2                             "H2O2"
#define MF_MOLECULES_H2O2_POS                         24

#define MF_MOLECULES_C2H2                             "C2H2"
#define MF_MOLECULES_C2H2_POS                         25

#define MF_MOLECULES_C2H6                             "C2H6"
#define MF_MOLECULES_C2H6_POS                         26

#define MF_MOLECULES_PH3                              "PH3"
#define MF_MOLECULES_PH3_POS                          27

#define MF_MOLECULES_COF2                             "COF2"
#define MF_MOLECULES_COF2_POS                         28

#define MF_MOLECULES_SF6                              "SF6"
#define MF_MOLECULES_SF6_POS                          29

#define MF_MOLECULES_H2S                              "H2S"
#define MF_MOLECULES_H2S_POS                          30

#define MF_MOLECULES_HCOOH                            "HCOOH"
#define MF_MOLECULES_HCOOH_POS                        31

#define MF_MOLECULES_HO2                              "HO2"
#define MF_MOLECULES_HO2_POS                          32

#define MF_MOLECULES_O                                "O"
#define MF_MOLECULES_O_POS                            33

#define MF_MOLECULES_CLONO2                           "CLONO2"
#define MF_MOLECULES_CLONO2_POS                       34

#define MF_MOLECULES_NO_P                             "NO+"
#define MF_MOLECULES_NO_P_POS                         35

#define MF_MOLECULES_HOBR                             "HOBR"
#define MF_MOLECULES_HOBR_POS                         36

#define MF_MOLECULES_C2H4                             "C2H4"
#define MF_MOLECULES_C2H4_POS                         37

#define MF_MOLECULES_CH3OH                            "CH3OH"
#define MF_MOLECULES_CH3OH_POS                        38

#define MF_MOLECULES_CH3BR                            "CH3Br"
#define MF_MOLECULES_CH3BR_POS                        39

#define MF_MOLECULES_CH3CN                            "CH3CN"
#define MF_MOLECULES_CH3CN_POS                        40

#define MF_MOLECULES_CF4                              "CF4"
#define MF_MOLECULES_CF4_POS                          41

#define MF_MOLECULES_C4H2                             "C4H2"
#define MF_MOLECULES_C4H2_POS                         42

#define MF_MOLECULES_HC3N                             "HC3N"
#define MF_MOLECULES_HC3N_POS                         43

#define MF_MOLECULES_H2                               "H2"
#define MF_MOLECULES_H2_POS                           44

#define MF_MOLECULES_CS                               "CS"
#define MF_MOLECULES_CS_POS                           45

#define MF_MOLECULES_SO3                              "SO3"
#define MF_MOLECULES_SO3_POS                          46

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

/*  */
typedef struct {
  int                        n_molec;                  /*  */
  char                       *lbl_molecs;              /*  */
} mf_molecules;

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

/* Check the molecules cpl_table structure */
MF_EXPORT cpl_error_code mf_molecules_check(
    const cpl_table          *table);

/* FIXME: Maybe we don't need it */
MF_INTERNAL cpl_error_code mf_molecules_lbl_fill(
    const cpl_table         *molecules,
    int                     *n_molec,
    char                    **lbl_molecs);

/*  */
MF_INTERNAL cpl_array * mf_molecules_create_array(void);

/* Check a string that contain a Molecule name in order to be sure that is a valid molecule in telluriccorr */
MF_EXPORT cpl_error_code mf_molecules_str_check(
    const char              *molec);            /* String with a molecule name */


CPL_END_DECLS


#endif /* MF_MOLECULES_H */
