from edps import match

from . import giraffe_keywords as kwd


# ASSOCIATION RULES
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)

def associate_slit_setup(ref, f):
    c1 = match(ref, f, [kwd.ins_slit_name, kwd.ins_exp_mode]) and ref[kwd.mjd_obs] > 54557
    c2 = match(ref, f, [kwd.ins_slit_name, kwd.ins_grat_name, kwd.ins_grat_wlen]) and ref[kwd.mjd_obs] <= 54557
    return c1 or c2


def associate_disp_solution(ref, f):
    c1 = match(ref, f, [kwd.ins_slit_name, kwd.ins_exp_mode, kwd.det_read_speed]) and ref[kwd.mjd_obs] > 54557
    c2 = match(ref, f, [kwd.ins_slit_name, kwd.ins_grat_name, kwd.ins_grat_wlen, kwd.det_read_speed]) and \
         ref[kwd.mjd_obs] <= 54557
    return c1 or c2


def associate_flux_standard(ref, f):
    return f[kwd.ins_mode] in ["IFU", "ARG"] and \
        match(ref, f, [kwd.ins_slit_name, kwd.ins_exp_mode, kwd.det_read_speed])
