from .giraffe_utils import GiraffeSetupInfo
from adari_core.data_libs.master_spec_flat import MasterSpecFlatReport
from adari_core.plots.text import TextPlot
from adari_core.utils.utils import fetch_kw_or_default
import os
import logging

logger = logging.getLogger(__name__)


class GiraffeFlatReport(MasterSpecFlatReport):
    category_label = ""
    center_size = 200

    def __init__(self):
        super().__init__("giraffe_flat")

    def parse_sof(self):
        master_flat = None
        raw_flat = None

        for filename, catg in self.inputs:
            if catg == "FIBER_FLAT" and raw_flat is None:
                raw_flat = filename
            elif catg == "MASTER_FIBER_FLAT" and master_flat is None:
                master_flat = filename

        file_lists = []
        if master_flat is not None and raw_flat is not None:
            file_lists.append(
                {
                    "master_im": master_flat,
                    "raw_im": raw_flat,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):
        vspace = 0.3

        logger.info("Working on category {} report".format(self.category_label))
        panels = {}
        new_panels = super().generate_panels(
            raw_map=True,
            raw_hist_scale=True,
            raw_hist_scale_val=(-5000, 70000),
            master_hist_scale=True,
            master_hist_scale_val=(-5000, 70000),
        )

        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            master_im = self.hdus[i]["master_im"]
            instru = fetch_kw_or_default(
                master_im["PRIMARY"], "INSTRUME", "Missing INSTRUME"
            )
            master_procatg = fetch_kw_or_default(
                master_im["PRIMARY"], "HIERARCH ESO PRO CATG", "Missing PRO CATG"
            )
            fname = os.path.basename(str(master_im.filename()))
            t1 = TextPlot(columns=1, v_space=vspace)
            col1 = (
                instru,
                "EXTNAME: "
                + str(fetch_kw_or_default(master_im["PRIMARY"], "EXTNAME", "N/A")),
                "PRO CATG: " + str(master_procatg),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(
                    fetch_kw_or_default(
                        master_im["PRIMARY"],
                        "HIERARCH ESO PRO REC1 RAW1 NAME",
                        "Missing RAW1 NAME",
                    )
                ),
            )
            t1.add_data(col1)
            panel.assign_plot(t1, 0, 0, xext=1)
            t2 = TextPlot(columns=1, v_space=vspace)
            col2 = GiraffeSetupInfo.flat(list(self.hdus[0].values())[0])
            t2.add_data(col2)
            panel.assign_plot(t2, 1, 0, xext=1)

        panels = {**panels, **new_panels}

        return panels


rep = GiraffeFlatReport()
