from adari_core.plots.text import TextPlot
from adari_core.data_libs.master_dark_bias import MasterDarkBiasReport

from .giraffe_utils import GiraffeSetupInfo

from .giraffe_utils import GiraffeReportMixin

import os


class GiraffeMasterDarkReport(GiraffeReportMixin, MasterDarkBiasReport):
    def __init__(self):
        super().__init__("giraffe_master_dark")

    def parse_sof(self):
        master_dark = None

        for filename, catg in self.inputs:
            if catg == "MASTER_DARK" and master_dark is None:
                master_dark = filename

        file_lists = []
        if master_dark is not None:
            file_lists.append(
                {
                    "master_im": master_dark,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):
        vspace = 0.3
        panels = {}

        ext = "PRIMARY"
        panels = super().generate_raw_cuts_panels(
            master_im_ext=ext,
            im_clipping="mad",
            im_n_clipping=4,
            im_zoom_clipping="percentile",
            im_zoom_n_clipping=95,
            master_im_clipping="percentile",
            master_im_n_clipping=95,
            master_im_zoom_clipping="mad",
            master_im_zoom_n_clipping=3,
            hist_clipping="sigma",
            hist_n_clipping=7,
            cut_clipping="percentile",
            cut_n_clipping=95,
            cut_min_span=None,
            cut_cent_clipping="percentile",
            cut_cent_n_clipping=95,
            cut_cent_min_span=None,
            collapse_clipping="percentile",
            collapse_n_clipping=98,
        )
        for i, (panel, panel_descr) in enumerate(panels.items()):
            master_im = self.hdus[i]["master_im"]
            fname = os.path.basename(str(master_im.filename()))
            fname_date = fname.removesuffix(".fits")
            panel_descr["report_description"] = (
                f"GIRAFFE dark panel - "
                f"{os.path.basename(panel_descr['master_im'])}, "
                f"{panel_descr['master_im_ext']}"
            )
            panel_descr["report_name"] = f"GIRAFFE_{fname_date}_{ext}"

            t1 = TextPlot(columns=1, v_space=vspace)
            col1 = (
                str(master_im[ext].header.get("INSTRUME")),
                "EXTNAME: " + ext,
                "PRO CATG: " + str(master_im[ext].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(master_im[ext].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")),
            )
            t1.add_data(col1)
            panel.assign_plot(t1, 0, 0, xext=2)

            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = GiraffeSetupInfo.dark(self.hdus[i]["master_im"])
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

        return panels


rep = GiraffeMasterDarkReport()
