from edps import subworkflow, task, qc0, qc1calib, ReportInput

from .giraffe_datasources import *


@subworkflow("quality_control", "")
def quality_control(bias, fibre_flat, wavecal):
    # This subworkflows collects tasks that are not used in the reduction cascade, but are used either to run recipes that
    # monitor detector perfomances or computes quality control parameters, or generate quality control plots.

    # Determination of the linearity level of the detector. It is used for monitoring purposes only; its products are
    # not used in the data reduction.
    detmon = (task('detector_monitoring')
              .with_recipe('detmon_opt_lg')
              .with_report('giraffe_rawdisp', ReportInput.RECIPE_INPUTS)
              .with_report('giraffe_detmon', ReportInput.RECIPE_INPUTS_OUTPUTS)
              .with_main_input(raw_detlin)
              .with_meta_targets([qc1calib])
              .build())

    # Determination of the grating position by measuring the position of arg lines.
    grating_position = (task("grating_position")
                        .with_recipe('giwavecalibration')
                        .with_report('giraffe_rawdisp', ReportInput.RECIPE_INPUTS)
                        .with_main_input(raw_simlamp)
                        .with_associated_input(bias, [master_bias_class])
                        .with_associated_input(fibre_flat, [ff_loccentroid_class, ff_locwidth_class])
                        .with_associated_input(wavecal, [dispersion_solution_class])
                        .with_associated_input(line_catalog)
                        .with_associated_input(grating_properties)
                        .with_associated_input(slit_geometry_setup)
                        .with_meta_targets([qc1calib])
                        .build())

    # Display the acquisition frames into a quality report plot.
    acquisition = (task("acquisition")
                   .with_main_input(raw_acquisition)
                   .with_meta_targets([qc0])
                   .build())

    return detmon, grating_position, acquisition
