from adari_core.data_libs.master_rawdisp import MasterRawdispReport
from .giraffe_utils import GiraffeSetupInfo
from .giraffe_utils import GiraffeReportMixin

import os


class GiraffeRawdispReport(GiraffeReportMixin, MasterRawdispReport):
    def __init__(self):
        super().__init__("giraffe_rawdisp")
        self.extensions = []
        self.tasks = {
            "BIAS": "bias",
            "DARK": "dark",
            #
            "FIBER_FLAT": "flat",
            #
            "ON_RAW": "detmon",
            "OFF_RAW": "detmon",
            #
            "ARC_SPECTRUM": "wavecalibration",
            # "SIMLAMP": "grating_position",
            #
            "STD": "response",
        }
        self.setup_info = GiraffeSetupInfo

    def parse_sof(self):
        # we building multiple report sets, so we append multiple reports to file_lists
        # get a list of tags
        ext = "PRIMARY"
        tags = list(self.tasks.keys())
        added = {}
        file_lists = []
        for filename, catg in self.inputs:
            if catg in tags:
                if filename is not None and catg not in added:
                    file_lists.append({"filename": filename})
                    added[catg] = self.tasks[catg]
                    self.sof_tag.append(catg)
                    self.extensions.append(ext)
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        new_panels = super().generate_panels(ext=self.extensions, **kwargs)
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            # depending on task name
            try:
                task_name = panel_descr["task_name"]
            except KeyError:
                raise RuntimeError(
                    "A report has been created by "
                    "MasterRawdispReport that did "
                    "not come back with a task name "
                    "attached!"
                )
            panel_descr["report_name"] = "giraffe_rawdisp_{}_{}_{}_{}".format(
                task_name,
                self.extensions[i],
                self.sof_tag[i].lower(),
                os.path.basename(panel_descr["filename"]),
            )
            panel_descr["report_description"] = (
                f"GIRAFFE rawdisp panel - "
                f"{panel_descr['task_name']}, "
                f"{panel_descr['tag']}, "
                f"{os.path.basename(panel_descr['filename'])}, "
                f"{panel_descr['ext']}"
            )
        panels = {**panels, **new_panels}

        return panels


rep = GiraffeRawdispReport()
