from adari_core.utils.utils import fetch_kw_or_default

class GiraffeReportMixin(object):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._version = "TBD"

def met1(hdul):
    m = [
        "DET.READ.SPEED: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO DET READ SPEED", default="N/A"
            )
        ),
    ]
    return m


def meta(hdul):
    metadata = [
        "DET.READ.SPEED: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO DET READ SPEED", default="N/A"
            )
        ),
        "INS.SLIT.NAME: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS SLIT NAME", default="N/A"
            )
        ),
        "INS.EXP.MODE: "
        + str(
            fetch_kw_or_default(
                hdul["PRIMARY"], "HIERARCH ESO INS EXP MODE", default="N/A"
            )
        ),
    ]
    return metadata


class GiraffeSetupInfo:
    @staticmethod
    def dark(hdul):
        metadata = met1(hdul)
        return metadata

    @staticmethod
    def bias(hdul):
        metadata = met1(hdul)
        return metadata

    @staticmethod
    def detmon(hdul):
        metadata = met1(hdul)
        return metadata

    @staticmethod
    def flat(hdul):
        metadata = meta(hdul)
        return metadata

    @staticmethod
    def wavecalibration(hdul):
        metadata = meta(hdul)
        return metadata

    @staticmethod
    def response(hdul):
        metadata = meta(hdul)
        metadata = metadata + [
            "OBS.TARG.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO OBS TARG NAME", default="N/A"
                )
            ),
        ]
        return metadata
