from edps import subworkflow, task, qc1calib, calchecker, match_rules, ReportInput

from .giraffe_datasources import *


def create_response_task(raw_input, taskname, bias, dark, fibre_flat, wavecal):
    # This function creates a task named after the input "taskname" that process the "raw_input".
    # The input variable "raw_input" can be either raw_standard_ifu or raw_standard_argus.
    # The input variable "taskname" can be either response_ifu or response_argus, according to the type of raw_inputs

    # Time ranges for associating flat and arc calibrations to standard are different than those of other exposures
    associate_flats = (match_rules()
                       .with_match_keywords(setup, time_range=RelativeTimeRange(-1.5, 1.5), level=0)
                       .with_match_keywords(setup, time_range=TWO_WEEKS, level=1)
                       .with_match_keywords(setup, time_range=UNLIMITED, level=3))

    associate_arcs = (match_rules()
                      .with_match_keywords(setup, time_range=RelativeTimeRange(-1.5, 1.5), level=0)
                      .with_match_keywords(setup, time_range=TWO_WEEKS, level=1)
                      .with_match_keywords(setup, time_range=UNLIMITED, level=3))

    response_task = (task(taskname)
                     .with_recipe('gistandard')
                     .with_report('giraffe_rawdisp', ReportInput.RECIPE_INPUTS)
                     .with_report('giraffe_std_star', ReportInput.RECIPE_INPUTS_OUTPUTS)
                     .with_main_input(raw_input)
                     .with_associated_input(bias, [master_bias_class, bad_pixel_map_class])
                     .with_associated_input(dark, [master_dark_class], min_ret=0)
                     .with_associated_input(fibre_flat, [ff_loccentroid_class, ff_locwidth_class, ff_extspectra_class],
                                            match_rules=associate_flats)
                     .with_associated_input(wavecal, [dispersion_solution_class], match_rules=associate_arcs)
                     .with_associated_input(grating_properties)
                     .with_associated_input(slit_geometry_setup)
                     .with_associated_input(flux_standards)
                     .with_associated_input(atmospheric_extinction)
                     .with_meta_targets([qc1calib, calchecker])
                     .build())

    return response_task


@subworkflow("response", "")
def process_standard_star(raw_std_argus, raw_std_ifu, bias, dark, fibre_flat, wavecal):
    # This subworkflow creates the tasks that process the flux standard star exposures and generate response curves.
    # Two tasks are created, "response_argus" and "response_ifu" by calling the function create_response_task with
    # different input types.

    response_argus = create_response_task(raw_std_argus, "response_argus", bias, dark, fibre_flat, wavecal)
    response_ifu = create_response_task(raw_std_ifu, "response_ifu", bias, dark, fibre_flat, wavecal)

    return response_argus, response_ifu
