from .giraffe_utils import GiraffeSetupInfo
from adari_core.data_libs.master_detmon import MasterDetmonReport
from adari_core.plots.text import TextPlot


class GiraffeDetmonReport(MasterDetmonReport):
    files_needed = {
        "on": "ON_RAW",
        "off": "OFF_RAW",
        "gain_info": "GAIN_INFO",
        "detlin_info": "DET_LIN_INFO",
    }
    center_size = 200

    def __init__(self):
        super().__init__("detmon_detmon", self.files_needed)

    def access_port(self, im_hdu, port):
        return im_hdu

    def generate_panels(self, **kwargs):
        panels = {}

        # Setup for master report
        data_info = {}
        data_info["exptime_key"] = "EXPTIME"
        data_info["gain_nominal_key"] = "HIERARCH ESO DET OUT1 CONAD"
        data_info["lintime_key"] = "EXPTIME"

        new_panels = super().generate_panels(
            data_info=data_info,
            ext=0,
            port=1,
        )

        for panel, panel_descr in new_panels.items():
            # Metadata
            metadata = GiraffeSetupInfo.detmon(list(self.hdus[0].values())[0])
            text2 = TextPlot(v_space=self.METADATA_V_SPACING)
            text2.add_data(metadata)
            panel.assign_plot(text2, 1, 0)

        panels = {**panels, **new_panels}

        return panels


rep = GiraffeDetmonReport()
