from edps import subworkflow, task, qc1calib, ReportInput

from .giraffe_datasources import *
from .giraffe_task_functions import *


@subworkflow("flat", "")
def flats(bias):
    fibre_flat = (task('fibre_flat')
                  .with_recipe('gimasterflat')
                  .with_report('giraffe_rawdisp', ReportInput.RECIPE_INPUTS)
                  .with_report('giraffe_flat', ReportInput.RECIPE_INPUTS_OUTPUTS)
                  .with_main_input(raw_fibre_flat)
                  .with_associated_input(bias, [master_bias_class, bad_pixel_map_class])
                  .with_associated_input(grating_properties)
                  .with_associated_input(slit_geometry_setup)
                  .with_job_processing(set_flat_recipe_parameters)
                  .with_meta_targets([qc1calib])
                  .build())

    nasmyth_flat = (task('nasmyth_flat')
                    .with_recipe('gimasterflat')
                    .with_report('giraffe_rawdisp', ReportInput.RECIPE_INPUTS)
                    .with_report('giraffe_flat', ReportInput.RECIPE_INPUTS_OUTPUTS)
                    .with_main_input(raw_nasmyth_flat)
                    .with_associated_input(bias, [master_bias_class, bad_pixel_map_class])
                    .with_associated_input(grating_properties)
                    .with_associated_input(slit_geometry_setup)
                    .with_job_processing(set_flat_recipe_parameters)
                    .with_meta_targets([qc1calib])
                    .build())

    sky_flat = (task('sky_flat')
                .with_recipe('gimasterflat')
                .with_report('giraffe_rawdisp', ReportInput.RECIPE_INPUTS)
                .with_report('giraffe_flat', ReportInput.RECIPE_INPUTS_OUTPUTS)
                .with_main_input(raw_sky_flat)
                .with_associated_input(bias, [master_bias_class, bad_pixel_map_class])
                .with_associated_input(grating_properties)
                .with_associated_input(slit_geometry_setup)
                .with_job_processing(set_flat_recipe_parameters)
                .with_meta_targets([qc1calib])
                .build())

    return fibre_flat, nasmyth_flat, sky_flat
