from edps import classification_rule

from . import giraffe_keywords as kwd

giraf = {kwd.instrume: "GIRAFFE"}
calib_keywords = {**giraf, kwd.dpr_catg: "CALIB", kwd.pro_catg: None}
calib_image_keywords = {**calib_keywords, kwd.dpr_tech: "IMAGE"}
calib_ifu_keywords = {**calib_keywords, kwd.dpr_tech: "IFU"}
science_keywords = {**giraf, kwd.dpr_catg: "SCIENCE", kwd.pro_catg: None}
acquisition_keywords = {**giraf, kwd.dpr_catg: "ACQUISITION", kwd.pro_catg: None}
# Raw types
simlamp_class = classification_rule(
    "ARC_SPECTRUM", {**calib_keywords, kwd.dpr_type: ["SIMLAMP,TAL", "SIMLAMP,HAL"]})

bias_class = classification_rule("BIAS", {**calib_keywords, kwd.dpr_type: "BIAS"})
dark_class = classification_rule("DARK", {**calib_keywords, kwd.dpr_type: "DARK"})
imaging_flat_off_class = classification_rule(
    "OFF_RAW", {**calib_keywords, kwd.dpr_tech: "IMAGE", kwd.dpr_type: "BIAS,DETCHECK"})
imaging_flat_on_class = classification_rule(
    "ON_RAW",
    {**calib_keywords, kwd.dpr_tech: "IMAGE", kwd.dpr_type: "LAMP,FLAT,DETCHECK"},)

fiber_flat_class = classification_rule(
    "FIBER_FLAT", {**calib_keywords, kwd.dpr_type: ["LAMP,FLAT"]})

nasmyth_flat_class = classification_rule(
    "FIBER_FLAT", {**calib_keywords, kwd.dpr_type: ["LAMP,FLAT,NASMYTH"]})

sky_flat_class = classification_rule(
    "FIBER_FLAT", {**calib_keywords, kwd.dpr_type: ["SKY,OzPoz"]})

arc_spectrum_class = classification_rule(
    "ARC_SPECTRUM", {**calib_keywords, kwd.dpr_type: "LAMP,WAVE"})

std_ifu_class = classification_rule(
    "STD",
    {**calib_keywords, kwd.dpr_type: ["STD,OzPoz", "STD,SimCal"], kwd.ins_mode: "IFU"},)
std_argus_class = classification_rule(
    "STD",
    {**calib_keywords, kwd.dpr_type: ["STD,OzPoz", "STD,SimCal"], kwd.ins_mode: "ARG"},)
science_class = classification_rule(
    "SCIENCE",
    {
        **science_keywords,
        kwd.dpr_type: ["OBJECT,OzPoz", "OBJECT,SimCal"],
        kwd.ins_mode: ["MED", "IFU", "ARG"],
    },
)
acquisition_class = classification_rule(
    "ACQ_FACB", {**acquisition_keywords, kwd.dpr_type: "OBJECT"})

# Static calibrations

grating_properties_class = classification_rule(
    "GRATING_DATA", {**giraf, kwd.pro_catg: "GRATING_DATA"})
line_catalog_class = classification_rule(
    "LINE_CATALOG", {**giraf, kwd.pro_catg: "LINE_CATALOG"})
flux_standards_class = classification_rule(
    "FLUX_STANDARDS", {**giraf, kwd.pro_catg: "FLUX_STANDARDS"})
atmospheric_extinction_class = classification_rule(
    "ATMOSPHERIC_EXTINCTION", {**giraf, kwd.pro_catg: "ATMOSPHERIC_EXTINCTION"})
line_mask_class = classification_rule("LINE_MASK", {**giraf, kwd.pro_catg: "LINE_MASK"})
ref_dispersion_solution_class = classification_rule(
    "REFERENCE_DISP_SOLUTION", {**giraf, kwd.pro_catg: "REFERENCE_DISP_SOLUTION"})
slit_geometry_master_class = classification_rule(
    "SLIT_GEOMETRY_MASTER", {**giraf, kwd.pro_catg: "SLIT_GEOMETRY_MASTER"})

# Master calibrations
# gimasterbias
master_bias_class = classification_rule(
    "MASTER_BIAS", {**giraf, kwd.pro_catg: "MASTER_BIAS"})
bad_pixel_map_class = classification_rule(
    "BAD_PIXEL_MAP", {**giraf, kwd.pro_catg: "BAD_PIXEL_MAP"})

# gimasterdark
master_dark_class = classification_rule(
    "MASTER_DARK", {**giraf, kwd.pro_catg: "MASTER_DARK"})

# gimasterflat
master_fiber_flat_class = classification_rule(
    "MASTER_FIBER_FLAT", {**giraf, kwd.pro_catg: "MASTER_FIBER_FLAT"})
ff_loccentroid_class = classification_rule(
    "FF_LOCCENTROID", {**giraf, kwd.pro_catg: "FF_LOCCENTROID"})
ff_locwidth_class = classification_rule(
    "FF_LOCWIDTH", {**giraf, kwd.pro_catg: "FF_LOCWIDTH"})
ff_locfit_class = classification_rule("FF_LOCFIT", {**giraf, kwd.pro_catg: "FF_LOCFIT"})
ff_psfcentroid_class = classification_rule(
    "FF_PSFCENTROID", {**giraf, kwd.pro_catg: "FF_PSFCENTROID"})
ff_psfwidth_class = classification_rule(
    "FF_PSFWIDTH", {**giraf, kwd.pro_catg: "FF_PSFWIDTH"})
ff_psffit_class = classification_rule("FF_PSFFIT", {**giraf, kwd.pro_catg: "FF_PSFFIT"})
fiber_profile_class = classification_rule(
    "FIBER_PROFILE", {**giraf, kwd.pro_catg: "FIBER_PROFILE"})
scattered_light_model_class = classification_rule(
    "SCATTERED_LIGHT_MODEL", {**giraf, kwd.pro_catg: "SCATTERED_LIGHT_MODEL"})
ff_extspectra_class = classification_rule(
    "FF_EXTSPECTRA", {**giraf, kwd.pro_catg: "FF_EXTSPECTRA"})
ff_exterrors_class = classification_rule(
    "FF_EXTERRORS", {**giraf, kwd.pro_catg: "FF_EXTERRORS"})
ff_extpixels_class = classification_rule(
    "FF_EXTPIXELS", {**giraf, kwd.pro_catg: "FF_EXTPIXELS"})
ff_exttraces_class = classification_rule(
    "FF_EXTTRACES", {**giraf, kwd.pro_catg: "FF_EXTTRACES"})
ff_extmodel_class = classification_rule(
    "FF_EXTMODEL", {**giraf, kwd.pro_catg: "FF_EXTMODEL"})

nf_extspectra_class = classification_rule(
    "NF_EXTSPECTRA", {**giraf, kwd.pro_catg: "NF_EXTSPECTRA"})
nf_exterrors_class = classification_rule(
    "NF_EXTERRORS", {**giraf, kwd.pro_catg: "NF_EXTERRORS"})
nf_loccentroid_class = classification_rule(
    "NF_LOCCENTROID", {**giraf, kwd.pro_catg: "NF_LOCCENTROID"})
nf_locwidth_class = classification_rule(
    "NF_LOCWIDTH", {**giraf, kwd.pro_catg: "NF_LOCWIDTH"})

# giwavecalibration
dispersion_solution_class = classification_rule(
    "DISPERSION_SOLUTION", {**giraf, kwd.pro_catg: "DISPERSION_SOLUTION"})
line_data_class = classification_rule("LINE_DATA", {**giraf, kwd.pro_catg: "LINE_DATA"})
slit_geometry_mask_class = classification_rule(
    "SLIT_GEOMETRY_MASK", {**giraf, kwd.pro_catg: "SLIT_GEOMETRY_MASK"})
slit_geometry_setup_class = classification_rule(
    "SLIT_GEOMETRY_SETUP", {**giraf, kwd.pro_catg: "SLIT_GEOMETRY_SETUP"})
reference_stab_class = classification_rule(
    "REFERENCE_STAB", {**giraf, kwd.pro_catg: "REFERENCE_STAB"})

# Standard stars
INSTRUMENT_RESPONSE_ifu = classification_rule(
    "INSTRUMENT_RESPONSE",
    {**giraf, kwd.pro_catg: "INSTRUMENT_RESPONSE", kwd.ins_mode: "IFU"},)
STD_RBNSPECTRA_ifu = classification_rule(
    "STD_RBNSPECTRA", {**giraf, kwd.pro_catg: "STD_RBNSPECTRA", kwd.ins_mode: "IFU"})
STD_RCSPECTRA_ifu = classification_rule(
    "STD_RCSPECTRA", {**giraf, kwd.pro_catg: "STD_RCSPECTRA", kwd.ins_mode: "IFU"})
STD_RBNSPECTRA_argus = classification_rule(
    "STD_RBNSPECTRA", {**giraf, kwd.pro_catg: "STD_RBNSPECTRA", kwd.ins_mode: "ARG"})
STD_RCSPECTRA_argus = classification_rule(
    "STD_RCSPECTRA", {**giraf, kwd.pro_catg: "STD_RCSPECTRA", kwd.ins_mode: "ARG"})

# Processed science
SCIENCE_RBNSPEC_IDP = classification_rule(
    "SCIENCE_RBNSPEC_IDP", {**giraf, kwd.pro_catg: "SCIENCE_RBNSPEC_IDP"})
SPECTRUM_1D = classification_rule("SPECTRUM_1D", {**giraf, kwd.pro_catg: "SPECTRUM_1D"})
