from edps import data_source
from edps.generator.time_range import *

from . import giraffe_rules as rules
from .giraffe_classification import *

# Convention for Data sources Association rule levels:
# Each data source can have several match function which correspond to different
# quality levels for the selected data. The level is specified as a number that
# follows this convention:
#   level < 0: more restrictive than the calibration plan
#   level = 0 follows the calibration plan
#   level = 1 quality sufficient for QC1 certification
#   level = 2 probably still acceptable quality
#   level = 3 significant risk of bad quality results

slit = [kwd.ins_slit_name, kwd.ins_exp_mode]
setup = slit + [kwd.det_read_speed]
group_basic = [kwd.instrume, kwd.tpl_start]
group_bias = group_basic + [kwd.det_read_speed]
group_flat = group_basic + setup
group_arc = group_flat

match_bias = [kwd.instrume, kwd.det_read_speed]
# setup = slit + [kwd.instrume, kwd.ins_mode]

polar_keywords = [kwd.ins_polar_mode, kwd.ft_polar_mode]
group_dark = [kwd.tpl_start, kwd.det_read_speed]
match_dark = match_bias

# Raw types
# ---------------- DATA SOURCES (with recipe none)-----------------
raw_simlamp = (data_source()
               .with_classification_rule(simlamp_class)
               .with_grouping_keywords([kwd.arcfile])
               .with_setup_keywords(setup)
               .build())

# ---------------- DATA SOURCES -----------------

raw_bias = (data_source()
            .with_classification_rule(bias_class)
            .with_grouping_keywords(group_bias)
            .with_min_group_size(3)
            .with_setup_keywords([kwd.det_read_speed])
            .with_match_keywords(match_bias, time_range=RelativeTimeRange(-2.5, 2.5), level=0)
            .with_match_keywords(match_bias, time_range=TWO_WEEKS, level=1)
            .with_match_keywords(match_bias, time_range=UNLIMITED, level=3)
            .build())

raw_dark = (data_source()
            .with_classification_rule(dark_class)
            .with_grouping_keywords(group_dark)
            .with_setup_keywords([kwd.det_read_speed])
            .with_match_keywords(match_dark, time_range=ONE_DAY, level=0)
            .with_match_keywords(match_dark, time_range=TWO_WEEKS, level=1)
            .with_match_keywords(match_dark, time_range=UNLIMITED, level=3)
            .build())

raw_detlin = (data_source()
              .with_classification_rule(imaging_flat_off_class)
              .with_classification_rule(imaging_flat_on_class)
              .with_min_group_size(3)
              .with_grouping_keywords(group_bias)
              .with_setup_keywords([kwd.det_read_speed])
              .with_match_keywords(group_bias, time_range=ONE_DAY, level=0)
              .with_match_keywords(group_bias, time_range=TWO_WEEKS, level=1)
              .with_match_keywords(group_bias, time_range=UNLIMITED, level=3)
              .build())

raw_fibre_flat = (data_source("FIBRE_FLAT")
                  .with_classification_rule(fiber_flat_class)
                  .with_grouping_keywords(group_flat)
                  .with_setup_keywords(setup)
                  .with_match_keywords(setup, time_range=ONE_DAY, level=0)
                  .with_match_keywords(setup, time_range=TWO_WEEKS, level=1)
                  .with_match_keywords(setup, time_range=UNLIMITED, level=3)
                  .build())

raw_nasmyth_flat = (data_source("NASMYTH_FLAT")
                    .with_classification_rule(nasmyth_flat_class)
                    .with_grouping_keywords(group_flat)
                    .with_setup_keywords(setup)
                    .with_match_keywords(setup, time_range=THREE_DAYS, level=0)
                    .with_match_keywords(setup, time_range=TWO_WEEKS, level=1)
                    .with_match_keywords(setup, time_range=UNLIMITED, level=3)
                    .build())

raw_sky_flat = (data_source("SKY_FLAT")
                .with_classification_rule(sky_flat_class)
                .with_min_group_size(3)
                .with_grouping_keywords(group_flat)
                .with_setup_keywords(setup)
                .build())

raw_arc_spectrum = (data_source()
                    .with_classification_rule(arc_spectrum_class)
                    .with_setup_keywords(setup)
                    .with_grouping_keywords([kwd.arcfile])
                    .with_match_keywords(setup, time_range=RelativeTimeRange(0, 1), level=0)
                    .with_match_keywords(setup, time_range=ONE_DAY, level=1)
                    .with_match_keywords(setup, time_range=TWO_WEEKS, level=2)
                    .with_match_keywords(setup, time_range=UNLIMITED, level=3)
                    .build())

raw_std_ifu = (data_source()
               .with_classification_rule(std_ifu_class)
               .with_grouping_keywords([kwd.arcfile])
               .with_setup_keywords(setup)
               .with_match_function(rules.associate_flux_standard, time_range=RelativeTimeRange(-3, 3), level=0)
               .with_match_function(rules.associate_flux_standard, time_range=TWO_WEEKS, level=1)
               .with_match_function(rules.associate_flux_standard, time_range=UNLIMITED, level=3)
               .build())

raw_std_argus = (data_source()
                 .with_classification_rule(std_argus_class)
                 .with_grouping_keywords([kwd.arcfile])
                 .with_setup_keywords(setup)
                 #  .with_match_keywords(setup, time_range=RelativeTimeRange(-3,3), level=0)
                 #  .with_match_keywords(setup, time_range=TWO_WEEKS, level=1)
                 #  .with_match_keywords(setup, time_range=UNLIMITED, level=3)
                 .with_match_function(rules.associate_flux_standard, time_range=RelativeTimeRange(-3, 3), level=0)
                 .with_match_function(rules.associate_flux_standard, time_range=TWO_WEEKS, level=1)
                 .with_match_function(rules.associate_flux_standard, time_range=UNLIMITED, level=3)
                 .build())

# science files are combined by "night", "tpl.start" or "arcfile" (default), depending on what specified
# in the parameter "$combine_science" in the parameter file
raw_science = (data_source('OBJECT')
               .with_classification_rule(science_class)
               .with_grouping_keywords([kwd.dpr_tech, kwd.ins_filt_name, kwd.obs_targ_name, kwd.ins_obsplate,
                                        "$combine_science"])
               .with_setup_keywords(setup)
               .build())

# Acquisition images are associated to science tasks to be delivered by CalSelector, but not used in the reduction.
raw_acquisition = (data_source("ACQUISITION")
                   .with_classification_rule(acquisition_class)
                   .with_grouping_keywords([kwd.arcfile])
                   .with_setup_keywords(setup)
                   .with_match_keywords([kwd.obs_id])
                   .build())

# Datasources for static calibrations
line_mask = (data_source()
             .with_classification_rule(line_mask_class)
             .with_match_keywords([kwd.ins_exp_mode], time_range=IN_THE_PAST, level=0)
             .with_match_keywords([kwd.ins_exp_mode], time_range=UNLIMITED, level=2)
             .build())

atmospheric_extinction = (data_source()
                          .with_classification_rule(atmospheric_extinction_class)
                          .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                          .build())

flux_standards = (data_source()
                  .with_classification_rule(flux_standards_class)
                  .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                  .build())

line_catalog = (data_source()
                .with_classification_rule(line_catalog_class)
                .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=1)
                .build())

ref_dispersion_solution = (data_source()
                           .with_classification_rule(ref_dispersion_solution_class)
                           .with_match_function(rules.associate_disp_solution, time_range=IN_THE_PAST, level=0)
                           .with_match_function(rules.associate_disp_solution, time_range=UNLIMITED, level=1)
                           .build())

grating_properties = (data_source()
                      .with_classification_rule(grating_properties_class)
                      .with_match_keywords([kwd.ins_grat_name, kwd.instrume], time_range=IN_THE_PAST, level=0)
                      .with_match_keywords([kwd.ins_grat_name, kwd.instrume], time_range=UNLIMITED, level=1)
                      .build())

slit_geometry_setup = (data_source()
                       .with_classification_rule(slit_geometry_setup_class)
                       .with_match_function(rules.associate_slit_setup, time_range=IN_THE_PAST, level=0)
                       .with_match_function(rules.associate_slit_setup, time_range=UNLIMITED, level=1)
                       .build())

slit_geometry_master = (data_source()
                        .with_classification_rule(slit_geometry_master_class)
                        .with_match_function(rules.associate_slit_setup, time_range=IN_THE_PAST, level=0)
                        .with_match_function(rules.associate_slit_setup, time_range=UNLIMITED, level=1)
                        .build())

bad_pixel_map = (data_source()
                 .with_classification_rule(bad_pixel_map_class)
                 .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                 .build())
