/* $Id: gravi_utils.h,v 1.12 2011/05/31 06:10:40 nazouaoui Exp $
 *
 * This file is part of the GRAVI Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*-----------------------------------------------------------------------------
 * History :
 *            11/01/2019 : Global parameter to gravi_calib.c
 -----------------------------------------------------------------------------*/
#ifndef GRAVI_CALIB_H_
#define GRAVI_CALIB_H_


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "gravi_data.h"

/*-----------------------------------------------------------------------------
                                   Defines
 ----------------------------------------------------------------------------*/

#define BADPIX_DARK		(1 << 0)
#define BADPIX_RMS		(1 << 1)
#define BADPIX_FLAT		(1 << 2)
#define BADPIX_PROFILE_LIMIT		0.05  //level on the profile to flag flat bad pix into the badpix

/*-----------------------------------------------------------------------------
                                 Public prototypes
 -----------------------------------------------------------------------------*/

gravi_data * gravi_compute_dark (gravi_data * );
gravi_data * gravi_average_dark (gravi_data ** data, cpl_size ndata);

gravi_data * gravi_compute_profile (gravi_data ** , gravi_data * , gravi_data * ,
									int , const cpl_parameterlist * );

cpl_propertylist * gravi_compute_gain (gravi_data ** flats_data,
                                       int nrawgain, gravi_data * dark_map);

gravi_data * gravi_compute_badpix (gravi_data * ,
                                   gravi_data ** flats_data,
                                   int nflat,
                                   const cpl_parameterlist * );

gravi_data * gravi_compute_biasmask (gravi_data * dark_map,
                                     gravi_data ** flats_data,
                                     int nflat,
                                     const cpl_parameterlist * params);

gravi_data * gravi_compute_piezotf (gravi_data * data,
                                    const cpl_parameterlist * params);

cpl_error_code gravi_remove_cosmicrays_sc (cpl_imagelist * imglist_sc);

gravi_data * gravi_compute_pca(gravi_data ** data,
                               int naccept,
                               const cpl_parameterlist * params);

cpl_error_code gravi_flatten_vis (gravi_data * vis_data,
                                  gravi_data * calib_data);

/* ekw 11/01/2019 : Move to gravi_calib.c
static double met_Sep_2016[64] =    {-0.000338233    ,-0.000282107    ,0.000345582    ,0.000381979    ,0.000326764    ,-0.000225664    ,5.35555e-05    ,0.00060938    ,-0.000205619    ,-0.000265577    ,0.00017356    ,0.000265687    ,0.000295987    ,3.05255e-05    ,-0.000498407    ,0.000232075    ,0.00502058    ,0.002045925    ,-0.000110657    ,-0.000403592    ,-0.000065043    ,-0.000433645    ,-0.000626545    ,3.29765e-05    ,-0.001694525    ,-0.0011684    ,6.2795e-06    ,-0.001584115    ,-0.000735553    ,-0.000868538    ,-0.000985087    ,-0.0008204    ,0.000768577    ,0.000848342    ,-0.000134943    ,-0.000385157    ,-8.68822e-05    ,-0.000757366    ,0.000446051    ,-0.000231723    ,0.000790425    ,-0.000638897    ,0.000503496    ,-7.78205e-05    ,0.000287366    ,0.000243789    ,0.000083288    ,-0.000125138    ,-0.000147337    ,4.14224e-05    ,0.000123082    ,-0.00117179    ,4.54785e-05    ,-0.000186707    ,0.000682836    ,0.00090649    ,0.000357256    ,-0.002133845    ,-0.00151895    ,-0.00150048    ,-0.00266423    ,-0.0030716    ,0.000599228    ,-0.001078583};
static double met_Mar_2017[64] =    {0.000481474    ,0.000678173    ,0.00022232    ,9.04735e-05    ,0.001030283    ,0.000400478    ,0.000199579    ,0.000610902    ,0.000870061    ,0.001148845    ,0.000706636    ,0.000491999    ,0.00093158    ,0.001224225    ,0.000652115    ,0.001117025    ,0.00481452    ,0.002359475    ,0.000641491    ,0.000126103    ,0.000158341    ,0.001455785    ,0.000227113    ,0.000366087    ,-0.000372672    ,-0.000814455    ,0.000403834    ,-0.00072791    ,-0.000422227    ,0.000413887    ,-0.000024651    ,0.000106683    ,0.00092596    ,0.000327427    ,0.000775269    ,0.000906505    ,0.000108337    ,-0.000214467    ,0.001249965    ,0.000694693    ,0.000718101    ,0.00083926    ,0.00138818    ,0.00131215    ,0.001113065    ,0.00134113    ,0.000972572    ,0.00073247    ,-3.35943e-05    ,0.000312545    ,0.000365923    ,0.000510906    ,0.000955084    ,0.000808904    ,0.000403238    ,-0.000150186    ,0.000200673    ,-0.00078668    ,-0.00078133    ,-0.00039955    ,-0.00226333    ,-0.00177287    ,0.000435995    ,-0.000397403};
static double met_Jun_2017[64] =    {0.00029923    ,5.42185e-05    ,-0.000023823    ,0.000187444    ,0.000650675    ,0.000135629    ,-0.000047364    ,0.000479489    ,0.000463565    ,0.000536066    ,0.000528847    ,0.000874895    ,0.000702853    ,0.000438988    ,0.000183642    ,0.000536044    ,0.004829985    ,0.00215068    ,5.94134e-05    ,-0.000164468    ,-4.89301e-05    ,0.000400028    ,-0.000277333    ,-0.000169422    ,-0.00136967    ,-0.000998661    ,0.000244959    ,-0.00123726    ,-0.000404182    ,-0.000511517    ,-0.000398515    ,-0.000314167    ,0.000546602    ,0.000547136    ,0.000388259    ,0.000108443    ,-0.000266431    ,-0.000734324    ,0.000946866    ,0.0001005    ,0.000739434    ,0.000530113    ,0.000821013    ,0.000748435    ,0.00094666    ,0.00102861    ,-0.00013052    ,0.000576223    ,-0.000657692    ,-0.000293389    ,0.000146337    ,-0.000338176    ,0.000241386    ,0.00005168    ,0.000495891    ,-1.76273e-05    ,8.84135e-05    ,-0.00153857    ,-0.000850848    ,-0.000986058    ,-0.002700175    ,-0.002620785    ,0.000440797    ,-0.00063843};
static double met_Jul_2017[64] =    {8.19405e-05    ,-0.000061716    ,0.000067827    ,0.000234624    ,0.000521161    ,0.000031451    ,0.000211139    ,0.000578157    ,0.000316435    ,0.000431433    ,0.000431228    ,0.000761259    ,0.000576742    ,0.000299923    ,0.00034315    ,0.000561323    ,0.004834095    ,0.00208259    ,-0.000155192    ,-0.000120373    ,-0.000328756    ,0.000265791    ,-0.000249398    ,-0.000310416    ,-0.001047503    ,-0.000884526    ,0.000431645    ,-0.000890023    ,-0.000330709    ,-0.000540866    ,-0.0002067    ,-0.000334498    ,0.00035945    ,0.000683828    ,0.000464533    ,0.000166613    ,-0.000276387    ,-0.00088093    ,0.001283446    ,0.00016521    ,0.000578248    ,0.000334565    ,0.000762716    ,0.000521964    ,0.000757276    ,0.000959739    ,0.000035001    ,0.000442429    ,-0.0006928    ,-0.000105863    ,-0.00006137    ,-0.000454825    ,-0.000157343    ,-5.68635e-05    ,0.000296553    ,-3.80711e-05    ,0.000384616    ,-0.00149983    ,-0.000650183    ,-0.00076473    ,-0.002494945    ,-0.00246317    ,0.000794264    ,-0.000337915};
static double met_Aug_2017[64] =    {0.000225917    ,0.00033629    ,1.70956e-05    ,0.000178987    ,0.00103744    ,0.000275415    ,0.000107582    ,0.000678724    ,0.000402821    ,0.000713535    ,0.000518528    ,0.000607008    ,0.000506748    ,0.000640514    ,0.000300349    ,0.000522693    ,0.005585285    ,0.00305222    ,0.000771553    ,0.001006485    ,0.000618719    ,0.00130769    ,0.000419028    ,0.000491215    ,-0.000815277    ,-0.000646205    ,0.000640702    ,-0.000881775    ,-0.000200994    ,-0.000258582    ,-0.000465663    ,-0.00004838    ,0.000591627    ,0.000615608    ,0.000197913    ,0.000352664    ,-0.000113565    ,-0.000637229    ,0.001241975    ,-6.659e-06    ,0.000649339    ,0.000641595    ,0.000673658    ,0.000657426    ,0.001263897    ,0.001258565    ,0.000050901    ,0.000318844    ,-9.23866e-05    ,0.00065074    ,0.000793493    ,0.000600095    ,0.001049984    ,0.000858337    ,0.000786737    ,0.000737051    ,0.000576774    ,-0.001384295    ,-0.000642989    ,-0.0008569    ,-0.00208747    ,-0.00247888    ,0.00108834    ,-0.000190064};
*/

#endif /* GRAVI_PREPROC_H_ */
