/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2015-06-12 15:13:41 $
 * $Revision:     $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_BEPOP_H
#define ESPDR_BEPOP_H

/* BEPOP functions*/
#include <bepop.h>
#include <espdr_msg.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_compute_BERV(
                    double ra,
                    double dec,
                    double pm_ra,
                    double pm_dec,
                    int year,
                    int month,
                    int day,
                    int hour,
                    int minutes,
                    double seconds,
                    double TimeToMidExposure,
                    double longitude,
                    double latitude,
                    double altitude,
                    int typeInit,
                    double *BERV_RE,
                    double *VTOT_RE,
                    double *BJD_RE,
                    double *BERVMAX_RE,
                    double *SED_RE);

cpl_error_code espdr_compute_BERV_factor(double berv,
                                         double sed,
                                         double vtot,
                                         double *berv_factor);

#endif /* ESPDR_BEPOP_H */


