/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_ORDERS_H
#define ESPDR_ORDERS_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dark.h>
#include <espdr_overscan.h>
#include <espdr_bias.h>
#include <espdr_fit.h>
#include <espdr_cte.h>
#include <espdr_detector_signature.h>

/* extraction tests */
//#include <espdr_wave_cal.h>
#include <espdr_extraction.h>
/* end extraction tests */

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
#define SAVE_DEBUG_PRODUCT_ORDERDEF 0
#define SAVE_ORDERS_MASK 0

/*----------------------------------------------------------------------------
 Data structures
 ----------------------------------------------------------------------------*/

typedef struct {
	int min_x;
	int max_x;
	int min_y;
	int max_y;
	int width_OK;
    int pixels_width_OK;
	int order_nr;
} espdr_clump_limit;

typedef struct {
	//double flux;
	//int y_pos;
	int width;
	int first_y;
	int last_y;
	//int order_nr;
	double centroid;
	double sig_centroid;
} espdr_bissector;

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_orderdef(cpl_parameterlist *parameters, cpl_frameset *frameset,
		const char* recipe_id);
cpl_error_code espdr_parameters_ORDERDEF_create(
        const char* recipe_id,
		cpl_parameterlist *list,
		espdr_ORDERDEF_param *p);

cpl_error_code espdr_parameters_ORDERDEF_delete(
        espdr_ORDERDEF_param* p);

espdr_ORDERDEF_param* espdr_ORDERDEF_param_init(
        const char* recipe_id,
        cpl_parameterlist* param_list);

cpl_error_code espdr_parameters_ORDERDEF_get(
        const char* recipe_id,
        cpl_parameterlist* list,
        espdr_ORDERDEF_param *ORDERDEF_param);

cpl_error_code espdr_parameters_ORDERDEF_print(
        espdr_ORDERDEF_param *ORDERDEF_param);

cpl_error_code espdr_orderdef_process_inputs(
        cpl_frameset *frameset,
        cpl_frameset **used_frames,
        espdr_CCD_geometry *CCD_geom,
        espdr_inst_config *inst_config,
        espdr_qc_keywords *qc_kws,
        double **RON,
        double **CONAD,
        cpl_frame **orderdef_frame,
        cpl_propertylist **keywords,
        cpl_propertylist ***keywords_ext,
        cpl_imagelist *geometry_corrected_pixels_mask,
        cpl_imagelist **geometry_corrected_saturation_mask,
        cpl_imagelist **CCD_corrected_orderdef);

cpl_error_code espdr_detect_orders(
        const cpl_imagelist *input_iml,
        const cpl_imagelist *total_mask_iml,
        cpl_imagelist *background_map,
        const espdr_CCD_geometry *CCD_geom,
        espdr_inst_config *inst_config,
        const int fibre_nr,
        cpl_imagelist *orders_map_RE);

cpl_error_code espdr_identify_orders(
        const double *data_table,
        const int *mask_table,
        double *background_data,
        const int nx,
        const int ny,
        const int fibre_nr,
        const int ext_nr,
        const espdr_CCD_geometry *CCD_geom,
        espdr_inst_config *inst_config,
        const double background_level,
        const int cluster_distance_x,
        const int cluster_distance_y,
        int *orders_data);

cpl_error_code espdr_identify_clump(
        int *orders_data,
		int nx,
		int ny,
		int pixel,
		int counter_flag,
		int cluster_distance_x,
		int cluster_distance_y);

cpl_error_code espdr_number_valid_orders(
        cpl_imagelist *orders_data_imagelist,
		cpl_imagelist *orders_map_imagelist,
		espdr_inst_config *inst_config,
		int min_order_len,
        int min_order_x,
        int max_order_y,
		int *orders_nr_RE,
		cpl_imagelist *orders_numbered_RE);

cpl_error_code espdr_number_valid_orders_one_image(
        double *orders_data,
		int *orders_map,
		int nx, int ny,
		espdr_inst_config *inst_config,
		int min_order_len,
        int min_order_x,
        int max_order_y,
		int *order_nr_RE,
		int *orders_RE);

cpl_error_code espdr_find_clumps_limits(
        int *orders_data,
		int nx, int ny,
		int order_width_limit,
		espdr_clump_limit *clump_RE);

cpl_error_code espdr_fit_orders(
        cpl_imagelist *data_imagelist,
		cpl_imagelist *orders_map_imagelist,
		cpl_imagelist *total_mask_iml,
		int fibre_nr,
		int *orders_nr,
		double *RON,
		double *CONAD,
		espdr_CCD_geometry *CCD_geom,
		espdr_inst_config *inst_config,
		double **orders_pos_RE,
		cpl_table **coeffs_table_RE,
		double **order_res_stdev_RE,
		double **order_res_min_RE,
		double **order_res_max_RE);

cpl_error_code espdr_compute_bissector_one_image(
        double *orders_data,
		int *orders_map,
		int *mask,
		int nx, int ny,
		int order_fit_step,
		int order_start,
		int order_end,
		int orders_nr,
		int n_gauss,
		int ext_nr,
		double *RON,
		double *CONAD,
		espdr_CCD_geometry *CCD_geom,
		espdr_inst_config *inst_config,
		double *orders_pos_RE,
		espdr_bissector **bissector_RE);

cpl_error_code espdr_fit_orders_polynomial(
        espdr_bissector **bissector,
		int nx,
        char *instrument,
        int fibre_nr,
        int det_nr,
		int order_start,
		int order_end,
		int orders_nr,
		int order_fit_step,
		cpl_size poly_deg,
		double ksigma,
		cpl_table **coeffs_table,
		double *order_res_stdev,
		double *order_res_min_RE,
		double *order_res_max_RE);

cpl_error_code espdr_create_coeffs_table(
        cpl_table *coeffs_table,
		int poly_deg);

cpl_error_code espdr_compute_residuals(
        espdr_poly_data *p_data,
		double *fit, int length,
		double *residuals_RE);

cpl_error_code espdr_get_order_phys_numbers(
        espdr_CCD_geometry *CCD_geom,
		espdr_inst_config *inst_config,
		int fibre_nr,
		int *orders_phys_nb);

cpl_error_code espdr_draw_orders(
        cpl_image *orders_table,
		int orders_nb,
		int order_start,
		int order_end,
		int poly_deg,
		int CCD_size_y,
		cpl_table *coeffs);

cpl_error_code espdr_save_orderdef_debug_product(
        cpl_frameset *frameset,
        cpl_parameterlist *parameters,
        espdr_inst_config *inst_config,
        espdr_CCD_geometry *CCD_geom,
        espdr_qc_keywords *qc_kws,
        cpl_propertylist *keywords,
        cpl_propertylist **keywords_ext,
        char *filename,
        char *pro_catg,
        cpl_imagelist *iml_to_save,
        int fiber_nr);

cpl_error_code espdr_save_orderdef_bkgr_div(
        cpl_imagelist *CCD_corr_img,
        cpl_imagelist *bkgr_img,
        cpl_propertylist *keywords,
        espdr_inst_config *inst_config,
        int number_of_ext,
        int fibre_nr);

cpl_error_code espdr_save_orderdef_simple_debug_product(
        cpl_imagelist *iml_to_save,
        char *filename,
        cpl_propertylist *keywords,
        espdr_inst_config *inst_config,
        int number_of_ext,
        int fibre_nr);

cpl_error_code espdr_orderdef_QC(
        espdr_CCD_geometry *CCD_geom,
		espdr_qc_keywords *qc_kws,
		espdr_inst_config *inst_config,
		int fibre_nr,
		int *orders_nb,
		double **orders_pos,
		double **order_res_stdev,
		double **order_res_min,
		double **order_res_max,
		int **orders_phys_nb,
		cpl_propertylist **keywords_RE);


#endif /* ESPDR_ORDERS_H */
