/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_OVERSCAN_H
#define ESPDR_OVERSCAN_H

/*----------------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------------*/

/* Utility fonctions */
#include <math.h>

/* DRL functions*/
#include <espdr_sigma_clipping.h>
#include <espdr_dfs.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_instrument.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_keywords.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

/* AMO added to simplify */
cpl_error_code espdr_OVSC_init(espdr_OVSC_param *OVSC_param);

cpl_error_code espdr_parameters_OVSC_create(const char* recipe_id,
                                            cpl_parameterlist *list,
                                            espdr_OVSC_param *p);

espdr_OVSC_param* espdr_parameters_OVSC_init(const char* recipe_id,
                                             cpl_parameterlist* param_list);

cpl_error_code espdr_parameters_OVSC_delete(espdr_OVSC_param* p);

cpl_error_code espdr_parameters_OVSC_get(const char* recipe_id,
                                         cpl_parameterlist* list,
                                         espdr_OVSC_param *OVSC_param);

cpl_error_code espdr_parameters_OVSC_print(espdr_OVSC_param *OVSC_param);

cpl_error_code espdr_overscan_prepare(const cpl_imagelist *master_bias_imagelist,
                                      const espdr_CCD_geometry *CCD_geom,
                                      espdr_qc_keywords *qc_kws,
                                      espdr_inst_config *inst_config,
                                      const int treated_frames_nb,
                                      cpl_imagelist **overscan_imagelist_RE,
                                      cpl_propertylist **keywords_RE,
                                      double *RON_vector_OV_RE,
                                      const int use_hdrl);

cpl_error_code espdr_overscan(const cpl_image *masterBiasTable,
                              const int ext_no,
                              const int out_x,
                              const int out_y,
                              const espdr_CCD_geometry *CCD_geom,
                              const espdr_inst_config *inst_config,
                              cpl_image **overscanTable_RE,
                              double *RON_RE,
                              int *total_cosmics_RE);

cpl_error_code espdr_remove_overscan(const cpl_image *input_image,
                                     const int ext_no,
                                     const int out_x,
                                     const int out_y,
                                     const espdr_CCD_geometry *CCD_geom,
                                     cpl_image *overscan_image,
                                     cpl_image **corrected_image_RE);


	
#endif /* ESPDR_OVERSCAN_H */
