/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: clovis $
 * $Date: 2015-11-10 14:48:13 $
 * $Revision: 1.16 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_CCF_H
#define ESPDR_CCF_H

/*---------------------------------------------------------------------------*/
/**
 * ccf
 *
 * ccf functions header
 */


/*----------------------------------------------------------------------------
                                Includes
 ----------------------------------------------------------------------------*/

/* Utility fonctions */
#include <math.h>

/* DRL functions*/
#include <espdr_overscan.h>
#include <espdr_sigma_clipping.h>
#include <espdr_dfs.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_instrument.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_keywords.h>
#include <gsl/gsl_statistics_double.h>
#include <espdr_fit.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
								Constants
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------------*/

#define CCF_length 100
//#define RV_range 40
//#define RV_step 0.25

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_compute_CCF(cpl_image *ll,
                                 cpl_image *dll,
                                 cpl_image *flux,
                                 cpl_image *error,
                                 cpl_image *blaze,
                                 cpl_image *quality,
                                 cpl_array *RV_table,
                                 cpl_table *mask,
                                 double mask_width,
                                 double berv,
                                 double bervmax,
                                 cpl_image **CCF_flux_RE,
                                 cpl_image **CCF_error_RE,
                                 cpl_image **CCF_quality_RE);

cpl_error_code espdr_fit_ccf(cpl_array *RV_table,
                             int fibres_processed,
                             cpl_image *CCF_flux,
                             cpl_image *CCF_error,
                             cpl_image *CCF_quality,
                             double *asym_RE,
                             double *asym_err_RE,
                             double *bispan_RE,
                             double *bispan_err_RE,
                             cpl_table **residuals_RE,
                             espdr_ngauss_result *g_res_RE);

#endif /* espdr_CCF_H */
