/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_EXTRACTION_H
#define ESPDR_EXTRACTION_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dark.h>
#include <espdr_overscan.h>
#include <espdr_bias.h>
#include <espdr_fit.h>
#include <espdr_led_flat.h>
#include <espdr_detector_signature.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Data structures
 ----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_simple_extraction(cpl_imagelist *input_images,
                                       cpl_imagelist *hot_bad_pixels_mask,
                                       cpl_imagelist *saturation_mask,
                                       cpl_mask **crh_mask,
                                       cpl_imagelist *background,
                                       cpl_imagelist *master_dark,
                                       cpl_imagelist *master_dark_pxl_nb,
                                       cpl_table ***orders_coeffs,
                                       espdr_inst_config *inst_config,
                                       espdr_CCD_geometry *CCD_geom,
                                       double *RON,
                                       double *DARK,
                                       double *DARK_RON,
                                       double *GAIN,
                                       double Texp,
                                       double Texp_master_dark,
                                       int *extraction_window_size,
                                       cpl_image **extr_spectr_RE,
                                       cpl_image **spectr_error_RE,
                                       cpl_image **spectr_qual_RE);

cpl_error_code espdr_simple_extraction_one_fibre(cpl_imagelist *input_images,
                                                 cpl_imagelist *hot_bad_pixels_mask,
                                                 cpl_imagelist *saturation_mask,
                                                 cpl_mask **crh_mask,
                                                 cpl_imagelist *background,
                                                 cpl_imagelist *master_dark,
                                                 cpl_imagelist *master_dark_pxl_nb,
                                                 cpl_table **orders_coeffs,
                                                 int fibre_nr,
                                                 espdr_inst_config *inst_config,
                                                 espdr_CCD_geometry *CCD_geom,
                                                 double *RON,
                                                 double *DARK,
                                                 double *DARK_RON,
                                                 double *GAIN,
                                                 double Texp,
                                                 double Texp_master_dark,
                                                 int extraction_window_size,
                                                 cpl_image **extr_spectr_RE,
                                                 cpl_image **spectr_error_RE,
                                                 cpl_image **spectr_qual_RE);


cpl_error_code espdr_horne_extraction(cpl_imagelist *input_images,
                                      cpl_imagelist *hot_bad_pixels_mask,
                                      cpl_imagelist *saturation_mask,
                                      cpl_mask **crh_mask,
                                      cpl_imagelist *background,
                                      cpl_imagelist **order_profile,
                                      cpl_imagelist *contam,
                                      cpl_imagelist *master_dark,
                                      cpl_imagelist *master_dark_pxl_nb,
                                      cpl_table ***orders_coeffs,
                                      espdr_inst_config *inst_config,
                                      espdr_CCD_geometry *CCD_geom,
                                      double *RON,
                                      double *DARK,
                                      double *DARK_RON,
                                      double *GAIN,
                                      double Texp,
                                      double Texp_master_dark,
                                      int *extraction_window_size,
                                      double tolerance_reject,
                                      double ksig_extraction,
                                      int **cosmics_nb_RE,
                                      cpl_image **extr_spectr_RE,
                                      cpl_image **spectr_error_RE,
                                      cpl_image **spectr_qual_RE);

cpl_error_code espdr_horne_extraction_one_fibre(cpl_imagelist *input_images,
                                                cpl_imagelist *hot_bad_pixels_mask,
                                                cpl_imagelist *saturation_mask,
                                                cpl_mask **crh_mask_whole,
                                                cpl_imagelist *background,
                                                cpl_imagelist *order_profile,
                                                cpl_imagelist *contam,
                                                cpl_imagelist *master_dark,
                                                cpl_imagelist *master_dark_pxl_nb,
                                                cpl_table **orders_coeffs,
                                                int fibre_nr,
                                                espdr_inst_config *inst_config,
                                                espdr_CCD_geometry *CCD_geom,
                                                double *RON,
                                                double *DARK,
                                                double *DARK_RON,
                                                double *GAIN,
                                                double Texp,
                                                double Texp_master_dark,
                                                int extraction_window_size,
                                                double tolerance_reject,
                                                double ksig_extraction,
                                                int *cosmics_nb_RE,
                                                cpl_image **extr_spectr_RE,
                                                cpl_image **spectr_error_RE,
                                                cpl_image **spectr_qual_RE);

#endif /* ESPDR_EXTRACTION_H */
