/*
 * $Author: dsosnows $
 * $Date: 2013-08-06 14:31:16 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_PARAMETERS_H
#define ESPDR_PARAMETERS_H

/*----------------------------------------------------------------------------
                                    Includes
 ----------------------------------------------------------------------------*/

#include <cpl.h>

/*----------------------------------------------------------------------------
								Constants
 ----------------------------------------------------------------------------*/

#define SIGMA_CLIPPING_METHOD_LENGTH 10
#define KSIGMA_MIN 1.5
#define KSIGMA_MAX 1000
#define SIGMA_CLIP_MAX_ITER_MIN 1
#define SIGMA_CLIP_MAX_ITER_MAX 5000000

/*----------------------------------------------------------------------------
								Types
 ---------------------------------------------------------------------------*/

typedef enum {
	ESPDR_R_MBIAS,
    ESPDR_R_SINGLE_BIAS,
	ESPDR_R_MDARK,
	ESPDR_R_LED_FF,
	ESPDR_R_ORDERDEF,
	ESPDR_R_MFLAT,
	ESPDR_R_WAVE_FP,
	ESPDR_R_WAVE_THAR,
    ESPDR_R_WAVE_TH_DRIFT,
	ESPDR_R_WAVE_THAR_THAR,
	ESPDR_R_WAVE_LFC,
	ESPDR_R_WAVE_LFC_LFC,
	ESPDR_R_CONTAM,
	ESPDR_R_EFF_AB,
	ESPDR_R_FLUX,
	ESPDR_R_SCI_RED,
	ESPDR_R_COMPU_DRIFT,
    ESPDR_R_SHIFTED_EXTRACTION
} espdr_recipe_id;

typedef enum {
    ESPDR_SIG_CLIP_METHOD_MEAN,
    ESPDR_SIG_CLIP_METHOD_MEDIAN
} ESPDR_SIG_CLIP_METHOD;

/* Structure housing the BIAS parameters parameters */
typedef struct {
    const char *bias_sigma_clipping_method;
 	double bias_ksigma;
} espdr_BIAS_param;

/* Structure housing the OVERSCAN parameters parameters */
typedef struct {
	const char *ovsc_sigma_clipping_method;
	double ovsc_ksigma;
	int ovsc_max_iter;
	const char *bias_correction_method;
} espdr_OVSC_param;

/* Structure housing the parameters to compute RONs and MEANs */
typedef struct {
} espdr_stats_param;

/* Structure housing the DARK parameters parameters */
typedef struct {
	const char *dark_sigma_clipping_method;
	double dark_ksigma;
	const char *hotpixels_sigma_clipping_method;
	double hotpixels_ksigma;
	int hotpixels_max_iter;
} espdr_DARK_param;

/* Structure housing the original LED_FF parameters parameters */
typedef struct {
	const char *led_ff_sigma_clipping_method;
	double led_ff_ksigma;
	const char *badpixels_sigma_clipping_method;
	double badpixels_ksigma;
	int badpixels_max_iter;
} espdr_LED_FF_param;

typedef struct {
    //int nx;
    //int ny;
    int llx;
    int lly;
    int urx;
    int ury;
} espdr_window_coord;

/* Structure housing ORDERDEF parameters */
typedef struct {
} espdr_ORDERDEF_param;

/* Structure housing the FLAT parameters */
typedef struct {
    const char *flat_sigma_clipping_method;
    double flat_ksigma;
    const char *background_sw;
    int bkgr_grid_size_x;
    int bkgr_grid_size_y;
    const char *extraction_method;
    double ksig_extraction;
} espdr_FLAT_param;

/* Structure housing WAVE_FP parameters */
typedef struct {
	double ksig_extraction;
	const char *extraction_method;
} espdr_WAVE_FP_param;

/* Structure housing WAVE_THAR parameters */
typedef struct {
	double ksig_extraction;
	const char *extraction_method;
	int d_fit_poly_deg;
	double d_fit_small_res_limit;
	int wave_sol_poly_deg;
} espdr_WAVE_THAR_param;

/* Structure housing WAVE_TH_drift parameters */
typedef struct {
    double ksig_extraction;
    const char *extraction_method;
} espdr_WAVE_TH_drift_param;

/* Structure housing WAVE_LFC parameters */
typedef struct {
	double ksig_extraction;
	const char *extraction_method;
	int wave_sol_poly_deg;
} espdr_WAVE_LFC_param;

/* Structure housing WAVE_THAR_THAR parameters */
typedef struct {
} espdr_WAVE_THAR_THAR_param;

/* Structure housing WAVE_LFC_LFC parameters */
typedef struct {
} espdr_WAVE_LFC_LFC_param;

/* Structure housing the CAL_CONTAM parameters */
typedef struct {
    const char *background_sw;
    int bkgr_grid_size_x;
    int bkgr_grid_size_y;
    const char *extraction_method;
    double extraction_ksigma;
} espdr_CAL_CONTAM_param;

/* Structure housing the CAL_EFF_AB parameters */
typedef struct {
    int bkgr_grid_size_x;
    int bkgr_grid_size_y;
    int poly_deg;
    const char *extraction_method;
    double extraction_ksigma;
} espdr_CAL_EFF_AB_param;

/* Structure housing the CAL_FLUX parameters */
typedef struct {
    const char *background_sw;
    int bkgr_grid_size_x;
    int bkgr_grid_size_y;
    int poly_deg;
    const char *extraction_method;
    double extraction_ksigma;
} espdr_CAL_FLUX_param;

/* Structure housing the SCI_RED parameters */
typedef struct {
    const char *background_sw;
    int bkgr_grid_size_x;
    int bkgr_grid_size_y;
    const char *wave_cal_source;
    const char *mask_table_id;
    double rv_center;
    double rv_range;
    double rv_step;
    const char *extraction_method;
    double ksigma_cosmic;
    const char *bias_res_removal_sw;
    const char *flux_correction_type;
    const char *drift_correction_sw;
    const char *drift_method;
    const char *drift_space;
    double drift_ksigma;
    const char *sky_corr_method;
    int sky_sub_sliding_box_size;
    double slit_loss;
    int crh_detection_sw;
    int post_filter_x;
    int post_filter_y;
    const char* post_filter_mode;
    double lacosmic_sigma_lim;
    double lacosmic_f_lim;
    int lacosmic_max_iter;
    int telluric_corr_sw;
    cpl_boolean extra_products_sw;
} espdr_SCI_RED_param;

/* Structure housing the shifted extraction parameters */
typedef struct {
    const char *bias_res_removal_sw;
    const char *background_sw;
    int bkgr_grid_size_x;
    int bkgr_grid_size_y;
    int extraction_offset;
} espdr_shifted_extraction_param;


/*----------------------------------------------------------------------------
                            Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_parameters_new_double(const char* recipe_id, 
					 cpl_parameterlist* list,
					 const char* name, 
					 double value, 
					 const char* comment);
    
cpl_error_code espdr_parameters_new_range_double(const char* recipe_id,
                                                 cpl_parameterlist* list,
                                                 const char* name,
                                                 double value,
                                                 double min, double max,
                                                 const char* comment);
    
cpl_error_code espdr_parameters_new_bool(const char* recipe_id,
                                         cpl_parameterlist* list,
                                         const char* name,
                                         cpl_boolean value,
                                         const char* comment);

cpl_error_code espdr_parameters_new_int(const char* recipe_id,
					  cpl_parameterlist* list,
					  const char* name, 
					  int value, 
					  const char* comment);
    
cpl_error_code espdr_parameters_new_range_int(const char* recipe_id,
                                              cpl_parameterlist* list,
                                              const char* name,
                                              int value,
                                              int min, int max,
                                              const char* comment);
    
cpl_error_code espdr_parameters_new_string(const char* recipe_id,
						 cpl_parameterlist* list,
						 const char* name,
						 const char* value,
						 const char* comment);
    
cpl_error_code espdr_parameters_new_method(const char* recipe_id,
                                           cpl_parameterlist* list,
                                           const char* name,
                                           const char* value,
                                           const char* comment);
    
double espdr_parameters_get_double(const char* recipe_id,
                                 cpl_parameterlist* list, 
                                 const char* name);
    
cpl_boolean espdr_parameters_get_bool(const char* recipe_id,
                                      cpl_parameterlist* list,
                                      const char* name);

int espdr_parameters_get_int(const char* recipe_id, 
                           cpl_parameterlist* list, 
                           const char* name);
    
const char *espdr_parameters_get_string(const char* recipe_id, 
                                      cpl_parameterlist* list, 
                                      const char* name);

#endif
/**@}*/
