/*-----------------------------------------------------------------*/
/*!
  \file polynomial_interpolation.c
  \brief routines to perform lagrangian interpolations

  \author  H. Manche
           Astronomie et Systemes Dynamiques, IMCCE, CNRS, Observatoire de Paris.

   Copyright 2014, 2015, 2016, CNRS
   email of the author : herve.manche@obspm.fr

  last revision: 05/06/2014

  History:
  \note H. Manche 05/06/2014 : creation
 */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/


#include <stdio.h>
#include "polynomial_interpolation.h"

/*!
  Performs a lagrangian interpolation

  @param  n (in): number of constraints defining the polynom (corresponds to degree+1)
  @param xn (in): x[0:n-1] values where P in defined
  @param yn (in): values of P for all x[0:n-1] values
  @param  x (in): value where interpolation must be performed
 */

double LagrangianInterpolation(const int n, const double xn[n], const double yn[n], const double x)
{
  double div_diff[n][n] ;
  double yout ;
  int i,j ;


  for (i=0 ; i<n ; i++)
  {
    div_diff[i][0] = yn[i] ;
    /* for (int j=1; j<n ; j++) div_diff[i][j] = 1.0 ; */  /* initialisation not needed */
  }

  for (j=1; j<n ; j++)
  {
    for (i=0 ; i<n-j ; i++)
    {
      div_diff[i][j] = (div_diff[i+1][j-1]-div_diff[i][j-1])/(xn[i+j]-xn[i]) ;
    };
  }

  yout = div_diff[0][n-1] ;
  for (i=n-2 ; i>=0 ; i--) yout = yout*(x-xn[i])+div_diff[0][i] ;

  return yout;
};
