# import the needed modules
from __future__ import absolute_import
from __future__ import print_function
try:
#  import sys
  import numpy
  try:
    from astropy.io import fits as pyfits
  except ImportError:
    import pyfits 
  import espdr_parameters_common
#  import wx
#  import matplotlib
  import reflex
  #from xsh_plot_common import *
  from reflex import parseSofJson,RecipeParameter
  from reflex_interactive_app import PipelineInteractiveApp
  from pipeline_product import PipelineProduct
  from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay
#  matplotlib.use('WXAgg')
  import_sucess = 'true'
  import warnings
  warnings.simplefilter('ignore',UserWarning)

#NOTE for developers: 
# -If you want to modify the current script to cope
#  with different parameters, this is the function to modify:
#  setInteractiveParameters()
# -If you want to modify the current script to read different data from
#  the input FITS, these are the functions (class DataPlotterManager) to modify:
#  readFitsData()    to indicate what are the FITS input to plot
#  plotSpectrum()    to control 1D image product layout
#  plotImage()       to control 2D image product layout
#  plotTable()       to control 1D table product layout
#  oplotTable()      to control 1D table product overplots
#  setRecId()        to set rec id (used in parameter prefix)
#  getArmId()        to get arm id FITS header info
#
# -If you want to modify the current script to modify the plots (using the same
#  data),  this is the function to modify:
#  plotProductsGraphics()          (from class DataPlotterManager)
# -If you want to modify the text that appears in the "Help" button,
#  this is the function to modify:
#  setWindowHelp()
# -If you want to modify the title of the window, modify this function:
#  setWindowTitle()


  #This class deals with the specific details of data reading and final plotting.
  class DataPlotterManager:

    def paragraph(self,text, width=None):
       """ wrap text string into paragraph
           text:  text to format, removes leading space and newlines
           width: if not None, wraps text, not recommended for tooltips as
                  they are wrapped by wxWidgets by default
       """
       import textwrap
       #print 'width=',width,'Text=',text
       if width is None:
           return textwrap.dedent(text).replace('\n', ' ').strip()
       else:
           return textwrap.fill(textwrap.dedent(text), width=width) 


    #1D spectrum plots
    def plotSpectrum(self,data,errs,subplot,title,tooltip):
        data.readSpectrum(0)
        errs.readSpectrum(1)
        spectrum = SpectrumDisplay()
        spectrum.setLabels('Wavelength [nm]','Total Flux ['+data.bunit+']')
        spectrum.display(subplot,title,self.paragraph(tooltip),data.wave,data.flux,errs.flux, autolimits = True) 

    #2D image display
    def plotImage(self,obj,bpm,subplot,title,tooltip):

          obj.readImage(fits_extension=0)
          obj.read2DLinearWCS(fits_extension=0)
          img_obj = ImageDisplay()

          bpm.readImage(fits_extension=2)
          img_bpm = ImageDisplay()

          img_obj.setLabels('Wavelength [nm]','Position Along Slit [arcsec]')
          y_size, x_size = obj.image.shape

          img_obj.setXLinearWCSAxis(obj.crval1,obj.cdelt1,obj.crpix1)
          img_obj.setYLinearWCSAxis(obj.crval2,obj.cdelt2,obj.crpix2)

          #img_obj.setLimits((1,x_size),(0,y_size))
          img_obj.display(subplot, title, self.paragraph(tooltip),obj.image,bpm.image)

    #2D image display
    def plotImageSlice(self,obj,bpm,subplot,title,tooltip,Xlab,Ylab):

          obj.readImage(fits_extension=1)
          obj.read2DLinearWCS(fits_extension=1)
          img_obj = ImageDisplay()

          bpm.readImage(fits_extension=3)
          bpm.read2DLinearWCS(fits_extension=3)
          bpm_obj = ImageDisplay()

      

          img_obj.setLabels(Xlab,Ylab)
          y_size, x_size = obj.image.shape
          x = numpy.arange(0, x_size, 1)
          y = obj.all_hdu[1].data[10,:]
          print(y)
          print(x.shape)
          print(y.shape)

          img_obj.setXLinearWCSAxis(0,1,0)
          img_obj.setLabels(Xlab,Ylab)
          #img_bpm = ImageDisplay()
          #imadsp.display(subplot, title, tooltip, image)
   
          subplot.plot(x, y, color='blue')
          #img_obj.setLimits((1,x_size),(0,y_size))
          #img_obj.display(subplot, title, self.paragraph(tooltip),obj.image,bpm.image)

    def oplotImageScatter(self,img,tab,ext,binx,biny,Xcol,Ycol,subplot, marker = 'o', size = 10, color = 'blue' ):
          tab.readTableXYColumns(fits_extension=ext,xcolname=Xcol, ycolname=Ycol)
 
          #print tab.x_column
          #print tab.y_column
          #print binx,biny
          #img.overplotScatterDataSet=True
          print(marker, size, color)
          img.overplotScatter(tab.x_column/binx, tab.y_column/biny, marker, size, color)

    


    def oplotImageScatterTrace(self,tab,ext_ima,ext_tab,sx,binx,biny,subplot, marker = 'o', size = 10, color = 'blue' ):
          coeff_0 = tab.all_hdu[ext_tab].data.field('COEFF_0')
          coeff_1 = tab.all_hdu[ext_tab].data.field('COEFF_1')
          coeff_2 = tab.all_hdu[ext_tab].data.field('COEFF_2')
          coeff_3 = tab.all_hdu[ext_tab].data.field('COEFF_3')
          coeff_4 = tab.all_hdu[ext_tab].data.field('COEFF_4')

          #print "coeff_0=",coeff_0
          nrows=tab.all_hdu[ext_tab].data.shape[0]
          #print "nrows=",nrows,"sx=",sx
          x=numpy.linspace(1,sx,100)
          for i in range(nrows):
              #x = float(i)
              x2=x*x
              x3=x2*x
              x4=x2*x2
              y=coeff_0[i]+ \
                   coeff_1[i]*x+ \
                   coeff_2[i]*x2+ \
                   coeff_3[i]*x3+ \
                   coeff_4[i]*x4
              subplot.plot(x,y,marker=marker,color=color)
 

    def prepImageScatter(self,img_disp,obj,bpm,Xlab,Ylab):

          obj.readImage(fits_extension=0)
          obj.read2DLinearWCS(fits_extension=0)

          bpm.readImage(fits_extension=2)
          img_bpm = ImageDisplay()

          img_disp.setLabels(Xlab,Ylab)
          y_size, x_size = obj.image.shape

          img_disp.setXLinearWCSAxis(obj.crval1,obj.cdelt1,obj.crpix1)
          img_disp.setYLinearWCSAxis(obj.crval2,obj.cdelt2,obj.crpix2)

          #self.img_obj.setLimits((0,x_size),(0,y_size))

    def prepImageOrderdef(self,img_disp,obj,ext,Xlab,Ylab):

          obj.readImage(fits_extension=ext)
          obj.read2DLinearWCS(fits_extension=ext)

 
          img_disp.setLabels(Xlab,Ylab)
          y_size, x_size = obj.image.shape

          #img_disp.setXLinearWCSAxis(obj.crval1,obj.cdelt1,obj.crpix1)
          #img_disp.setYLinearWCSAxis(obj.crval2,obj.cdelt2,obj.crpix2)

          #self.img_obj.setLimits((0,x_size),(0,y_size))


    #2D image display
    def plotImageOrderdef(self,obj,ext_ima,ext_tab,binx,biny,Xlab,Ylab,Xcol1,Ycol1,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageOrderdef(img_disp,obj,ext_ima,Xlab,Ylab)

          sx = obj.all_hdu[ext_ima].header['NAXIS1']
          sy = obj.all_hdu[ext_ima].header['NAXIS2']
          x_lim = (0, sx)
          y_lim = (0, sy)
          img_disp.setLimits(x_lim,y_lim)
          #print "sx=",sx,"sy=",sy
 
          #As this image has intensities in the range 0-50 we need to rescale z
          if ext_ima == 1 :
             z_lim = (0,45)
          else :
             z_lim = (0,26)
          img_disp.setZLimits(z_lim)

          img_disp.display(subplot, title, self.paragraph(tooltip),obj.image)

          self.oplotImageScatterTrace(obj,ext_ima,ext_tab,sx,binx,biny,subplot, marker = '.', size = 1, color = 'green' )

          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])


    def plotImageWave(self,obj,tab,ext_ima,ext_tab,binx,biny,Xlab,Ylab,Xcol1,Ycol1,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageOrderdef(img_disp,obj,ext_ima,Xlab,Ylab)

          sx = obj.all_hdu[ext_ima].header['NAXIS1']
          sy = obj.all_hdu[ext_ima].header['NAXIS2']
          x_lim = (0, sx)
          y_lim = (0, sy)
          img_disp.setLimits(x_lim,y_lim)
          #print "sx=",sx,"sy=",sy
 
          img_disp.display(subplot, title, self.paragraph(tooltip),obj.image)

          print("Xcol1=",Xcol1)
          print("Ycol1=",Ycol1)

          self.oplotImageScatter(img_disp,tab,ext_tab,binx,biny,Xcol1,Ycol1,subplot, 'o', 10, 'green' )


          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])



    #1D spectrum plots
    def plotSpectrum(self,data,errs,qual,subplot,title,tooltip):
        data.readSpectrum(1)
        errs.readSpectrum(2)
        nwave = len(data.flux)
        minlimwave = int(nwave*0.25)
        maxlimwave = int(nwave*0.75)

        spectrum = SpectrumDisplay()
        spectrum.setLabels('Wavelength [nm]','Total Flux ['+data.bunit+']')

        spectrum.display(subplot,title,self.paragraph(tooltip),data.wave,data.flux,errs.flux, autolimits = True) 
        #matplotlib.pyplot.tight_layout()
        if self.response_found is True and self.rec_id[16:19] != "nod":
           #in case response is available we need to reduce fonts
           subplot.set_title(title, fontsize=7)
        try:
            subplot.figure.tight_layout()
        except AttributeError:
            pass

        #Flag BP as errors
        qual.readSpectrum(2)

        bpm_all = (qual.flux == 0 ) 
        mask_a_data=numpy.ma.MaskedArray(data.flux, mask=bpm_all).compressed()
        mask_a_wave=numpy.ma.MaskedArray(data.wave,mask=bpm_all).compressed()
        size_a_err=numpy.ma.MaskedArray(errs.flux,mask=bpm_all).compressed()
        #print "size all", mask_a_data.size
        if mask_a_data.size > 0 :
           subplot.errorbar(mask_a_wave, mask_a_data, xerr=None, yerr=size_a_err, color='k', linestyle='', capsize=0)
        #print "size masked", mask_f_data.size
        #print "size spectrum", data.flux.size
        if mask_f_data.size > 0 :
           subplot.errorbar(mask_f_wave, mask_f_data, xerr=None, yerr=size_f_err, color='r', linestyle='', capsize=0)
        subplot.set_xlim(spectrum.wave_lim)
        subplot.set_ylim(spectrum.flux_lim)
       



    def plotImageFlat(self,obj,ext_ima,binx,biny,Xlab,Ylab,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageOrderdef(img_disp,obj,ext_ima,Xlab,Ylab)

          sx = obj.all_hdu[ext_ima].header['NAXIS1']
          sy = obj.all_hdu[ext_ima].header['NAXIS2']
          x_lim = (0, sx)
          y_lim = (0, sy)
          img_disp.setLimits(x_lim,y_lim)
          #print "sx=",sx,"sy=",sy
 
          img_disp.display(subplot, title, self.paragraph(tooltip),obj.image)
          #self.plotSpectrum(obj,obj,obj,subplot,title,tooltip)


          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])

    def plotImageScatter1Col(self,obj,bpm,tab,ext,binx,biny,Xlab,Ylab,Xcol1,Ycol1,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageScatter(img_disp,obj,bpm,Xlab,Ylab)

          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol1,Ycol1,subplot, 'o', 10, 'green' )



          #bpm_filt = ( (bpm.image.astype(int) & self.decode_bp) != 0 )
          #img_disp.display(subplot, title, self.paragraph(tooltip),obj.image,bpm_filt)
          #img_disp.display(subplot, title, self.paragraph(tooltip),obj.image)
          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])

    #2D image display
    def plotImageScatter2Col(self,obj,bpm,tab,ext,binx,biny,Xlab,Ylab,Xcol1,Ycol1,Xcol2,Ycol2,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageScatter(img_disp,obj,bpm,Xlab,Ylab)

          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol1,Ycol1,subplot, 'o', 10, 'blue' )
          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol2,Ycol2,subplot, 'o', 10, 'yellow' )

          bpm_filt = ( (bpm.image.astype(int) & self.decode_bp) != 0 )
          img_disp.display(subplot, title, self.paragraph(tooltip),obj.image,bpm_filt)
          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])

    #2D image display
    def plotImageScatter3Col(self,obj,bpm,tab,ext,binx,biny,Xlab,Ylab,Xcol1,Ycol1,Xcol2,Ycol2,Xcol3,Ycol3,subplot,title,tooltip):

          img_disp = ImageDisplay()

          self.prepImageScatter(img_disp,obj,bpm,Xlab,Ylab)


          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol1,Ycol1,subplot, 'o', 10, 'blue' )
          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol2,Ycol2,subplot, 'o', 10, 'yellow' )
          self.oplotImageScatter(img_disp,tab,ext,binx,biny,Xcol3,Ycol3,subplot, 'o', 10, 'green' )

#          self.img_obj.setXLinearWCSAxis(img_obj.crval1,img_obj.cdelt1,img_obj.crpix1)

          bpm_filt = ( (bpm.image.astype(int) & self.decode_bp) != 0 )
          img_disp.display(subplot, title,self.paragraph(tooltip),obj.image,bpm_filt)
          #as the scatter display add extra space round the image (not
          #to have points at edges) we force the bounds of the scatter
          #plot to be the same as the image size.
          #subplot.set_xbound(0,obj.image.shape[1])
          #subplot.set_ybound(0,obj.image.shape[0])


    #1D spectrum table plots
    def plotTable(self,tab,Xcol,Ycol,Xlab,Ylab,subplot,title,tooltip,
    wave = None):

        tab.readTableXYColumns(fits_extension=1,xcolname=Xcol, ycolname=Ycol)
        spectrum = SpectrumDisplay()
        flux_plotmax = 1.2 * numpy.nanmax(tab.y_column)
        flux_plotmin = 0.0
        spectrum.setLabels(Xlab,Ylab)
        spectrum.flux_lim = flux_plotmin, flux_plotmax
        if wave is not None:
           spectrum.setWaveLimits((wave[0], wave[len(wave)-1]))

        spectrum.display(subplot,title,self.paragraph(tooltip),tab.x_column,tab.y_column) 

    #1D spectrum table over-plots
    def oplotTable(self,tab,Xcol,Ycol,Xlab,Ylab,subplot,color):

        tab.readTableXYColumns(fits_extension=1,xcolname=Xcol, ycolname=Ycol)
        spectrum = SpectrumDisplay()
        spectrum.overplot(subplot,tab.x_column,tab.y_column,color)


    def scatterPlotScatter(self, subplot, x, y):
        subplot.scatter(x, y, s=0.4, color='blue')
        subplot.ticklabel_format(style='sci',scilimits=(0,3))

    def scatterPlotLabels(self, subplot, x_label, y_label):
        subplot.set_xlabel(x_label, fontsize=12)
        subplot.set_ylabel(y_label, fontsize=12)

    def finalSetup(self, subplot, title, tooltip):
        subplot.grid(True)
        subplot.set_title(title, fontsize=12)
        subplot.tooltip = self.paragraph(tooltip)


    def scatterPlot(self, subplot, x, y, x_label, y_label, title, tooltip):

        self.scatterPlotScatter(subplot, x, y)
        self.scatterPlotLabels(subplot, x_label, y_label)
        self.scatterPlotLimits(subplot, x, y)
        self.finalSetup(subplot, title, self.paragraph(tooltip))

    def scatterPlotLimits(self, subplot, x, y):
        subplot.set_xlim(numpy.nanmin(x)-1, numpy.nanmax(x) + 1.)
        subplot.set_ylim(1.05 * numpy.nanmin(y), 1.05 * numpy.nanmax(y))



    #1D table scatter plots
    def plotTableScatter(self,tab,Xcol,Ycol,Xlab,Ylab,subplot,title,tooltip,ext_no=None):
        extno=1
        if ext_no != None :
           extno=ext_no

        tab.readTableXYColumns(fits_extension=extno,xcolname=Xcol,ycolname=Ycol)
        self.scatterPlotScatter(subplot, tab.x_column, tab.y_column)
        self.scatterPlotLabels(subplot, Xlab, Ylab)
        self.scatterPlotLimits(subplot, tab.x_column, tab.y_column)
        self.finalSetup(subplot, title, self.paragraph(tooltip))
        self.scatterPlot(subplot, tab.x_column, tab.y_column, Xlab, Ylab, title, tooltip)


    # This function will read all the columns, images and whatever is needed
    # from the products. The variables , self.plot_x, self.plot_y, etc...
    # are used later in function plotProductsGraphics().
    # Add/delete these variables as you need (only that plotProductsGraphics()
    # has to use the same names).
    # You can also create some additional variables (like statistics) after
    # reading the files.
    # If you use a control variable (self.xxx_found), you can modify 
    # later on the layout of the plotting window based on the presence of 
    # given input files. 
    # sof contains all the set of frames
    def readFitsData(self, fitsFiles):
      #Control variable to check if the interesting files where at the input
      #print fitsFiles
      
      self.resid_tab_found   = False
      self.edges_tab_found   = False
      self.order_tab_found = False
      self.fspectrum_a_found = True
      self.mflat_found = False
      self.wave_found = False
      self.cleaned_wave_found = False
      self.frameON_found      = False
      self.grid_back_found      = False
      self.sub_back_found   = False
      self.obj_sky2D_found   = False
      self.bpm_found   = False
      self.nima = 0
      self.binx = 1
      self.biny = 1
      
      #Read all the products
      frames = dict()
      for frame in fitsFiles:
        if frame == '' :
          continue

        header = pyfits.open(frame.name)
        #Make sure to have only products from the same recipe
        #that used this (common) script 
        if 'ESO PRO REC1 ID' in header[0].header :
           rec_id = header[0].header['ESO PRO REC1 ID']
           print("rec_id=", rec_id)
           if rec_id == self.rec_id :
              category = frame.category
              frames[category] = frame
              print("frame name:", frame.name)


      print("rec id:",rec_id)
      print(frames.keys())
 
 
# For any arm search a list of input frames
      #print frames
      key = "ORDER_TABLE_A"
      if key in frames :
        self.order_tab_found = True
        hdulist = frames[key]
        self.order_tab_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "ORDER_TABLE_B"
      if key in frames :
        self.order_tab_found = True
        hdulist = frames[key]
        self.order_tab_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True



      key = "FS2D_A"
      if key in frames :
        self.fs2d_a_found = True
        hdulist = frames[key]
        self.fs2d_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "FS2D_B"
      if key in frames :
        self.fs2d_b_found = True
        hdulist = frames[key]
        self.fs2d_b = PipelineProduct(hdulist)
        print("found", key)
        self.mflat_found = False
        self.frameON_found = True

      key = "FSPECTRUM_A"
      if key in frames :
        self.fspectrum_a_found = True
        hdulist = frames[key]
        self.fspectrum_a = PipelineProduct(hdulist)
        print("found", key)
        self.mflat_found = True
        self.frameON_found = True

      key = "FSPECTRUM_B"
      if key in frames :
        self.fspectrum_b_found = True
        hdulist = frames[key]
        self.fspectrum_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True


      key = "BLAZE_A"
      if key in frames :
        self.blaze_a_found = True
        hdulist = frames[key]
        self.blaze_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "BLAZE_B"
      if key in frames :
        self.blaze_b_found = True
        hdulist = frames[key]
        self.blaze_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "ORDER_PROFILE_A"
      if key in frames :
        self.order_profile_a_found = True
        hdulist = frames[key]
        self.order_profile_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "ORDER_PROFILE_B"
      if key in frames :
        self.order_profile_b_found = True
        hdulist = frames[key]
        self.order_profile_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True


      key = "TEST_PRODUCT"
      if key in frames :
        hdulist = frames[key]
        #pfile= hdulist[0].header['PIPEFILE']
        #print "pfile=",pfile
        pfile = "HARPS_cleaned_wave.fits"
        if pfile == "HARPS_cleaned_wave.fits" :
          self.cleaned_wave_found = True
          self.cleaned_wave = PipelineProduct(hdulist)
          print("found", key)
          self.frameON_found = True
          self.wave_found = True


      key = "S2D_THAR_THAR_A"
      if key in frames :
        self.s2d_thar_thar_a_found = True
        hdulist = frames[key]
        self.s2d_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True
        self.wave_found = True

      key = "S2D_THAR_THAR_B"
      if key in frames :
        self.s2d_thar_thar_b_found = True
        hdulist = frames[key]
        self.s2d_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True


      key = "WAVE_MATRIX_THAR_THAR_A"
      if key in frames :
        self.wave_matrix_thar_thar_a_found = True
        hdulist = frames[key]
        self.wave_matrix_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "WAVE_MATRIX_THAR_THAR_B"
      if key in frames :
        self.wave_matrix_thar_thar_b_found = True
        hdulist = frames[key]
        self.wave_matrix_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "DLL_MATRIX_THAR_THAR_A"
      if key in frames :
        self.dll_matrix_thar_thar_a_found = True
        hdulist = frames[key]
        self.dll_matrix_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "DLL_MATRIX_THAR_THAR_B"
      if key in frames :
        self.dll_matrix_thar_thar_b_found = True
        hdulist = frames[key]
        self.dll_matrix_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "RES_MAP_THAR_THAR_A"
      if key in frames :
        self.res_map_thar_thar_a_found = True
        hdulist = frames[key]
        self.res_map_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "RES_MAP_THAR_THAR_B"
      if key in frames :
        self.res_map_thar_thar_b_found = True
        hdulist = frames[key]
        self.res_map_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True


      key = "LINE_TABLE_THAR_THAR_A"
      if key in frames :
        self.line_table_thar_thar_a_found = True
        hdulist = frames[key]
        self.line_table_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "LINE_TABLE_THAR_THAR_B"
      if key in frames :
        self.line_table_thar_thar_b_found = True
        hdulist = frames[key]
        self.line_table_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True



      key = "LINE_TABLE_RAW_THAR_THAR_A"
      if key in frames :
        self.line_table_raw_thar_thar_a_found = True
        hdulist = frames[key]
        self.line_table_raw_thar_thar_a = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True

      key = "LINE_TABLE_RAW_THAR_THAR_B"
      if key in frames :
        self.line_table_raw_thar_thar_b_found = True
        hdulist = frames[key]
        self.line_table_raw_thar_thar_b = PipelineProduct(hdulist)
        print("found", key)
        self.frameON_found = True





      key = "ORDERPOS_RESID_TAB_"
      if key in frames :
        self.resid_tab_found = True
        hdulist = frames["ORDERPOS_RESID_TAB_"]
        self.resid_tab = PipelineProduct(hdulist)
        #self.resid_tab_2plot = PlotableResidLineTable(hdulist,1)
        #self.nima += 1
        #print "found orderpos resid tab"


      key = "ORDER_TAB_EDGES_SLIT_"
      if key in frames :
        self.edges_tab_found = True
        hdulist = frames["ORDER_TAB_EDGES_SLIT_"]
        self.edges_tab = PipelineProduct(hdulist)
        #self.nima += 1
        #print "found edges tab"

      key = "ORDER_TAB_EDGES_IFU_"
      if key in frames :
        self.edges_tab_found = True
        hdulist = frames["ORDER_TAB_EDGES_IFU_"]
        self.edges_tab = PipelineProduct(hdulist)
        #self.nima += 1
        #print "found edges tab"
        
      key = "ON_"
      if key in frames :
        self.frameON_found = True
        hdulist = frames[key]
        self.bpm = PipelineProduct(hdulist)
        self.frameON = PipelineProduct(hdulist)
        #self.nima += 1
        #print "found on frame"

      key = "MASTER_FLAT_SLIT_"
      if key in frames :
        self.mflat_found = True
        fitsfile = frames["MASTER_FLAT_SLIT_"]
        self.bpm = PipelineProduct(fitsfile)
        self.mflat = PipelineProduct(fitsfile)
        hdulist = pyfits.open(fitsfile.name)
        #print "found mflat frame",self.mflat_found
        #print "Bin setting",self.binx,self.biny

      key = "MASTER_FLAT_IFU_"
      if key in frames :
        self.mflat_found = True
        fitsfile = frames["MASTER_FLAT_IFU_"]
        self.bpm = PipelineProduct(fitsfile)
        self.mflat = PipelineProduct(fitsfile)
        hdulist = pyfits.open(fitsfile.name)
        #print "found mflat frame",self.mflat_found
        #print "Bin setting",self.binx,self.biny


      key = "GRID_BACK_SLIT_"
      if key in frames :
        self.grid_back_found = True
        hdulist = frames[key]
        self.grid_back = PipelineProduct(hdulist)
        #print "found grid background"

      key = "GRID_BACK_IFU_"
      if key in frames :
        self.grid_back_found = True
        hdulist = frames[key]
        self.grid_back = PipelineProduct(hdulist)
        #print "found grid background"

      key = "SUB_BACK_SLIT_"
      if key in frames :
        self.sub_back_found = True
        hdulist = frames["SUB_BACK_SLIT_"]
        self.sub_back = PipelineProduct(hdulist)
        #print "found background subtracted frame"

      #print "monitor mflat",self.mflat_found

    #Set rec id (to have proper recipe parameters prefix)
    def setRecId(self, rec_id):
      #Recipe ID variable to properly define params
      self.rec_id = rec_id

    #Get arm setting
    def getArmId(self, sof):
      #Recipe ID variable to properly define params
      self.rec_id = "espdr_mbias"
      nf = 0

      frames = dict()
      files = sof.files
      for f in files:
        frame=f.name
        if frame == '' :
          continue
        else :
           nf += 1
           hdulist = pyfits.open(frame)
           rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
      if nf != 0 :
         self.rec_id = rec_id_list[0:]

      print("self.rec_id", self.rec_id)
      if self.rec_id == "espdr_mbias" or self.rec_id == "mbias":
         self.rec_subtitle = "Master Bias. "
      if self.rec_id == "espdr_mdark" or self.rec_id == "mdark":
         self.rec_subtitle = "Master Dark. "
      if self.rec_id == "espdr_orderdef" or self.rec_id == "orderdef":
         self.rec_subtitle = "Order Tracing. "
      if self.rec_id == "espdr_mflat" or self.rec_id == "mflat":
         self.rec_subtitle = "Master Flat Creation. "
      if self.rec_id == "espdr_wave" or self.rec_id == "wave":
         self.rec_subtitle = "Wavelength Calibration. "
            
    # This function creates all the subplots. It is responsible for the plotting 
    # layouts. 
    # There can different layouts, depending on the availability of data
    # Note that subplot(I,J,K) means the Kth plot in a IxJ grid 
    # Note also that the last one is actually a box with text, no graphs.
    def addSubplots(self, figure):
      nrows=self.nima
      row=1;
      #print "nrows=",nrows,row
      #print "resid_tab_found",self.resid_tab_found, "frameON_found",self.frameON_found
      print("self.fspectrum_a_found=",self.fspectrum_a_found)
      print("self.order_tab_found=",self.order_tab_found)
      print("self.mflat_found=",self.mflat_found)
      print("self.wave_found=",self.wave_found)

      if self.order_tab_found == True :
        #orderdef recipe
        self.subplot_frame_a1  = figure.add_subplot(2,1,1)
        self.subplot_frame_a2  = figure.add_subplot(2,1,2)
        #self.subplot_frame_b1  = figure.add_subplot(2,2,3)
        #self.subplot_frame_b2  = figure.add_subplot(2,2,4)
        row +=1

      elif self.fspectrum_a_found == True and self.mflat_found == True: 
        #flat recipe
        #self.subplot_mflat  = figure.add_subplot(nrows,1,row)
        self.subplot_mflat  = figure.add_subplot(2,1,1)
        self.subplot_spectrum  = figure.add_subplot(2,1,2)
        row +=1
        
        print("monitor mflat",self.mflat_found)

      elif self.wave_found == True and self.cleaned_wave_found == True:
        #wave recipe
        #self.subplot_mflat  = figure.add_subplot(nrows,1,row)
        self.subplot_arc  = figure.add_subplot(1,1,1)
        row +=1
        
        print("monitor mflat",self.mflat_found)

      else : 
        self.subtext_nodata    = figure.add_subplot(1,1,1)
        #print "found no spectrum data"
      #print "nrows=",nrows,row

          
    # This is the function that makes the plots.
    # Add new plots or delete them using the given scheme.
    # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
    # It is mandatory to add a tooltip variable to each subplot.
    # One might be tempted to merge addSubplots() and plotProductsGraphics().
    # There is a reason not to do it: addSubplots() is called only once at
    # startup, while plotProductsGraphics() is called always there is a resize.
    def plotProductsGraphics(self):
      #print "arc check:",  self.resid_tab_found, self.frameON_found
      #print "mfat check:",  self.edges_tab_found, self.mflat_found
      if (self.order_tab_found == True) or \
         (self.fspectrum_a_found == True and self.mflat_found == True) or \
         (self.wave_found == True): 
        #and self.lineguess_found == True 
        title_pref = 'Linear-extracted and Merged Spectrum.'          

        tooltip_spectrum ="""\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """


        title_spectrum   = title_pref

           
           
        #Display ON frame

        #Overplot initial list of lines
        #Overplot gauss list of lines
        #Overplot final list of lines

        #Scatter plot ResidX(lambda)
        #Scatter plot ResidY(lambda)

        #Scatter plot X(lambda)
        #Scatter plot Y(lambda)


        #Image
        spec_frameON   = ''
        print("Recipe ID:",self.rec_id)
        if self.rec_id == "wave" :

           spec_frame_a   = 'Arc Lamp fib A '
           spec_frame_b   = 'Arc Lamp fib B '
           tooltip_frameON ="""\
           Bias corrected fibre arc lamp image. 
           Green points trace each detected lines. 
           Red points trace not well detected lines 
           """
           spec_frameON   = 'Arc lamp pinhole '
           tooltip_frameON ="""\
           Bias (and dark) corrected arc lamp pinhole
           image. Blue points are the predicted positions of the arc lines
           in the reference arc line list using the initial physical
           model. Yellow points are the positions of those predicted
           lines that are successfully found and fitted by a two-dimensional
           Gaussian. Green points are the line positions which remain after
           thresholding the Gaussian fits for signal-to-noise and
           refining the physical model fit.  
           A red hue corresponds to flagged pixels, which
           may be good or bad.
          """

        elif self.rec_id == "orderdef" :
           spec_frame_a   = 'Orderdef flat fib A '
           spec_frame_b   = 'Orderdef flat fib B '
           tooltip_frameON ="""\
           Bias corrected fibre flat lamp 
           image. Green points trace each detected order. 
           """

        elif self.rec_id == "mflat" :
           spec_frame_a   = 'flat fib A '
           spec_frame_b   = 'flat fib B '
           tooltip_frameON ="""\
           Bias corrected fibre flat lamp 
           image. 
           """

        
        title_frame_a   = spec_frame_a+'Image'
        title_frame_b   = spec_frame_b+'Image'

        title_mflat   = 'Master flat frame'
        tooltip_mflat ="""\
                Image of the bias (dark) corrected master flat
                frame. Over are displayed order central traces (blue), and
                order detected  edges (left-yellow, right-green). 
                A red hue corresponds to flagged pixels, which
                may be good or bad.
                """


        title_plot_residX   = 'X Residual vs wavelength ' 
        tooltip_plot_residX ="""\
                             X Residual vs wavelength."""

        title_plot_residY   = 'Y Residual vs wavelength ' 
        tooltip_plot_residY ="""\
                             Y Residual vs wavelength."""

        title_plot_X   = 'X vs wavelength ' 
        tooltip_plot_X ="""\
                        X vs wavelength."""

        title_plot_Y   = 'Y vs wavelength ' 
        tooltip_plot_Y ="""\
                        Y vs wavelength."""


        #2D frame PRE format (predict/orderpos/2dmap/wavecal/flexcomp)
        #print "arc check:",  self.resid_tab_found, self.frameON_found
        print("Recipe ID:",self.rec_id)
        if (self.order_tab_found == True or \
            self.mflat_found == True or \
            self.wave_found == True) and \
            self.frameON_found == True:

           if self.rec_id == "wave" :
              print("do wave plot")
              self.plotImageWave(self.cleaned_wave,self.line_table_raw_thar_thar_a,1,1, self.binx,self.biny,'X [pix]', 'Y [pix]', 'X0', 'Y0', self.subplot_arc,title_frame_a,tooltip_frameON)


           if self.rec_id == "orderdef" :
              print("do orderdef plot")


              self.plotImageOrderdef(self.order_tab_a,1,3, self.binx,self.biny,'X [pix]', 'Y [pix]', 'X', 'Y', self.subplot_frame_a1,title_frame_a,tooltip_frameON)
              self.plotImageOrderdef(self.order_tab_a,2,4, self.binx,self.biny,'X [pix]', 'Y [pix]', 'X', 'Y', self.subplot_frame_a2,title_frame_a,tooltip_frameON)
              #self.plotImageOrderdef(self.order_tab_b,1,3, self.binx,self.biny,'X [pix]', 'Y [pix]', 'X', 'Y', self.subplot_frame_b1,title_frame_b,tooltip_frameON)
              #self.plotImageOrderdef(self.order_tab_b,2,4, self.binx,self.biny,'X [pix]', 'Y [pix]', 'X', 'Y', self.subplot_frame_b2,title_frame_b,tooltip_frameON)

           if self.rec_id == "mflat" :
              print("display mflat")
              self.plotImageFlat(self.fs2d_a,1, self.binx,self.biny,'X [pix]', 'Y [pix]', self.subplot_mflat,title_frame_a,tooltip_frameON)


              self.plotImageSlice(self.fs2d_a,self.fs2d_a,self.subplot_spectrum,title_frame_a,tooltip_frameON,'X [pix]','ADU');

        #2D master flat (mflat (slit/ifu))
        #print "mfat check:",  self.edges_tab_found, self.mflat_found
        if self.edges_tab_found == True and self.mflat_found  == True :
             self.plotImageScatter3Col(self.mflat,self.bpm,self.edges_tab,
        2, self.binx, self.biny,'X [pix]', 'Y [pix]', 'CENTER_X', 'CENTER_Y', 'EDG_LO_X', 'CENTER_Y','EDG_UP_X', 'CENTER_Y', self.subplot_mflat,title_mflat,tooltip_mflat)



        #Scatter plot: set titles and labels
        if self.resid_tab_found == True  and \
          (self.rec_id[4:12] == "predict" or \
           self.rec_id == "wave") :

           title_resid_x_tab   = 'Line X residuals.' 
           tooltip_resid_x_tab ="""\
                Plot of the line position residuals in X versus wavelength."""

           title_resid_y_tab   = 'Line Y residuals.' 
           tooltip_resid_y_tab ="""\
                 Plot of the line position residuals in Y versus wavelength."""

        elif self.resid_tab_found == True  and \
             self.rec_id[4:13] == "orderpos" :

           title_resid_x_tab   = 'Trace X residuals vs X' 
           tooltip_resid_x_tab ="""\
                                Plot of trace position X residuals versus X."""
           title_resid_y_tab   = 'Trace X residuals vs Y' 
           tooltip_resid_y_tab ="""\
                                Plot of trace position X residuals versus Y."""

        #Scatter plot: make the plot
        print("recipe id: ", self.rec_id) 
        if self.resid_tab_found == True  and \
          (self.rec_id[4:12] == "predict" or \
           self.rec_id == "wave" or \
           self.rec_id[4:13] == "orderpos") :
            if self.rec_id[4:12] == "predict" or self.rec_id == "wave" :
               #print "resid tab"
               self.plotTableScatter(self.resid_tab,
        'Wavelength','ResidXModel', 'Wavelength [nm]','Line position residuals in X [pix]',self.subplot_resid_x_tab,title_resid_x_tab, tooltip_resid_x_tab)
               self.plotTableScatter(self.resid_tab, 'Wavelength','ResidYModel', 'Wavelength [nm]','Line position residuals in Y [pix]',self.subplot_resid_y_tab,title_resid_y_tab, tooltip_resid_y_tab)
            elif self.rec_id[4:13] == "orderpos" :
               self.plotTableScatter(self.resid_tab, 'X','RESX', 'X Position [pix]','X Residuals [pix]',self.subplot_resid_x_tab,title_resid_x_tab, tooltip_resid_x_tab)
               self.plotTableScatter(self.resid_tab, 'Y','RESX', 'Y Position [pix]','X Residuals [pix]',self.subplot_resid_y_tab,title_resid_y_tab, tooltip_resid_y_tab)
 
      else :
        #Data not found info
        self.subtext_nodata.set_axis_off()
        self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
        self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c', 
                                 fontsize=18, ha='left', va='center', alpha=1.0)
        self.subtext_nodata.tooltip="""\
                                    Merged spectrum not found in the products"""
        #print "found no spectrum data"
 
  
    # This function specifies which are the parameters that should be presented
    # in the window to be edited.
    # Note that the parameter has to be also in the in_sop port (otherwise it 
    # won't appear in the window) 
    # The descriptions are used to show a tooltip. They should match one to one
    # with the parameter list 
    # Note also that parameters have to be prefixed by the 'recipe name:'

    def setInteractiveParameters(self):
      paramList = list()
      rec_id=self.rec_id
      self.par = espdr_parameters_common.Parameters()
      #self.par.setGeneralCalibParameters(paramList,rec_id)
  
      if rec_id == "bias" :
         self.par.setDetectArclinesParameters(paramList,rec_id)
         self.par.setModelParameters(paramList,rec_id)

      elif rec_id == "mdark" :
         self.par.setDetectArclinesParameters(paramList,rec_id)
         
      elif rec_id == "orderdef" :
         self.par.setOrderdefParameters(paramList,"espdr_orderdef","all")

      elif rec_id == "mflat" :
         self.par.setFlatParameters(paramList,"espdr_mflat","all")

      elif rec_id == "wave" :
         self.par.setDetectArclinesParameters(paramList,rec_id)
         self.par.setModelParameters(paramList,rec_id)

      elif rec_id == "wavecal" :
         print("found wavecal params")

      elif rec_id == "flexcomp" :
         print("found flexcomp params")
      else :
         print("recipe" ,rec_id,  "not supported")

      return paramList

    def setWindowHelp(self):
      help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
      return help_text

    def setWindowTitle(self):
      title = 'ESPRESSO Interactive ' + self.rec_subtitle  
      return title

except ImportError:
  import_sucess = 'false'
  print("Error importing modules pyfits, wx, matplotlib, numpy")
  raise

