# import the needed modules
from __future__ import absolute_import
from __future__ import print_function

try:
    import reflex

    import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")

# import the needed modules
try:
    #  import sys
    import numpy

    try:
        from astropy.io import fits as pyfits
    except ImportError:
        import pyfits

    import espdr_discrete_slider
    import espdr_plot_common
    import espdr_parameters_common
    #  import wx
    #  import matplotlib
    import reflex
    # from xsh_plot_common import *
    from reflex import parseSofJson, RecipeParameter
    from reflex_interactive_app import PipelineInteractiveApp
    import reflex_plot_widgets

    from pipeline_product import PipelineProduct
    from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay

    #  matplotlib.use('WXAgg')
    import_sucess = 'true'
    import warnings

    warnings.simplefilter('ignore', UserWarning)


    # NOTE for developers:
    # -If you want to modify the current script to cope
    #  with different parameters, this is the function to modify:
    #  setInteractiveParameters()
    # -If you want to modify the current script to read different data from
    #  the input FITS, these are the functions (class DataPlotterManager) to modify:
    #  readFitsData()    to indicate what are the FITS input to plot
    #  setRecId()        to set rec id (used in parameter prefix)
    #  getArmId()        to get arm id FITS header info
    #
    # -If you want to modify the current script to modify the plots (using the same
    #  data),  this is the function to modify:
    #  plotProductsGraphics()          (from class DataPlotterManager)
    # -If you want to modify the text that appears in the "Help" button,
    #  this is the function to modify:
    #  setWindowHelp()
    # -If you want to modify the title of the window, modify this function:
    #  setWindowTitle()

    # This class deals with the specific details of data reading and final plotting.
    class DataPlotterManager:

        # This function will read all the columns, images and whatever is needed
        # from the products. The variables , self.plot_x, self.plot_y, etc...
        # are used later in function plotProductsGraphics().
        # Add/delete these variables as you need (only that plotProductsGraphics()
        # has to use the same names).
        # You can also create some additional variables (like statistics) after
        # reading the files.
        # If you use a control variable (self.xxx_found), you can modify
        # later on the layout of the plotting window based on the presence of
        # given input files.
        # sof contains all the set of frames
        def readFitsData(self, fitsFiles):
            # Control variable to check if the interesting files where at the input
            self.fspectrum_a_found = True
            self.mflat_found = False
            self.nima = 0
            self.binx = 1
            self.ext_ima = 1
            self.biny = 1
            self.fibre_id = "fib A"
            self.order_id = 10
            self.ord_max = 170
            self.labels_prod = list()
            # self.obj_info = ' extracted flat image. '

            self.product_id = 'FS2D_A'

            # Read all the products
            frames = dict()
            # print fitsFiles
            for frame in fitsFiles:
                if frame == '':
                    continue

                header = pyfits.open(frame.name)
                # print frame.name
                # Make sure to have only products from the same recipe
                # that used this (common) script
                if 'ESO PRO REC1 ID' in header[0].header:
                    rec_id = header[0].header['ESO PRO REC1 ID']
                    # print "rec_id=", rec_id,"self.rec_id=", self.rec_id, frame.name
                    if rec_id == self.rec_id:
                        category = frame.category
                        frames[category] = frame
                        print("frame name:", frame.name)

            # For any arm search a list of input frames
            # print frames
            key = "FS2D_A"
            if key in frames:
                self.fs2d_a_found = True
                hdulist = frames[key]
                self.fs2d_a = PipelineProduct(hdulist)
                # print("found", key)
                self.labels_prod.append(key)
                self.mflat_found = True

            key = "FS2D_B"
            if key in frames:
                self.fs2d_b_found = True
                hdulist = frames[key]
                self.fs2d_b = PipelineProduct(hdulist)
                # print("found", key)
                self.mflat_found = True
                self.labels_prod.append(key)

            key = "FSPECTRUM_A"
            if key in frames:
                self.fspectrum_a_found = True
                hdulist = frames[key]
                self.fspectrum_a = PipelineProduct(hdulist)
                # print("found", key)
                self.mflat_found = True
                self.labels_prod.append(key)
                self.snr_a = list()
                self.order_num_a = list()
                key = 'ESO INS MODE'
                self.ins_mode = self.fspectrum_a.readKeyword(key)

                # print(self.ins_mode)
                if self.ins_mode == 'SINGLEHR':
                    self.ord_max = 170
                    self.instrume = 'ESPRESSO'
                elif self.ins_mode == 'HA':
                    self.instrume = 'NIRPS'
                    self.ord_max = 71
                elif self.ins_mode == 'HARPS':
                    self.instrume = 'HARPS'
                    self.ord_max = 71
                elif self.ins_mode == 'HE':
                    self.instrume = 'NIRPS'
                    self.ord_max = 71
                elif self.ins_mode == 'EGGS':
                    self.instrume = 'HARPS'
                    self.ord_max = 71
                else:
                    self.instrume = 'ESPRESSO'
                    self.ord_max = 86

                # print(self.ord_max)
                for ord in range(1, self.ord_max):
                    key = 'ESO QC ORDER%#.d SNR' % ord
                    self.order_num_a.append(ord)
                    self.snr_a.append(self.fspectrum_a.readKeyword(key))
            key = 'ESO QC FLAT CHECK'
            self.qc_flat_check = self.fspectrum_a.readKeyword(key)

            key = "FSPECTRUM_B"
            if key in frames:
                self.fspectrum_b_found = True
                hdulist = frames[key]
                self.fspectrum_b = PipelineProduct(hdulist)
                # print("found", key)
                self.labels_prod.append(key)
                self.snr_b = list()
                self.order_num_b = list()
                for ord in range(1, self.ord_max):
                    key = 'ESO QC ORDER%#.d SNR' % ord
                    self.order_num_b.append(ord)
                    self.snr_b.append(self.fspectrum_b.readKeyword(key))
            key = 'ESO QC FLAT CHECK'
            self.qc_flat_check = self.fspectrum_b.readKeyword(key)

            key = "BLAZE_A"
            if key in frames:
                self.blaze_a_found = True
                hdulist = frames[key]
                self.blaze_a = PipelineProduct(hdulist)
                # print("found", key)
                self.labels_prod.append(key)

            key = "BLAZE_B"
            if key in frames:
                self.blaze_b_found = True
                hdulist = frames[key]
                self.blaze_b = PipelineProduct(hdulist)
                # print("found", key)
                self.labels_prod.append(key)

            key = "ORDER_PROFILE_A"
            if key in frames:
                self.order_profile_a_found = True
                hdulist = frames[key]
                self.order_profile_a = PipelineProduct(hdulist)
                # print("found", key)
                self.labels_prod.append(key)

            key = "ORDER_PROFILE_B"
            if key in frames:
                self.order_profile_b_found = True
                hdulist = frames[key]
                self.order_profile_b = PipelineProduct(hdulist)
                # print("found", key)
                self.labels_prod.append(key)

        # Set rec id (to have proper recipe parameters prefix)
        def setRecId(self, rec_id):
            # Recipe ID variable to properly define params
            self.rec_id = rec_id

        # Get arm setting
        def getArmId(self, sof):
            # Recipe ID variable to properly define params
            self.rec_id = "espdr_mflat"
            self.instrume = 'Undefined'
            nf = 0

            frames = dict()
            files = sof.files
            for f in files:
                frame = f.name
                self.rec_id = "espdr_mflat"
                if frame == '':
                    continue
                else:
                    nf += 1
                    hdulist = pyfits.open(frame)
                    rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
                    self.instrume = hdulist[0].header['INSTRUME']
            if nf != 0:
                # self.rec_id = rec_id_list[0:]
                # print("frame:", frame, "rec_id", self.rec_id)
                pass

                # print("self.rec_id==>", self.rec_id)
            if self.rec_id == "espdr_mflat":
                self.rec_subtitle = "Master Flat Creation. "

            # print(self.rec_subtitle)

        # This function creates all the subplots. It is responsible for the plotting
        # layouts.
        # There can different layouts, depending on the availability of data
        # Note that subplot(I,J,K) means the Kth plot in a IxJ grid
        # Note also that the last one is actually a box with text, no graphs.
        def addSubplots(self, figure):
            nrows = self.nima
            row = 1;
            if self.fspectrum_a_found == True and self.mflat_found == True:
                self.subplot_image = figure.add_subplot(3, 1, 1)
                self.subplot_spectrum = figure.add_subplot(3, 1, 2)
                self.subplot_scatter = figure.add_subplot(3, 1, 3)
                row += 1

                self.product_selector = figure.add_axes([0.05, 0.85, 0.25, 0.15])
                #        self.product_selector = figure.add_axes([0.05, 0.85, 0.25, 0.15],aspect='equal')
                self.order_selector = figure.add_axes([0.60, 0.98, 0.35, 0.02])

            else:
                self.subtext_nodata = figure.add_subplot(1, 1, 1)

        def plotData(self, fibre_id):
            self.plotProductsGraphics()

        def plotWidgets(self):
            widgets = list()

            labels_prod = self.labels_prod
            self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.product_selector,
                                                                               self.setProductSelectCallBack,
                                                                               labels_prod, 0, title="")
            widgets.append(self.radiobutton_pro)

            min = 0
            val = self.order_id
            self.val = val
            max = self.ima_sy
            title_slider = "Select order no by clicking with mouse left button"
            self.slider = espdr_discrete_slider.InteractiveSlider2(self.order_selector, self.setOrderSelectCallBack,
                                                                   min, max, val, 1, "order no")
            widgets.append(self.slider)

            # self.order_id=self.val

            return widgets

        def setOrderSelectCallBack(self, order_id):

            self.order_id = int(order_id)
            self.subplot_spectrum.cla()
            self.plotSpectrum()

        def setProductSelectCallBack(self, product_id):
            self.product_id = product_id

            p_len = len(self.product_id)
            # print 'self.product_id[-1]:',self.product_id[-1]
            if self.product_id[-1] == 'B':
                self.ext_ima = 2
                self.fibre_id = 'fib B'

            else:
                self.ext_ima = 1
                self.fibre_id = 'fib A'

            self.subplot_image.cla()
            self.subplot_spectrum.cla()
            self.plotImage()
            self.plotSpectrum()

        def preparePlotImage(self):
            # print('product_id',self.product_id)
            if self.product_id == 'FS2D_A':
                self.obj = self.fs2d_a
                self.spc = self.fs2d_a
                self.obj_info = ' extracted master flat image. '
                # print 'selected ', self.product_id

            elif self.product_id == 'FS2D_B':
                self.obj = self.fs2d_b
                self.spc = self.fs2d_b
                self.obj_info = ' extracted master flat image. '
                # print 'selected ', self.product_id

            elif self.product_id == 'BLAZE_A':
                self.obj = self.blaze_a
                self.spc = self.blaze_a
                self.obj_info = ' extracted blaze image. '
                # print 'selected ', self.product_id

            elif self.product_id == 'BLAZE_B':
                self.obj = self.blaze_b
                self.spc = self.blaze_b
                self.obj_info = ' extracted blaze image. '
                # print 'selected ', self.product_id

            elif self.product_id == 'FSPECTRUM_A':
                self.obj = self.fspectrum_a
                self.spc = self.fspectrum_a
                self.obj_info = ' extracted flat '
                # print 'selected ', self.product_id

            elif self.product_id == 'FSPECTRUM_B':
                self.obj = self.fspectrum_b
                self.spc = self.fspectrum_b
                self.obj_info = ' extracted flat '
                # print 'selected ', self.product_id

            elif self.product_id == 'ORDER_PROFILE_A':
                self.obj = self.order_profile_a
                self.spc = self.order_profile_a
                self.obj_info = ' cross order profile image. '
                # print 'selected ', self.product_id

            elif self.product_id == 'ORDER_PROFILE_B':
                self.obj = self.order_profile_b
                self.spc = self.order_profile_b

                self.obj_info = ' cross order profile image. '
                # print 'selected ', self.product_id
            self.obj_info = self.fibre_id + self.obj_info
            # print('obj_info',self.obj_info)
            # print self.product_id[0:13]
            if self.product_id[0:13] == 'ORDER_PROFILE' and self.instrume == 'ESPRESSO':
                self.ext_ima = 2
            else:
                self.ext_ima = 1
            # print(self.ext_ima)

            sy = self.obj.all_hdu[self.ext_ima].header['NAXIS2']
            self.ima_sy = sy

        def preparePlotQC(self):
            pass

        def defTitleObject(self):
            if self.product_id == 'FS2D_A':
                title_object = ' [Extracted Master Flat]'
            elif self.product_id == 'FS2D_B':
                title_object = ' [Extracted Master Flat]'
            elif self.product_id == 'BLAZE_A':
                title_object = ' [Blaze]'
            elif self.product_id == 'BLAZE_B':
                title_object = ' [Blaze]'
            elif self.product_id == 'FSPECTRUM_A':
                title_object = ' [Flat]'
            elif self.product_id == 'FSPECTRUM_B':
                title_object = ' [Flat]'
            elif self.product_id == 'ORDER_PROFILE_A':
                title_object = ' [Order Profile]'
            elif self.product_id == 'ORDER_PROFILE_B':
                title_object = ' [Order Profile]'
            self.title_object = title_object

        def prepTitleAndTooltipSpectrum(self):
            self.tooltip_spectrum = "Spectrum corresponding to Bias corrected "
            self.tooltip_spectrum = self.tooltip_spectrum + self.obj_info
            if 'ORDER_PROFILE' in self.product_id:
                pass
            else:
                self.tooltip_spectrum = self.tooltip_spectrum + \
                                        "Select on the slider above to choose the order to display."

        def prepTitleAndTooltipImage(self):
            title_pref = 'Linear-extracted and Merged Spectrum.'

            tooltip_spectrum = """\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """
            title_spectrum = title_pref

            # Image
            spec_frameON = ''
            # print "Recipe ID:",self.rec_id

            if self.rec_id == "espdr_mflat":
                if self.fibre_id == 'fib A':
                    self.spec_frame = '               fib A '
                else:
                    self.spec_frame = '               fib B '

                tooltip_frameON = """
           Bias corrected fibre flat lamp 
           image. 
           """

            self.defTitleObject()
            self.title_frame = self.spec_frame + self.title_object
            self.dpm.verify_qc_check(self.subplot_image, self.qc_flat_check, 1.1)

            self.tooltip_frame = self.fibre_id + self.title_object

            self.title_mflat = 'Master flat frame'
            self.tooltip_mflat = "Image of the bias corrected "
            self.tooltip_mflat = self.tooltip_mflat + self.tooltip_frame

        def plotImage(self):
            self.prepTitleAndTooltipImage()
            self.preparePlotImage()
            if 'Order Profile' in self.title_frame:
                yLab = 'Y [pix]'
                self.tooltip_mflat = self.tooltip_mflat + \
                                     " (X,Y)."
            else:
                yLab = 'Order number'
                self.tooltip_mflat = self.tooltip_mflat + \
                                     " (wavelength, order)."

            self.dpm.plotImageOnly(self.obj, self.ext_ima, self.binx, self.biny, 'X [pix]', yLab, self.subplot_image,
                                   self.title_frame, self.tooltip_mflat)

        def plotSpectrum(self):
            self.prepTitleAndTooltipSpectrum()
            if 'Order Profile' in self.title_frame:
                xLab = 'Y [pix]'
                type = 'v-plot'
            else:
                xLab = 'X [pix]'
                type = 'h-plot'

            self.dpm.plotImageSlice2(self.spc, self.spc, self.order_id, self.subplot_spectrum, self.title_frame,
                                     self.tooltip_spectrum, xLab, 'ADU', type)

        def plotQC(self):
            self.preparePlotQC()
            self.tooltip = 'plot of SNR vs order.'
            self.tooltip_note = " The two colors (blue and green) corresponds to results obtained for Slices 1 and 2 respectively"
            self.tooltip = self.tooltip + self.tooltip_note

            self.dpm.scatterPlotScatter3(self.subplot_scatter, self.order_num_a, self.snr_a, 'order number', 'SNR',
                                         'SNR vs order', self.tooltip)

        def caseNodata(self):
            # Data not found info
            self.subtext_nodata.set_axis_off()
            self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
            self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c',
                                     fontsize=18, ha='left', va='center', alpha=1.0)
            self.subtext_nodata.tooltip = """\
                                    Merged spectrum not found in the products"""
            # print "found no spectrum data"

        # This is the function that makes the plots.
        # Add new plots or delete them using the given scheme.
        # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
        # It is mandatory to add a tooltip variable to each subplot.
        # One might be tempted to merge addSubplots() and plotProductsGraphics().
        # There is a reason not to do it: addSubplots() is called only once at
        # startup, while plotProductsGraphics() is called always there is a resize.
        def plotProductsGraphics(self):
            if (self.fspectrum_a_found == True and self.mflat_found == True):

                self.dpm = espdr_plot_common.DataPlotterManager()
                self.plotImage()
                self.plotSpectrum()
                self.plotQC()
            else:
                self.caseNodata()

        # This function specifies which are the parameters that should be presented
        # in the window to be edited.
        # Note that the parameter has to be also in the in_sop port (otherwise it
        # won't appear in the window)
        # The descriptions are used to show a tooltip. They should match one to one
        # with the parameter list
        # Note also that parameters have to be prefixed by the 'recipe name:'

        def setInteractiveParameters(self):
            paramList = list()
            rec_id = self.rec_id
            self.par = espdr_parameters_common.Parameters()

            if rec_id == "espdr_mflat":
                self.par.setFlatParameters(paramList, "espdr_mflat", "all")

            else:
                print("recipe", rec_id, "not supported")

            return paramList

        def setWindowHelp(self):
            help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
            return help_text

        def setWindowTitle(self):
            title = self.instrume + ' Interactive Workflow: ' + self.rec_subtitle
            return title

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")
    raise

# This is the 'main' function
if __name__ == '__main__':

    # import reflex modules
    from reflex import *
    from reflex_interactive_app import *
    from pipeline_display import *
    from pipeline_product import *

    # Create interactive application
    interactive_app = PipelineInteractiveApp(enable_init_sop=True)

    # PECULIAR XSH needs this in order to be able later to get from an input FITS
    # the ins-mode, arm (and recipe) IDs, used in titles and param setting
    # get inputs from the command line
    interactive_app.parse_args()
    inputs = interactive_app.inputs
    # (inputs, args) = interactive_app.parse_args()

    # Check if import failed or not
    # print("import_sucess=", import_sucess)
    if import_sucess == 'false':
        interactive_app.setEnableGUI(false)

    # interactive_app.setEnableGUI(True)
    # Open the interactive window if enabled
    if interactive_app.isGUIEnabled():
        # Get the specific functions for this window
        dataPlotManager = DataPlotterManager()
        # print inputs.in_sof
        # dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
        # With the following call XSH get the: ins-mode, arm (and recipe) IDs
        dataPlotManager.getArmId(inputs.in_sof)
        # Set recipe ID in order to build proper param list, display layout
        dataPlotManager.setRecId("espdr_mflat")
        interactive_app.setPlotManager(dataPlotManager)
        interactive_app.showGUI()

    else:
        interactive_app.passProductsThrough()

    # Print outputs. This is parsed by the Reflex python actor to get the results
    # Do not remove
    interactive_app.print_outputs()
    sys.exit()
