/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_SHIFTED_EXTRACTION_CAL_H
#define ESPDR_SHIFTED_EXTRACTION_CAL_H


/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dark.h>
#include <espdr_overscan.h>
#include <espdr_bias.h>
#include <espdr_blaze.h>
//#include <espdr_fit.h>
#include <espdr_led_flat.h>
#include <espdr_detector_signature.h>
//#include <espdr_extraction.h>
//#include <espdr_pixels.h>
#include <espdr_shifted_extraction_cal.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
#define SAVE_DEBUG_PRODUCT_SHIFTED_EXTRACTION 0
#define SAVE_DEBUG_CCD_CLEANED_SHIFTED_EXTRACTION 0


/*----------------------------------------------------------------------------
 Data structures
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_shifted_extraction(cpl_parameterlist *parameters, cpl_frameset *frameset,
                             const char* recipe_id);

cpl_error_code espdr_parameters_shifted_extraction_create(const char* recipe_id,
                                                          cpl_parameterlist *list,
                                                          espdr_shifted_extraction_param *p);

cpl_error_code espdr_parameters_shifted_extraction_delete(espdr_shifted_extraction_param* p);

cpl_error_code espdr_parameters_shifted_extraction_get(const char* recipe_id,
                                              cpl_parameterlist* param_list,
                                              espdr_shifted_extraction_param *shifted_extraction_param);

cpl_error_code espdr_parameters_shifted_extraction_print(espdr_shifted_extraction_param *shifted_extraction_param);

espdr_shifted_extraction_param *espdr_shifted_extraction_param_init(const char *recipe_id,
                                                                    cpl_parameterlist *parameters);

cpl_error_code espdr_get_shifted_extraction_params(espdr_inst_config *inst_config,
                                                   cpl_parameterlist *parameters,
                                                   espdr_shifted_extraction_param *shifted_extraction_param,
                                                   char *fibre_b,
                                                   char *bias_res_removal_sw,
                                                   int *remove_bias_res_flag,
                                                   char *background_sw,
                                                   int *bkgr_grid_size_x,
                                                   int *bkgr_grid_size_y,
                                                   int *extraction_offset);

cpl_error_code espdr_process_ghost_till_extraction(cpl_frameset *frameset,
                                                   cpl_parameterlist *parameters,
                                                   const char *RECIPE_ID,
                                                   cpl_frame *raw_frame,
                                                   cpl_frameset *used_frames,
                                                   espdr_inst_config *inst_config,
                                                   espdr_CCD_geometry *CCD_geom,
                                                   espdr_qc_keywords *qc_kws,
                                                   cpl_propertylist *keywords,
                                                   int remove_bias_res_flag,
                                                   char *fibre_b,
                                                   char *background_sw,
                                                   int bkgr_grid_size_x,
                                                   int bkgr_grid_size_y,
                                                   int extraction_offset,
                                                   double *ron,
                                                   int *cosmics_nb,
                                                   double *snr_per_fibre,
                                                   cpl_image **flat_corr_flux_RE,
                                                   cpl_image **flat_corr_err_RE,
                                                   cpl_image **flat_corr_qual_RE);

cpl_error_code espdr_shifted_extraction_one_fibre(cpl_imagelist *input_images,
                                                  cpl_imagelist *hot_bad_pixels_mask,
                                                  cpl_imagelist *saturation_mask,
                                                  cpl_mask **crh_mask_whole,
                                                  cpl_imagelist *background,
                                                  cpl_imagelist *order_profile,
                                                  cpl_imagelist *master_dark,
                                                  cpl_table **orders_coeffs,
                                                  int fibre_nr,
                                                  espdr_inst_config *inst_config,
                                                  espdr_CCD_geometry *CCD_geom,
                                                  double *RON,
                                                  double *DARK,
                                                  double *GAIN,
                                                  double Texp,
                                                  double Texp_master_dark,
                                                  int extraction_window_size,
                                                  double tolerance_reject,
                                                  double ksig_extraction,
                                                  int extraction_offset,
                                                  int *cosmics_nb_RE,
                                                  cpl_image **extr_spectr_RE,
                                                  cpl_image **spectr_error_RE,
                                                  cpl_image **spectr_qual_RE);

cpl_error_code espdr_shifted_extraction_QC(espdr_CCD_geometry *CCD_geom,
                                           espdr_inst_config *inst_config,
                                           espdr_qc_keywords *qc_kws,
                                           char *fibre_B_src,
                                           int *cosmics_nb,
                                           double *snr,
                                           int orders_nr,
                                           double *ron_RE,
                                           int extraction_offset,
                                           cpl_propertylist **keywords_RE);

cpl_error_code espdr_save_ghost_S2D_products(cpl_frameset *frameset,
                                             cpl_parameterlist *parameters,
                                             const char *recipe_id,
                                             cpl_frameset *used_frames,
                                             const char *GHOST_tag,
                                             int extraction_offset,
                                             cpl_propertylist *keywords,
                                             espdr_inst_config *inst_config,
                                             cpl_image *flat_corr_spectrum,
                                             cpl_image *flat_corr_error,
                                             cpl_image *flat_corr_qual);

#endif /* ESPDR_SHIFTED_EXTRACTION_CAL_H */
